/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import org.apache.iceberg.BaseSnapshot;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.DeleteFile;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.GenericManifestFile;
import org.apache.iceberg.ManifestContent;
import org.apache.iceberg.ManifestEntry;
import org.apache.iceberg.ManifestFile;
import org.apache.iceberg.ManifestFiles;
import org.apache.iceberg.ManifestListWriter;
import org.apache.iceberg.ManifestLists;
import org.apache.iceberg.ManifestReader;
import org.apache.iceberg.ManifestWriter;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.PartitionSummary;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.SnapshotUpdate;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.TableOperations;
import org.apache.iceberg.events.Listeners;
import org.apache.iceberg.exceptions.CommitFailedException;
import org.apache.iceberg.exceptions.RuntimeIOException;
import org.apache.iceberg.io.OutputFile;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.relocated.com.google.common.collect.Sets;
import org.apache.iceberg.shaded.com.github.benmanes.caffeine.cache.Caffeine;
import org.apache.iceberg.shaded.com.github.benmanes.caffeine.cache.LoadingCache;
import org.apache.iceberg.util.Exceptions;
import org.apache.iceberg.util.Tasks;
import org.apache.iceberg.util.ThreadPools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class SnapshotProducer<ThisT>
implements SnapshotUpdate<ThisT> {
    private static final Logger LOG = LoggerFactory.getLogger(SnapshotProducer.class);
    static final Set<ManifestFile> EMPTY_SET = Sets.newHashSet();
    private final Consumer<String> defaultDelete = new Consumer<String>(){

        @Override
        public void accept(String file) {
            SnapshotProducer.this.ops.io().deleteFile(file);
        }
    };
    private final LoadingCache<ManifestFile, ManifestFile> manifestsWithMetadata;
    private final TableOperations ops;
    private final String commitUUID = UUID.randomUUID().toString();
    private final AtomicInteger manifestCount = new AtomicInteger(0);
    private final AtomicInteger attempt = new AtomicInteger(0);
    private final List<String> manifestLists = Lists.newArrayList();
    private volatile Long snapshotId = null;
    private TableMetadata base;
    private boolean stageOnly = false;
    private Consumer<String> deleteFunc = this.defaultDelete;

    protected SnapshotProducer(TableOperations ops) {
        this.ops = ops;
        this.base = ops.current();
        this.manifestsWithMetadata = Caffeine.newBuilder().build(file -> {
            if (file.snapshotId() != null) {
                return file;
            }
            return SnapshotProducer.addMetadata(ops, file);
        });
    }

    protected abstract ThisT self();

    @Override
    public ThisT stageOnly() {
        this.stageOnly = true;
        return this.self();
    }

    @Override
    public ThisT deleteWith(Consumer<String> deleteCallback) {
        Preconditions.checkArgument(this.deleteFunc == this.defaultDelete, "Cannot set delete callback more than once");
        this.deleteFunc = deleteCallback;
        return this.self();
    }

    protected abstract void cleanUncommitted(Set<ManifestFile> var1);

    protected abstract String operation();

    protected void validate(TableMetadata currentMetadata) {
    }

    protected abstract List<ManifestFile> apply(TableMetadata var1);

    @Override
    public Snapshot apply() {
        this.base = this.refresh();
        Long parentSnapshotId = this.base.currentSnapshot() != null ? Long.valueOf(this.base.currentSnapshot().snapshotId()) : null;
        long sequenceNumber = this.base.nextSequenceNumber();
        this.validate(this.base);
        List<ManifestFile> manifests = this.apply(this.base);
        if (this.base.formatVersion() > 1 || this.base.propertyAsBoolean("write.manifest-lists.enabled", true)) {
            OutputFile manifestList = this.manifestListPath();
            try (ManifestListWriter writer = ManifestLists.write(this.ops.current().formatVersion(), manifestList, this.snapshotId(), parentSnapshotId, sequenceNumber);){
                this.manifestLists.add(manifestList.location());
                ManifestFile[] manifestFiles = new ManifestFile[manifests.size()];
                Tasks.range(manifestFiles.length).stopOnFailure().throwFailureWhenFinished().executeWith(ThreadPools.getWorkerPool()).run(index -> {
                    manifestFiles[index.intValue()] = this.manifestsWithMetadata.get((ManifestFile)manifests.get((int)index));
                });
                writer.addAll((Iterable<ManifestFile>)Arrays.asList(manifestFiles));
            }
            catch (IOException e) {
                throw new RuntimeIOException(e, "Failed to write manifest list file", new Object[0]);
            }
            return new BaseSnapshot(this.ops.io(), sequenceNumber, this.snapshotId(), parentSnapshotId, System.currentTimeMillis(), this.operation(), this.summary(this.base), manifestList.location());
        }
        return new BaseSnapshot(this.ops.io(), this.snapshotId(), parentSnapshotId, System.currentTimeMillis(), this.operation(), this.summary(this.base), manifests);
    }

    protected abstract Map<String, String> summary();

    private Map<String, String> summary(TableMetadata previous) {
        Map<String, String> summary = this.summary();
        if (summary == null) {
            return ImmutableMap.of();
        }
        Map<Object, Object> previousSummary = previous.currentSnapshot() != null ? (previous.currentSnapshot().summary() != null ? previous.currentSnapshot().summary() : ImmutableMap.of()) : ImmutableMap.of("total-records", "0", "total-data-files", "0", "total-delete-files", "0", "total-position-deletes", "0", "total-equality-deletes", "0");
        ImmutableMap.Builder<String, String> builder = ImmutableMap.builder();
        builder.putAll(summary);
        SnapshotProducer.updateTotal(builder, previousSummary, "total-records", summary, "added-records", "deleted-records");
        SnapshotProducer.updateTotal(builder, previousSummary, "total-data-files", summary, "added-data-files", "deleted-data-files");
        SnapshotProducer.updateTotal(builder, previousSummary, "total-delete-files", summary, "added-delete-files", "removed-delete-files");
        SnapshotProducer.updateTotal(builder, previousSummary, "total-position-deletes", summary, "added-position-deletes", "removed-position-deletes");
        SnapshotProducer.updateTotal(builder, previousSummary, "total-equality-deletes", summary, "added-equality-deletes", "removed-equality-deletes");
        return builder.build();
    }

    protected TableMetadata current() {
        return this.base;
    }

    protected TableMetadata refresh() {
        this.base = this.ops.refresh();
        return this.base;
    }

    @Override
    public void commit() {
        AtomicLong newSnapshotId = new AtomicLong(-1L);
        try {
            Tasks.foreach(this.ops).retry(this.base.propertyAsInt("commit.retry.num-retries", 4)).exponentialBackoff(this.base.propertyAsInt("commit.retry.min-wait-ms", 100), this.base.propertyAsInt("commit.retry.max-wait-ms", 60000), this.base.propertyAsInt("commit.retry.total-timeout-ms", 1800000), 2.0).onlyRetryOn((Class<Exception>)CommitFailedException.class).run(taskOps -> {
                Snapshot newSnapshot = this.apply();
                newSnapshotId.set(newSnapshot.snapshotId());
                TableMetadata updated = this.stageOnly ? this.base.addStagedSnapshot(newSnapshot) : this.base.replaceCurrentSnapshot(newSnapshot);
                if (updated == this.base) {
                    return;
                }
                taskOps.commit(this.base, updated.withUUID());
            });
        }
        catch (RuntimeException e) {
            Exceptions.suppressAndThrow(e, this::cleanAll);
        }
        LOG.info("Committed snapshot {} ({})", (Object)newSnapshotId.get(), (Object)this.getClass().getSimpleName());
        try {
            Snapshot saved = this.ops.refresh().snapshot(newSnapshotId.get());
            if (saved != null) {
                this.cleanUncommitted(Sets.newHashSet(saved.allManifests()));
                for (String manifestList : this.manifestLists) {
                    if (saved.manifestListLocation().equals(manifestList)) continue;
                    this.deleteFile(manifestList);
                }
            } else {
                LOG.warn("Failed to load committed snapshot, skipping manifest clean-up");
            }
        }
        catch (RuntimeException e) {
            LOG.warn("Failed to load committed table metadata, skipping manifest clean-up", (Throwable)e);
        }
        this.notifyListeners();
    }

    private void notifyListeners() {
        try {
            Object event = this.updateEvent();
            if (event != null) {
                Listeners.notifyAll(event);
            }
        }
        catch (RuntimeException e) {
            LOG.warn("Failed to notify listeners", (Throwable)e);
        }
    }

    protected void cleanAll() {
        for (String manifestList : this.manifestLists) {
            this.deleteFile(manifestList);
        }
        this.manifestLists.clear();
        this.cleanUncommitted(EMPTY_SET);
    }

    protected void deleteFile(String path) {
        this.deleteFunc.accept(path);
    }

    protected OutputFile manifestListPath() {
        return this.ops.io().newOutputFile(this.ops.metadataFileLocation(FileFormat.AVRO.addExtension(String.format("snap-%d-%d-%s", this.snapshotId(), this.attempt.incrementAndGet(), this.commitUUID))));
    }

    protected OutputFile newManifestOutput() {
        return this.ops.io().newOutputFile(this.ops.metadataFileLocation(FileFormat.AVRO.addExtension(this.commitUUID + "-m" + this.manifestCount.getAndIncrement())));
    }

    protected ManifestWriter<DataFile> newManifestWriter(PartitionSpec spec) {
        return ManifestFiles.write(this.ops.current().formatVersion(), spec, this.newManifestOutput(), this.snapshotId());
    }

    protected ManifestWriter<DeleteFile> newDeleteManifestWriter(PartitionSpec spec) {
        return ManifestFiles.writeDeleteManifest(this.ops.current().formatVersion(), spec, this.newManifestOutput(), this.snapshotId());
    }

    protected ManifestReader<DataFile> newManifestReader(ManifestFile manifest) {
        return ManifestFiles.read(manifest, this.ops.io(), this.ops.current().specsById());
    }

    protected ManifestReader<DeleteFile> newDeleteManifestReader(ManifestFile manifest) {
        return ManifestFiles.readDeleteManifest(manifest, this.ops.io(), this.ops.current().specsById());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long snapshotId() {
        if (this.snapshotId == null) {
            SnapshotProducer snapshotProducer = this;
            synchronized (snapshotProducer) {
                if (this.snapshotId == null) {
                    this.snapshotId = this.ops.newSnapshotId();
                }
            }
        }
        return this.snapshotId;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static ManifestFile addMetadata(TableOperations ops, ManifestFile manifest) {
        try (ManifestReader<DataFile> reader = ManifestFiles.read(manifest, ops.io(), ops.current().specsById());){
            PartitionSummary stats = new PartitionSummary(ops.current().spec(manifest.partitionSpecId()));
            int addedFiles = 0;
            long addedRows = 0L;
            int existingFiles = 0;
            long existingRows = 0L;
            int deletedFiles = 0;
            long deletedRows = 0L;
            Long snapshotId = null;
            long maxSnapshotId = Long.MIN_VALUE;
            for (ManifestEntry manifestEntry : reader.entries()) {
                if (manifestEntry.snapshotId() > maxSnapshotId) {
                    maxSnapshotId = manifestEntry.snapshotId();
                }
                switch (manifestEntry.status()) {
                    case ADDED: {
                        ++addedFiles;
                        addedRows += ((DataFile)manifestEntry.file()).recordCount();
                        if (snapshotId != null) break;
                        snapshotId = manifestEntry.snapshotId();
                        break;
                    }
                    case EXISTING: {
                        ++existingFiles;
                        existingRows += ((DataFile)manifestEntry.file()).recordCount();
                        break;
                    }
                    case DELETED: {
                        ++deletedFiles;
                        deletedRows += ((DataFile)manifestEntry.file()).recordCount();
                        if (snapshotId != null) break;
                        snapshotId = manifestEntry.snapshotId();
                        break;
                    }
                }
                stats.update(((DataFile)manifestEntry.file()).partition());
            }
            if (snapshotId == null) {
                snapshotId = maxSnapshotId;
            }
            GenericManifestFile genericManifestFile = new GenericManifestFile(manifest.path(), manifest.length(), manifest.partitionSpecId(), ManifestContent.DATA, manifest.sequenceNumber(), manifest.minSequenceNumber(), snapshotId, addedFiles, addedRows, existingFiles, existingRows, deletedFiles, deletedRows, stats.summaries());
            return genericManifestFile;
        }
        catch (IOException e) {
            throw new RuntimeIOException(e, "Failed to read manifest: %s", manifest.path());
        }
    }

    private static void updateTotal(ImmutableMap.Builder<String, String> summaryBuilder, Map<String, String> previousSummary, String totalProperty, Map<String, String> currentSummary, String addedProperty, String deletedProperty) {
        String totalStr = previousSummary.get(totalProperty);
        if (totalStr != null) {
            try {
                long newTotal = Long.parseLong(totalStr);
                String addedStr = currentSummary.get(addedProperty);
                if (newTotal >= 0L && addedStr != null) {
                    newTotal += Long.parseLong(addedStr);
                }
                String deletedStr = currentSummary.get(deletedProperty);
                if (newTotal >= 0L && deletedStr != null) {
                    newTotal -= Long.parseLong(deletedStr);
                }
                if (newTotal >= 0L) {
                    summaryBuilder.put(totalProperty, String.valueOf(newTotal));
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }
}

