/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.nio.ByteBuffer;
import java.util.List;
import org.apache.iceberg.BaseFile;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.FileContent;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.Metrics;
import org.apache.iceberg.PartitionData;
import org.apache.iceberg.avro.AvroSchemaUtil;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.shaded.org.apache.avro.Schema;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;

class GenericDataFile
extends BaseFile<DataFile>
implements DataFile {
    GenericDataFile(Schema avroSchema) {
        super(avroSchema);
    }

    GenericDataFile(int specId, String filePath, FileFormat format, PartitionData partition, long fileSizeInBytes, Metrics metrics, ByteBuffer keyMetadata, List<Long> splitOffsets) {
        super(specId, FileContent.DATA, filePath, format, partition, fileSizeInBytes, metrics.recordCount(), metrics.columnSizes(), metrics.valueCounts(), metrics.nullValueCounts(), metrics.lowerBounds(), metrics.upperBounds(), splitOffsets, null, keyMetadata);
    }

    private GenericDataFile(GenericDataFile toCopy, boolean fullCopy) {
        super(toCopy, fullCopy);
    }

    GenericDataFile() {
    }

    @Override
    public DataFile copyWithoutStats() {
        return new GenericDataFile(this, false);
    }

    @Override
    public DataFile copy() {
        return new GenericDataFile(this, true);
    }

    @Override
    protected Schema getAvroSchema(Types.StructType partitionStruct) {
        Types.StructType type = DataFile.getType(partitionStruct);
        return AvroSchemaUtil.convert((Type)type, ImmutableMap.of(type, GenericDataFile.class.getName(), partitionStruct, PartitionData.class.getName()));
    }
}

