/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.data.parquet;

import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.iceberg.parquet.ParquetTypeVisitor;
import org.apache.iceberg.parquet.ParquetValueWriter;
import org.apache.iceberg.parquet.ParquetValueWriters;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.parquet.Preconditions;
import org.apache.parquet.column.ColumnDescriptor;
import org.apache.parquet.io.api.Binary;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.LogicalTypeAnnotation;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;

public abstract class BaseParquetWriter<T> {
    private static final OffsetDateTime EPOCH = Instant.ofEpochSecond(0L).atOffset(ZoneOffset.UTC);
    private static final LocalDate EPOCH_DAY = EPOCH.toLocalDate();

    protected ParquetValueWriter<T> createWriter(MessageType type) {
        return (ParquetValueWriter)ParquetTypeVisitor.visit((Type)type, (ParquetTypeVisitor)new WriteBuilder(type));
    }

    protected abstract ParquetValueWriters.StructWriter<T> createStructWriter(List<ParquetValueWriter<?>> var1);

    private static class FixedWriter
    extends ParquetValueWriters.PrimitiveWriter<byte[]> {
        private FixedWriter(ColumnDescriptor desc) {
            super(desc);
        }

        public void write(int repetitionLevel, byte[] value) {
            this.column.writeBinary(repetitionLevel, Binary.fromReusedByteArray((byte[])value));
        }
    }

    private static class TimestamptzWriter
    extends ParquetValueWriters.PrimitiveWriter<OffsetDateTime> {
        private TimestamptzWriter(ColumnDescriptor desc) {
            super(desc);
        }

        public void write(int repetitionLevel, OffsetDateTime value) {
            this.column.writeLong(repetitionLevel, ChronoUnit.MICROS.between(EPOCH, value));
        }
    }

    private static class TimestampWriter
    extends ParquetValueWriters.PrimitiveWriter<LocalDateTime> {
        private TimestampWriter(ColumnDescriptor desc) {
            super(desc);
        }

        public void write(int repetitionLevel, LocalDateTime value) {
            this.column.writeLong(repetitionLevel, ChronoUnit.MICROS.between(EPOCH, value.atOffset(ZoneOffset.UTC)));
        }
    }

    private static class TimeWriter
    extends ParquetValueWriters.PrimitiveWriter<LocalTime> {
        private TimeWriter(ColumnDescriptor desc) {
            super(desc);
        }

        public void write(int repetitionLevel, LocalTime value) {
            this.column.writeLong(repetitionLevel, value.toNanoOfDay() / 1000L);
        }
    }

    private static class DateWriter
    extends ParquetValueWriters.PrimitiveWriter<LocalDate> {
        private DateWriter(ColumnDescriptor desc) {
            super(desc);
        }

        public void write(int repetitionLevel, LocalDate value) {
            this.column.writeInteger(repetitionLevel, (int)ChronoUnit.DAYS.between(EPOCH_DAY, value));
        }
    }

    private static class LogicalTypeWriterVisitor
    implements LogicalTypeAnnotation.LogicalTypeAnnotationVisitor<ParquetValueWriters.PrimitiveWriter<?>> {
        private final ColumnDescriptor desc;

        private LogicalTypeWriterVisitor(ColumnDescriptor desc) {
            this.desc = desc;
        }

        public Optional<ParquetValueWriters.PrimitiveWriter<?>> visit(LogicalTypeAnnotation.StringLogicalTypeAnnotation stringType) {
            return Optional.of(ParquetValueWriters.strings((ColumnDescriptor)this.desc));
        }

        public Optional<ParquetValueWriters.PrimitiveWriter<?>> visit(LogicalTypeAnnotation.EnumLogicalTypeAnnotation enumType) {
            return Optional.of(ParquetValueWriters.strings((ColumnDescriptor)this.desc));
        }

        public Optional<ParquetValueWriters.PrimitiveWriter<?>> visit(LogicalTypeAnnotation.DecimalLogicalTypeAnnotation decimalType) {
            switch (this.desc.getPrimitiveType().getPrimitiveTypeName()) {
                case INT32: {
                    return Optional.of(ParquetValueWriters.decimalAsInteger((ColumnDescriptor)this.desc, (int)decimalType.getPrecision(), (int)decimalType.getScale()));
                }
                case INT64: {
                    return Optional.of(ParquetValueWriters.decimalAsLong((ColumnDescriptor)this.desc, (int)decimalType.getPrecision(), (int)decimalType.getScale()));
                }
                case FIXED_LEN_BYTE_ARRAY: 
                case BINARY: {
                    return Optional.of(ParquetValueWriters.decimalAsFixed((ColumnDescriptor)this.desc, (int)decimalType.getPrecision(), (int)decimalType.getScale()));
                }
            }
            return Optional.empty();
        }

        public Optional<ParquetValueWriters.PrimitiveWriter<?>> visit(LogicalTypeAnnotation.DateLogicalTypeAnnotation dateType) {
            return Optional.of(new DateWriter(this.desc));
        }

        public Optional<ParquetValueWriters.PrimitiveWriter<?>> visit(LogicalTypeAnnotation.TimeLogicalTypeAnnotation timeType) {
            return Optional.of(new TimeWriter(this.desc));
        }

        public Optional<ParquetValueWriters.PrimitiveWriter<?>> visit(LogicalTypeAnnotation.TimestampLogicalTypeAnnotation timestampType) {
            Preconditions.checkArgument((boolean)LogicalTypeAnnotation.TimeUnit.MICROS.equals((Object)timestampType.getUnit()), (String)"Cannot write timestamp in %s, only MICROS is supported", (Object[])new Object[]{timestampType.getUnit()});
            if (timestampType.isAdjustedToUTC()) {
                return Optional.of(new TimestamptzWriter(this.desc));
            }
            return Optional.of(new TimestampWriter(this.desc));
        }

        public Optional<ParquetValueWriters.PrimitiveWriter<?>> visit(LogicalTypeAnnotation.IntLogicalTypeAnnotation intType) {
            Preconditions.checkArgument((intType.isSigned() || intType.getBitWidth() < 64 ? 1 : 0) != 0, (String)"Cannot read uint64: not a supported Java type");
            if (intType.getBitWidth() < 64) {
                return Optional.of(ParquetValueWriters.ints((ColumnDescriptor)this.desc));
            }
            return Optional.of(ParquetValueWriters.longs((ColumnDescriptor)this.desc));
        }

        public Optional<ParquetValueWriters.PrimitiveWriter<?>> visit(LogicalTypeAnnotation.JsonLogicalTypeAnnotation jsonLogicalType) {
            return Optional.of(ParquetValueWriters.strings((ColumnDescriptor)this.desc));
        }

        public Optional<ParquetValueWriters.PrimitiveWriter<?>> visit(LogicalTypeAnnotation.BsonLogicalTypeAnnotation bsonType) {
            return Optional.of(ParquetValueWriters.byteBuffers((ColumnDescriptor)this.desc));
        }
    }

    private class WriteBuilder
    extends ParquetTypeVisitor<ParquetValueWriter<?>> {
        private final MessageType type;

        private WriteBuilder(MessageType type) {
            this.type = type;
        }

        public ParquetValueWriter<?> message(MessageType message, List<ParquetValueWriter<?>> fieldWriters) {
            return this.struct(message.asGroupType(), fieldWriters);
        }

        public ParquetValueWriter<?> struct(GroupType struct, List<ParquetValueWriter<?>> fieldWriters) {
            List fields = struct.getFields();
            ArrayList writers = Lists.newArrayListWithExpectedSize((int)fieldWriters.size());
            for (int i = 0; i < fields.size(); ++i) {
                Type fieldType = struct.getType(i);
                int fieldD = this.type.getMaxDefinitionLevel(this.path(fieldType.getName()));
                writers.add(ParquetValueWriters.option((Type)fieldType, (int)fieldD, fieldWriters.get(i)));
            }
            return BaseParquetWriter.this.createStructWriter(writers);
        }

        public ParquetValueWriter<?> list(GroupType array, ParquetValueWriter<?> elementWriter) {
            GroupType repeated = ((Type)array.getFields().get(0)).asGroupType();
            String[] repeatedPath = this.currentPath();
            int repeatedD = this.type.getMaxDefinitionLevel(repeatedPath);
            int repeatedR = this.type.getMaxRepetitionLevel(repeatedPath);
            Type elementType = repeated.getType(0);
            int elementD = this.type.getMaxDefinitionLevel(this.path(elementType.getName()));
            return ParquetValueWriters.collections((int)repeatedD, (int)repeatedR, (ParquetValueWriter)ParquetValueWriters.option((Type)elementType, (int)elementD, elementWriter));
        }

        public ParquetValueWriter<?> map(GroupType map, ParquetValueWriter<?> keyWriter, ParquetValueWriter<?> valueWriter) {
            GroupType repeatedKeyValue = ((Type)map.getFields().get(0)).asGroupType();
            String[] repeatedPath = this.currentPath();
            int repeatedD = this.type.getMaxDefinitionLevel(repeatedPath);
            int repeatedR = this.type.getMaxRepetitionLevel(repeatedPath);
            Type keyType = repeatedKeyValue.getType(0);
            int keyD = this.type.getMaxDefinitionLevel(this.path(keyType.getName()));
            Type valueType = repeatedKeyValue.getType(1);
            int valueD = this.type.getMaxDefinitionLevel(this.path(valueType.getName()));
            return ParquetValueWriters.maps((int)repeatedD, (int)repeatedR, (ParquetValueWriter)ParquetValueWriters.option((Type)keyType, (int)keyD, keyWriter), (ParquetValueWriter)ParquetValueWriters.option((Type)valueType, (int)valueD, valueWriter));
        }

        public ParquetValueWriter<?> primitive(PrimitiveType primitive) {
            Optional writer;
            ColumnDescriptor desc = this.type.getColumnDescription(this.currentPath());
            LogicalTypeAnnotation logicalType = primitive.getLogicalTypeAnnotation();
            if (logicalType != null && (writer = logicalType.accept((LogicalTypeAnnotation.LogicalTypeAnnotationVisitor)new LogicalTypeWriterVisitor(desc))).isPresent()) {
                return (ParquetValueWriter)writer.get();
            }
            switch (primitive.getPrimitiveTypeName()) {
                case FIXED_LEN_BYTE_ARRAY: {
                    return new FixedWriter(desc);
                }
                case BINARY: {
                    return ParquetValueWriters.byteBuffers((ColumnDescriptor)desc);
                }
                case BOOLEAN: {
                    return ParquetValueWriters.booleans((ColumnDescriptor)desc);
                }
                case INT32: {
                    return ParquetValueWriters.ints((ColumnDescriptor)desc);
                }
                case INT64: {
                    return ParquetValueWriters.longs((ColumnDescriptor)desc);
                }
                case FLOAT: {
                    return ParquetValueWriters.floats((ColumnDescriptor)desc);
                }
                case DOUBLE: {
                    return ParquetValueWriters.doubles((ColumnDescriptor)desc);
                }
            }
            throw new UnsupportedOperationException("Unsupported type: " + primitive);
        }
    }
}

