/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.data;

import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.temporal.ChronoUnit;

public class DateTimeUtil {
    private static final OffsetDateTime EPOCH = Instant.ofEpochSecond(0L).atOffset(ZoneOffset.UTC);
    private static final LocalDate EPOCH_DAY = EPOCH.toLocalDate();

    private DateTimeUtil() {
    }

    public static LocalDate dateFromDays(int daysFromEpoch) {
        return ChronoUnit.DAYS.addTo(EPOCH_DAY, daysFromEpoch);
    }

    public static LocalTime timeFromMicros(long microFromMidnight) {
        return LocalTime.ofNanoOfDay(microFromMidnight * 1000L);
    }

    public static LocalDateTime timestampFromMicros(long microsFromEpoch) {
        return ChronoUnit.MICROS.addTo(EPOCH, microsFromEpoch).toLocalDateTime();
    }

    public static OffsetDateTime timestamptzFromMicros(long microsFromEpoch) {
        return ChronoUnit.MICROS.addTo(EPOCH, microsFromEpoch);
    }
}

