/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.data.avro;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.MapMaker;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Map;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.SchemaNormalization;
import org.apache.avro.io.BinaryDecoder;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.message.BadHeaderException;
import org.apache.avro.message.MessageDecoder;
import org.apache.avro.message.MissingSchemaException;
import org.apache.avro.message.SchemaStore;
import org.apache.iceberg.Schema;
import org.apache.iceberg.avro.AvroSchemaUtil;
import org.apache.iceberg.avro.ProjectionDatumReader;
import org.apache.iceberg.data.avro.DataReader;
import org.apache.iceberg.data.avro.IcebergEncoder;

public class IcebergDecoder<D>
extends MessageDecoder.BaseDecoder<D> {
    private static final ThreadLocal<byte[]> HEADER_BUFFER = ThreadLocal.withInitial(() -> new byte[10]);
    private static final ThreadLocal<ByteBuffer> FP_BUFFER = ThreadLocal.withInitial(() -> {
        byte[] header = HEADER_BUFFER.get();
        return ByteBuffer.wrap(header).order(ByteOrder.LITTLE_ENDIAN);
    });
    private final Schema readSchema;
    private final SchemaStore resolver;
    private final Map<Long, RawDecoder<D>> decoders = new MapMaker().makeMap();

    public IcebergDecoder(Schema readSchema) {
        this(readSchema, null);
    }

    public IcebergDecoder(Schema readSchema, SchemaStore resolver) {
        this.readSchema = readSchema;
        this.resolver = resolver;
        this.addSchema(this.readSchema);
    }

    public void addSchema(Schema writeSchema) {
        this.addSchema(AvroSchemaUtil.convert((Schema)writeSchema, (String)"table"));
    }

    private void addSchema(org.apache.avro.Schema writeSchema) {
        long fp = SchemaNormalization.parsingFingerprint64((org.apache.avro.Schema)writeSchema);
        this.decoders.put(fp, new RawDecoder(this.readSchema, writeSchema));
    }

    private RawDecoder<D> getDecoder(long fp) {
        org.apache.avro.Schema writeSchema;
        RawDecoder<D> decoder = this.decoders.get(fp);
        if (decoder != null) {
            return decoder;
        }
        if (this.resolver != null && (writeSchema = this.resolver.findByFingerprint(fp)) != null) {
            this.addSchema(writeSchema);
            return this.decoders.get(fp);
        }
        throw new MissingSchemaException("Cannot resolve schema for fingerprint: " + fp);
    }

    public D decode(InputStream stream, D reuse) throws IOException {
        byte[] header = HEADER_BUFFER.get();
        try {
            if (!this.readFully(stream, header)) {
                throw new BadHeaderException("Not enough header bytes");
            }
        }
        catch (IOException e) {
            throw new IOException("Failed to read header and fingerprint bytes", e);
        }
        if (IcebergEncoder.V1_HEADER[0] != header[0] || IcebergEncoder.V1_HEADER[1] != header[1]) {
            throw new BadHeaderException(String.format("Unrecognized header bytes: 0x%02X 0x%02X", header[0], header[1]));
        }
        RawDecoder<D> decoder = this.getDecoder(FP_BUFFER.get().getLong(2));
        return decoder.decode(stream, reuse);
    }

    private boolean readFully(InputStream stream, byte[] bytes) throws IOException {
        int bytesRead;
        int pos = 0;
        while (bytes.length - pos > 0 && (bytesRead = stream.read(bytes, pos, bytes.length - pos)) > 0) {
            pos += bytesRead;
        }
        return pos == bytes.length;
    }

    private static class RawDecoder<D>
    extends MessageDecoder.BaseDecoder<D> {
        private static final ThreadLocal<BinaryDecoder> DECODER = new ThreadLocal();
        private final DatumReader<D> reader;

        private RawDecoder(Schema readSchema, org.apache.avro.Schema writeSchema) {
            this.reader = new ProjectionDatumReader(DataReader::create, readSchema, (Map)ImmutableMap.of());
            this.reader.setSchema(writeSchema);
        }

        public D decode(InputStream stream, D reuse) {
            BinaryDecoder decoder = DecoderFactory.get().directBinaryDecoder(stream, DECODER.get());
            DECODER.set(decoder);
            try {
                return (D)this.reader.read(reuse, (Decoder)decoder);
            }
            catch (IOException e) {
                throw new AvroRuntimeException("Decoding datum failed", (Throwable)e);
            }
        }
    }
}

