/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.data.avro;

import com.google.common.collect.MapMaker;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.avro.LogicalType;
import org.apache.avro.LogicalTypes;
import org.apache.avro.Schema;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.io.ResolvingDecoder;
import org.apache.iceberg.avro.AvroSchemaUtil;
import org.apache.iceberg.avro.AvroSchemaVisitor;
import org.apache.iceberg.avro.LogicalMap;
import org.apache.iceberg.avro.ValueReader;
import org.apache.iceberg.avro.ValueReaders;
import org.apache.iceberg.data.avro.GenericReaders;
import org.apache.iceberg.exceptions.RuntimeIOException;

public class DataReader<T>
implements DatumReader<T> {
    private static final ThreadLocal<Map<Schema, Map<Schema, ResolvingDecoder>>> DECODER_CACHES = ThreadLocal.withInitial(() -> new MapMaker().weakKeys().makeMap());
    private final Schema readSchema;
    private final ValueReader<T> reader;
    private Schema fileSchema = null;

    public static <D> DataReader<D> create(Schema readSchema) {
        return new DataReader(readSchema);
    }

    private DataReader(Schema readSchema) {
        this.readSchema = readSchema;
        this.reader = (ValueReader)AvroSchemaVisitor.visit((Schema)readSchema, (AvroSchemaVisitor)new ReadBuilder());
    }

    public void setSchema(Schema newFileSchema) {
        this.fileSchema = Schema.applyAliases((Schema)newFileSchema, (Schema)this.readSchema);
    }

    public T read(T reuse, Decoder decoder) throws IOException {
        ResolvingDecoder resolver = this.resolve(decoder);
        Object value = this.reader.read((Decoder)resolver, reuse);
        resolver.drain();
        return (T)value;
    }

    private ResolvingDecoder resolve(Decoder decoder) throws IOException {
        Map<Schema, Map<Schema, ResolvingDecoder>> cache = DECODER_CACHES.get();
        Map fileSchemaToResolver = cache.computeIfAbsent(this.readSchema, k -> new HashMap());
        ResolvingDecoder resolver = (ResolvingDecoder)fileSchemaToResolver.get(this.fileSchema);
        if (resolver == null) {
            resolver = this.newResolver();
            fileSchemaToResolver.put(this.fileSchema, resolver);
        }
        resolver.configure(decoder);
        return resolver;
    }

    private ResolvingDecoder newResolver() {
        try {
            return DecoderFactory.get().resolvingDecoder(this.fileSchema, this.readSchema, null);
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    private static class ReadBuilder
    extends AvroSchemaVisitor<ValueReader<?>> {
        private ReadBuilder() {
        }

        public ValueReader<?> record(Schema record, List<String> names, List<ValueReader<?>> fields) {
            return GenericReaders.struct(AvroSchemaUtil.convert((Schema)record).asStructType(), fields);
        }

        public ValueReader<?> union(Schema union, List<ValueReader<?>> options) {
            return ValueReaders.union(options);
        }

        public ValueReader<?> array(Schema array, ValueReader<?> elementReader) {
            if (array.getLogicalType() instanceof LogicalMap) {
                ValueReaders.StructReader keyValueReader = (ValueReaders.StructReader)elementReader;
                ValueReader keyReader = keyValueReader.reader(0);
                ValueReader valueReader = keyValueReader.reader(1);
                return ValueReaders.arrayMap((ValueReader)keyReader, (ValueReader)valueReader);
            }
            return ValueReaders.array(elementReader);
        }

        public ValueReader<?> map(Schema map, ValueReader<?> valueReader) {
            return ValueReaders.map((ValueReader)ValueReaders.strings(), valueReader);
        }

        public ValueReader<?> primitive(Schema primitive) {
            LogicalType logicalType = primitive.getLogicalType();
            if (logicalType != null) {
                switch (logicalType.getName()) {
                    case "date": {
                        return GenericReaders.dates();
                    }
                    case "time-micros": {
                        return GenericReaders.times();
                    }
                    case "timestamp-micros": {
                        if (AvroSchemaUtil.isTimestamptz((Schema)primitive)) {
                            return GenericReaders.timestamptz();
                        }
                        return GenericReaders.timestamps();
                    }
                    case "decimal": {
                        ValueReader inner;
                        switch (primitive.getType()) {
                            case FIXED: {
                                inner = ValueReaders.fixed((int)primitive.getFixedSize());
                                break;
                            }
                            case BYTES: {
                                inner = ValueReaders.bytes();
                                break;
                            }
                            default: {
                                throw new IllegalArgumentException("Invalid primitive type for decimal: " + primitive.getType());
                            }
                        }
                        LogicalTypes.Decimal decimal = (LogicalTypes.Decimal)logicalType;
                        return ValueReaders.decimal((ValueReader)inner, (int)decimal.getScale());
                    }
                    case "uuid": {
                        return ValueReaders.uuids();
                    }
                }
                throw new IllegalArgumentException("Unknown logical type: " + logicalType);
            }
            switch (primitive.getType()) {
                case NULL: {
                    return ValueReaders.nulls();
                }
                case BOOLEAN: {
                    return ValueReaders.booleans();
                }
                case INT: {
                    return ValueReaders.ints();
                }
                case LONG: {
                    return ValueReaders.longs();
                }
                case FLOAT: {
                    return ValueReaders.floats();
                }
                case DOUBLE: {
                    return ValueReaders.doubles();
                }
                case STRING: {
                    return ValueReaders.strings();
                }
                case FIXED: {
                    return ValueReaders.fixed((int)primitive.getFixedSize());
                }
                case BYTES: {
                    return ValueReaders.byteBuffers();
                }
            }
            throw new IllegalArgumentException("Unsupported type: " + primitive);
        }
    }
}

