/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.data.orc;

import java.util.List;
import org.apache.iceberg.Schema;
import org.apache.iceberg.data.Record;
import org.apache.iceberg.data.orc.GenericOrcWriters;
import org.apache.iceberg.orc.OrcRowWriter;
import org.apache.iceberg.orc.OrcSchemaWithTypeVisitor;
import org.apache.iceberg.orc.OrcValueWriter;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.orc.TypeDescription;
import org.apache.orc.storage.ql.exec.vector.ColumnVector;
import org.apache.orc.storage.ql.exec.vector.StructColumnVector;
import org.apache.orc.storage.ql.exec.vector.VectorizedRowBatch;

public class GenericOrcWriter
implements OrcRowWriter<Record> {
    private final OrcValueWriter writer;

    private GenericOrcWriter(Schema expectedSchema, TypeDescription orcSchema) {
        Preconditions.checkArgument((orcSchema.getCategory() == TypeDescription.Category.STRUCT ? 1 : 0) != 0, (Object)("Top level must be a struct " + orcSchema));
        this.writer = (OrcValueWriter)OrcSchemaWithTypeVisitor.visit((Schema)expectedSchema, (TypeDescription)orcSchema, (OrcSchemaWithTypeVisitor)new WriteBuilder());
    }

    public static OrcRowWriter<Record> buildWriter(Schema expectedSchema, TypeDescription fileSchema) {
        return new GenericOrcWriter(expectedSchema, fileSchema);
    }

    public void write(Record value, VectorizedRowBatch output) {
        Preconditions.checkArgument((boolean)(this.writer instanceof RecordWriter), (Object)"writer must be a RecordWriter.");
        int row = output.size++;
        List<OrcValueWriter<?>> writers = ((RecordWriter)this.writer).writers();
        for (int c = 0; c < writers.size(); ++c) {
            OrcValueWriter<?> child = writers.get(c);
            child.write(row, value.get(c, child.getJavaClass()), output.cols[c]);
        }
    }

    private static class RecordWriter
    implements OrcValueWriter<Record> {
        private final List<OrcValueWriter<?>> writers;

        RecordWriter(List<OrcValueWriter<?>> writers) {
            this.writers = writers;
        }

        List<OrcValueWriter<?>> writers() {
            return this.writers;
        }

        public Class<Record> getJavaClass() {
            return Record.class;
        }

        public void nonNullWrite(int rowId, Record data, ColumnVector output) {
            StructColumnVector cv = (StructColumnVector)output;
            for (int c = 0; c < this.writers.size(); ++c) {
                OrcValueWriter<?> child = this.writers.get(c);
                child.write(rowId, data.get(c, child.getJavaClass()), cv.fields[c]);
            }
        }
    }

    private static class WriteBuilder
    extends OrcSchemaWithTypeVisitor<OrcValueWriter<?>> {
        private WriteBuilder() {
        }

        public OrcValueWriter<Record> record(Types.StructType iStruct, TypeDescription record, List<String> names, List<OrcValueWriter<?>> fields) {
            return new RecordWriter(fields);
        }

        public OrcValueWriter<?> list(Types.ListType iList, TypeDescription array, OrcValueWriter<?> element) {
            return GenericOrcWriters.list(element);
        }

        public OrcValueWriter<?> map(Types.MapType iMap, TypeDescription map, OrcValueWriter<?> key, OrcValueWriter<?> value) {
            return GenericOrcWriters.map(key, value);
        }

        public OrcValueWriter<?> primitive(Type.PrimitiveType iPrimitive, TypeDescription primitive) {
            switch (iPrimitive.typeId()) {
                case BOOLEAN: {
                    return GenericOrcWriters.booleans();
                }
                case INTEGER: {
                    return GenericOrcWriters.ints();
                }
                case LONG: {
                    return GenericOrcWriters.longs();
                }
                case FLOAT: {
                    return GenericOrcWriters.floats();
                }
                case DOUBLE: {
                    return GenericOrcWriters.doubles();
                }
                case DATE: {
                    return GenericOrcWriters.dates();
                }
                case TIME: {
                    return GenericOrcWriters.times();
                }
                case TIMESTAMP: {
                    Types.TimestampType timestampType = (Types.TimestampType)iPrimitive;
                    if (timestampType.shouldAdjustToUTC()) {
                        return GenericOrcWriters.timestampTz();
                    }
                    return GenericOrcWriters.timestamp();
                }
                case STRING: {
                    return GenericOrcWriters.strings();
                }
                case UUID: {
                    return GenericOrcWriters.uuids();
                }
                case FIXED: {
                    return GenericOrcWriters.byteArrays();
                }
                case BINARY: {
                    return GenericOrcWriters.byteBuffers();
                }
                case DECIMAL: {
                    Types.DecimalType decimalType = (Types.DecimalType)iPrimitive;
                    return GenericOrcWriters.decimal(decimalType.precision(), decimalType.scale());
                }
            }
            throw new IllegalArgumentException(String.format("Invalid iceberg type %s corresponding to ORC type %s", iPrimitive, primitive));
        }
    }
}

