/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.http.client;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.apache.iceberg.azure.shaded.io.netty.channel.ChannelOption;
import org.apache.iceberg.azure.shaded.io.netty.handler.codec.http.HttpHeaderNames;
import org.apache.iceberg.azure.shaded.io.netty.handler.codec.http.HttpHeaders;
import org.apache.iceberg.azure.shaded.io.netty.handler.codec.http.HttpMethod;
import org.apache.iceberg.azure.shaded.io.netty.handler.codec.http.HttpResponseStatus;
import org.apache.iceberg.azure.shaded.io.netty.handler.codec.http.HttpUtil;
import org.apache.iceberg.azure.shaded.io.netty.handler.codec.http.HttpVersion;
import org.apache.iceberg.azure.shaded.io.netty.handler.ssl.SslClosedEngineException;
import org.apache.iceberg.azure.shaded.io.netty.resolver.AddressResolverGroup;
import org.apache.iceberg.azure.shaded.io.netty.util.AbstractConstant;
import org.apache.iceberg.azure.shaded.io.netty.util.AsciiString;
import org.apache.iceberg.azure.shaded.io.netty.util.AttributeKey;
import org.apache.iceberg.azure.shaded.io.netty.util.NetUtil;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscription;
import reactor.core.CoreSubscriber;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoSink;
import reactor.netty.Connection;
import reactor.netty.ConnectionObserver;
import reactor.netty.NettyOutbound;
import reactor.netty.ReactorNetty;
import reactor.netty.channel.AbortedException;
import reactor.netty.http.HttpOperations;
import reactor.netty.http.HttpProtocol;
import reactor.netty.http.client.FailedHttpClientRequest;
import reactor.netty.http.client.HttpClient;
import reactor.netty.http.client.HttpClientConfig;
import reactor.netty.http.client.HttpClientOperations;
import reactor.netty.http.client.HttpClientRequest;
import reactor.netty.http.client.HttpClientResponse;
import reactor.netty.http.client.HttpClientSecure;
import reactor.netty.http.client.HttpClientState;
import reactor.netty.http.client.HttpConnectionProvider;
import reactor.netty.http.client.HttpResponseDecoderSpec;
import reactor.netty.http.client.RedirectClientException;
import reactor.netty.http.client.UriEndpoint;
import reactor.netty.http.client.UriEndpointFactory;
import reactor.netty.http.client.WebsocketClientSpec;
import reactor.netty.tcp.SslProvider;
import reactor.netty.tcp.TcpClientConfig;
import reactor.netty.transport.AddressUtils;
import reactor.netty.transport.ClientTransport;
import reactor.netty.transport.ProxyProvider;
import reactor.netty.transport.Transport;
import reactor.util.Logger;
import reactor.util.Loggers;
import reactor.util.annotation.Nullable;
import reactor.util.context.Context;
import reactor.util.context.ContextView;
import reactor.util.retry.Retry;

class HttpClientConnect
extends HttpClient {
    final HttpClientConfig config;
    static final AsciiString ALL = new AsciiString("*/*");
    static final int DEFAULT_PORT = System.getenv("PORT") != null ? Integer.parseInt(System.getenv("PORT")) : 80;
    static final Logger log = Loggers.getLogger(HttpClientConnect.class);
    static final BiFunction<String, Integer, InetSocketAddress> URI_ADDRESS_MAPPER = AddressUtils::createUnresolved;

    HttpClientConnect(HttpConnectionProvider provider) {
        this.config = new HttpClientConfig(provider, Collections.singletonMap(ChannelOption.AUTO_READ, false), () -> AddressUtils.createUnresolved(NetUtil.LOCALHOST.getHostAddress(), DEFAULT_PORT));
    }

    HttpClientConnect(HttpClientConfig config) {
        this.config = config;
    }

    @Override
    public HttpClientConfig configuration() {
        return this.config;
    }

    public String toString() {
        return "HttpClient{protocols=" + Arrays.asList(this.configuration().protocols) + ", secure=" + this.configuration().isSecure() + '}';
    }

    @Override
    protected Mono<? extends Connection> connect() {
        HttpClientConfig config = this.configuration();
        Mono mono = config.deferredConf != null ? config.deferredConf.apply(Mono.just(config)).flatMap(MonoHttpConnect::new) : new MonoHttpConnect(config);
        if (config.doOnConnect() != null) {
            mono = mono.doOnSubscribe(s -> config.doOnConnect().accept(config));
        }
        if (config.doOnRequestError != null) {
            mono = mono.onErrorResume(error -> Mono.deferContextual(Mono::just).doOnNext(ctx -> config.doOnRequestError.accept(new FailedHttpClientRequest((ContextView)ctx, config), (Throwable)error)).then(Mono.error(error)));
        }
        if (config.connector != null) {
            mono = config.connector.apply(mono);
        }
        return mono;
    }

    @Override
    protected HttpClient duplicate() {
        return new HttpClientConnect(new HttpClientConfig(this.config));
    }

    static HttpClient applyTcpClientConfig(TcpClientConfig config) {
        Transport httpClient = (HttpClient)((HttpClient)HttpClientConnect.create(config.connectionProvider()).doOnChannelInit(config.doOnChannelInit())).observe(config.connectionObserver()).remoteAddress(config.remoteAddress()).runOn(config.loopResources(), config.isPreferNative());
        if (config.resolver() != null) {
            httpClient = (HttpClient)((ClientTransport)httpClient).resolver(config.resolver());
        }
        for (Map.Entry<AttributeKey<?>, ?> entry : config.attributes().entrySet()) {
            httpClient = (HttpClient)httpClient.attr(entry.getKey(), entry.getValue());
        }
        if (config.bindAddress() != null) {
            httpClient = (HttpClient)httpClient.bindAddress(config.bindAddress());
        }
        if (config.channelGroup() != null) {
            httpClient = (HttpClient)httpClient.channelGroup(config.channelGroup());
        }
        if (config.doOnConnected() != null) {
            httpClient = (HttpClient)((ClientTransport)httpClient).doOnConnected(config.doOnConnected());
        }
        if (config.doOnDisconnected() != null) {
            httpClient = (HttpClient)((ClientTransport)httpClient).doOnDisconnected(config.doOnDisconnected());
        }
        if (config.loggingHandler() != null) {
            ((HttpClientConfig)httpClient.configuration()).loggingHandler(config.loggingHandler());
        }
        if (config.metricsRecorder() != null) {
            httpClient = ((HttpClient)httpClient).metrics(true, (Supplier)config.metricsRecorder());
        }
        for (Map.Entry<AbstractConstant, ?> entry : config.options().entrySet()) {
            httpClient = (HttpClient)httpClient.option((ChannelOption)entry.getKey(), entry.getValue());
        }
        if (config.proxyProvider() != null) {
            ((HttpClientConfig)httpClient.configuration()).proxyProvider(config.proxyProvider());
        }
        if (config.sslProvider() != null) {
            httpClient = ((HttpClient)httpClient).secure(config.sslProvider());
        }
        return httpClient;
    }

    static final class HttpClientHandler
    extends SocketAddress
    implements Predicate<Throwable>,
    Supplier<SocketAddress> {
        volatile HttpMethod method;
        final HttpHeaders defaultHeaders;
        final BiFunction<? super HttpClientRequest, ? super NettyOutbound, ? extends Publisher<Void>> handler;
        final boolean compress;
        final UriEndpointFactory uriEndpointFactory;
        final WebsocketClientSpec websocketClientSpec;
        final BiPredicate<HttpClientRequest, HttpClientResponse> followRedirectPredicate;
        final BiConsumer<HttpHeaders, HttpClientRequest> redirectRequestBiConsumer;
        final Consumer<HttpClientRequest> redirectRequestConsumer;
        final HttpResponseDecoderSpec decoder;
        final ProxyProvider proxyProvider;
        final Duration responseTimeout;
        volatile UriEndpoint toURI;
        volatile String resourceUrl;
        volatile UriEndpoint fromURI;
        volatile Supplier<String>[] redirectedFrom;
        volatile boolean shouldRetry;
        volatile HttpHeaders previousRequestHeaders;

        HttpClientHandler(HttpClientConfig configuration) {
            this.method = configuration.method;
            this.compress = configuration.acceptGzip;
            this.followRedirectPredicate = configuration.followRedirectPredicate;
            this.redirectRequestBiConsumer = configuration.redirectRequestBiConsumer;
            this.redirectRequestConsumer = configuration.redirectRequestConsumer;
            this.decoder = configuration.decoder;
            this.proxyProvider = configuration.proxyProvider();
            this.responseTimeout = configuration.responseTimeout;
            this.defaultHeaders = configuration.headers;
            String baseUrl = configuration.baseUrl;
            this.uriEndpointFactory = new UriEndpointFactory(configuration.remoteAddress(), configuration.isSecure(), URI_ADDRESS_MAPPER);
            this.websocketClientSpec = configuration.websocketClientSpec;
            this.shouldRetry = !configuration.retryDisabled;
            this.handler = configuration.body;
            if (configuration.uri == null) {
                String uri = configuration.uriStr;
                String string = uri = uri == null ? "/" : uri;
                if (baseUrl != null && uri.startsWith("/")) {
                    if (baseUrl.endsWith("/")) {
                        baseUrl = baseUrl.substring(0, baseUrl.length() - 1);
                    }
                    uri = baseUrl + uri;
                }
                this.toURI = this.uriEndpointFactory.createUriEndpoint(uri, configuration.websocketClientSpec != null);
            } else {
                this.toURI = this.uriEndpointFactory.createUriEndpoint(configuration.uri, configuration.websocketClientSpec != null);
            }
            this.resourceUrl = this.toURI.toExternalForm();
        }

        @Override
        public SocketAddress get() {
            SocketAddress address = this.toURI.getRemoteAddress();
            if (this.proxyProvider != null && !this.proxyProvider.shouldProxy(address) && address instanceof InetSocketAddress) {
                address = AddressUtils.replaceWithResolved((InetSocketAddress)address);
            }
            return address;
        }

        Publisher<Void> requestWithBody(HttpClientOperations ch) {
            try {
                ch.resourceUrl = this.resourceUrl;
                ch.responseTimeout = this.responseTimeout;
                UriEndpoint uri = this.toURI;
                HttpHeaders headers = ch.getNettyRequest().setUri(uri.getPathAndQuery()).setMethod(this.method).setProtocolVersion(HttpVersion.HTTP_1_1).headers();
                ch.path = HttpOperations.resolvePath(ch.uri());
                if (!this.defaultHeaders.isEmpty()) {
                    headers.set(this.defaultHeaders);
                }
                if (!headers.contains(HttpHeaderNames.USER_AGENT)) {
                    headers.set((CharSequence)HttpHeaderNames.USER_AGENT, (Object)HttpClient.USER_AGENT);
                }
                SocketAddress remoteAddress = uri.getRemoteAddress();
                if (!headers.contains(HttpHeaderNames.HOST)) {
                    headers.set((CharSequence)HttpHeaderNames.HOST, (Object)HttpClientHandler.resolveHostHeaderValue(remoteAddress));
                }
                if (!headers.contains(HttpHeaderNames.ACCEPT)) {
                    headers.set((CharSequence)HttpHeaderNames.ACCEPT, (Object)ALL);
                }
                ch.followRedirectPredicate(this.followRedirectPredicate);
                if (!(Objects.equals(this.method, HttpMethod.GET) || Objects.equals(this.method, HttpMethod.HEAD) || Objects.equals(this.method, HttpMethod.DELETE) || headers.contains(HttpHeaderNames.CONTENT_LENGTH))) {
                    ch.chunkedTransfer(true);
                }
                ch.listener().onStateChange(ch, HttpClientState.REQUEST_PREPARED);
                if (this.websocketClientSpec != null) {
                    Mono<Void> result = Mono.fromRunnable(() -> ch.withWebsocketSupport(this.websocketClientSpec, this.compress));
                    if (this.handler != null) {
                        result = result.thenEmpty(Mono.fromRunnable(() -> Flux.concat(new Publisher[]{this.handler.apply(ch, ch)})));
                    }
                    return result;
                }
                Consumer<HttpClientRequest> consumer = null;
                if (this.fromURI != null && !this.toURI.equals(this.fromURI)) {
                    if (this.handler instanceof HttpClient.RedirectSendHandler) {
                        headers.remove(HttpHeaderNames.EXPECT).remove(HttpHeaderNames.COOKIE).remove(HttpHeaderNames.AUTHORIZATION).remove(HttpHeaderNames.PROXY_AUTHORIZATION);
                    } else {
                        consumer = request -> request.requestHeaders().remove(HttpHeaderNames.EXPECT).remove(HttpHeaderNames.COOKIE).remove(HttpHeaderNames.AUTHORIZATION).remove(HttpHeaderNames.PROXY_AUTHORIZATION);
                    }
                }
                if (this.redirectRequestConsumer != null) {
                    Consumer<HttpClientRequest> consumer2 = consumer = consumer != null ? consumer.andThen(this.redirectRequestConsumer) : this.redirectRequestConsumer;
                }
                if (this.redirectRequestBiConsumer != null) {
                    ch.previousRequestHeaders = this.previousRequestHeaders;
                    ch.redirectRequestBiConsumer = this.redirectRequestBiConsumer;
                }
                ch.redirectRequestConsumer(consumer);
                return this.handler != null ? this.handler.apply(ch, ch) : ch.send();
            }
            catch (Throwable t) {
                return Mono.error(t);
            }
        }

        static String resolveHostHeaderValue(@Nullable SocketAddress remoteAddress) {
            if (remoteAddress instanceof InetSocketAddress) {
                InetSocketAddress address = (InetSocketAddress)remoteAddress;
                String host = HttpUtil.formatHostnameForHttp(address);
                int port = address.getPort();
                if (port != 80 && port != 443) {
                    host = host + ':' + port;
                }
                return host;
            }
            return "localhost";
        }

        void redirect(String to) {
            UriEndpoint toURITemp;
            Supplier<String>[] redirectedFrom = this.redirectedFrom;
            UriEndpoint from = this.toURI;
            SocketAddress address = from.getRemoteAddress();
            if (address instanceof InetSocketAddress) {
                try {
                    URI redirectUri = new URI(to);
                    if (!redirectUri.isAbsolute()) {
                        URI requestUri = new URI(this.resourceUrl);
                        redirectUri = requestUri.resolve(redirectUri);
                    }
                    toURITemp = this.uriEndpointFactory.createUriEndpoint(redirectUri, from.isWs());
                }
                catch (URISyntaxException e) {
                    throw new IllegalArgumentException("Cannot resolve location header", e);
                }
            } else {
                toURITemp = this.uriEndpointFactory.createUriEndpoint(from, to, () -> address);
            }
            this.fromURI = from;
            this.toURI = toURITemp;
            this.resourceUrl = toURITemp.toExternalForm();
            this.redirectedFrom = HttpClientHandler.addToRedirectedFromArray(redirectedFrom, from);
        }

        static Supplier<String>[] addToRedirectedFromArray(@Nullable Supplier<String>[] redirectedFrom, UriEndpoint from) {
            Supplier<String> fromUrlSupplier = from::toExternalForm;
            if (redirectedFrom == null) {
                return new Supplier[]{fromUrlSupplier};
            }
            Supplier[] newRedirectedFrom = new Supplier[redirectedFrom.length + 1];
            System.arraycopy(redirectedFrom, 0, newRedirectedFrom, 0, redirectedFrom.length);
            newRedirectedFrom[redirectedFrom.length] = fromUrlSupplier;
            return newRedirectedFrom;
        }

        void channel(HttpClientOperations ops) {
            Supplier<String>[] redirectedFrom = this.redirectedFrom;
            if (redirectedFrom != null) {
                ops.redirectedFrom = redirectedFrom;
            }
        }

        @Override
        public boolean test(Throwable throwable) {
            if (throwable instanceof RedirectClientException) {
                RedirectClientException re = (RedirectClientException)throwable;
                if (HttpResponseStatus.SEE_OTHER.equals(re.status)) {
                    this.method = HttpMethod.GET;
                }
                this.redirect(re.location);
                return true;
            }
            if (this.shouldRetry && AbortedException.isConnectionReset(throwable)) {
                this.shouldRetry = false;
                this.redirect(this.toURI.toString());
                return true;
            }
            return false;
        }

        public String toString() {
            return "{uri=" + this.toURI + ", method=" + this.method + '}';
        }
    }

    static final class HttpIOHandlerObserver
    implements ConnectionObserver {
        final MonoSink<Connection> sink;
        final Context currentContext;
        final HttpClientHandler handler;

        HttpIOHandlerObserver(MonoSink<Connection> sink, HttpClientHandler handler) {
            this.sink = sink;
            this.currentContext = Context.of(sink.contextView());
            this.handler = handler;
        }

        @Override
        public Context currentContext() {
            return this.currentContext;
        }

        @Override
        public void onStateChange(Connection connection, ConnectionObserver.State newState) {
            if (newState == HttpClientState.RESPONSE_RECEIVED) {
                this.sink.success(connection);
                return;
            }
            if ((newState == ConnectionObserver.State.CONFIGURED || newState == HttpClientState.STREAM_CONFIGURED) && HttpClientOperations.class == connection.getClass()) {
                if (log.isDebugEnabled()) {
                    log.debug(ReactorNetty.format(connection.channel(), "Handler is being applied: {}"), this.handler);
                }
                Mono.defer(() -> Mono.fromDirect(this.handler.requestWithBody((HttpClientOperations)connection))).subscribe(connection.disposeSubscriber());
            }
        }
    }

    static final class HttpObserver
    implements ConnectionObserver {
        final MonoSink<Connection> sink;
        final Context currentContext;
        final HttpClientHandler handler;

        HttpObserver(MonoSink<Connection> sink, HttpClientHandler handler) {
            this.sink = sink;
            this.currentContext = Context.of(sink.contextView());
            this.handler = handler;
        }

        @Override
        public Context currentContext() {
            return this.currentContext;
        }

        @Override
        public void onUncaughtException(Connection connection, Throwable error) {
            if (error instanceof RedirectClientException) {
                HttpClientOperations ops;
                if (log.isDebugEnabled()) {
                    log.debug(ReactorNetty.format(connection.channel(), "The request will be redirected"));
                }
                if ((ops = connection.as(HttpClientOperations.class)) != null && this.handler.redirectRequestBiConsumer != null) {
                    this.handler.previousRequestHeaders = ops.requestHeaders;
                }
            } else if (this.handler.shouldRetry && AbortedException.isConnectionReset(error)) {
                HttpClientOperations ops = connection.as(HttpClientOperations.class);
                if (ops != null && ops.hasSentHeaders()) {
                    ops.markPersistent(false);
                    this.handler.shouldRetry = false;
                    if (log.isWarnEnabled()) {
                        log.warn(ReactorNetty.format(connection.channel(), "The connection observed an error, the request cannot be retried as the headers/body were sent"), error);
                    }
                } else {
                    if (ops != null) {
                        ops.markPersistent(false);
                        ops.retrying = true;
                    }
                    if (log.isDebugEnabled()) {
                        log.debug(ReactorNetty.format(connection.channel(), "The connection observed an error, the request will be retried"), error);
                    }
                }
            } else if (error instanceof SslClosedEngineException) {
                HttpClientOperations ops;
                if (log.isWarnEnabled()) {
                    log.warn(ReactorNetty.format(connection.channel(), "The connection observed an error"), error);
                }
                if ((ops = connection.as(HttpClientOperations.class)) != null) {
                    ops.markPersistent(false);
                }
            } else if (log.isWarnEnabled()) {
                log.warn(ReactorNetty.format(connection.channel(), "The connection observed an error"), error);
            }
            this.sink.error(error);
        }

        @Override
        public void onStateChange(Connection connection, ConnectionObserver.State newState) {
            if ((newState == ConnectionObserver.State.CONFIGURED || newState == HttpClientState.STREAM_CONFIGURED) && HttpClientOperations.class == connection.getClass()) {
                this.handler.channel((HttpClientOperations)connection);
            }
        }
    }

    static final class MonoHttpConnect
    extends Mono<Connection> {
        final HttpClientConfig config;

        MonoHttpConnect(HttpClientConfig config) {
            this.config = config;
        }

        @Override
        public void subscribe(CoreSubscriber<? super Connection> actual) {
            HttpClientHandler handler = new HttpClientHandler(this.config);
            Mono.create(sink -> {
                HttpClientConfig _config = this.config;
                if (handler.toURI.isSecure()) {
                    if (_config.sslProvider == null) {
                        _config = new HttpClientConfig(this.config);
                        _config.sslProvider = HttpClientSecure.defaultSslProvider(_config);
                    }
                    if (_config.checkProtocol(1)) {
                        if (_config.protocols.length > 1) {
                            this.removeIncompatibleProtocol(_config, HttpProtocol.H2C);
                        } else {
                            sink.error(new IllegalArgumentException("Configured H2 Clear-Text protocol with TLS. Use the non Clear-Text H2 protocol via HttpClient#protocol or disable TLS via HttpClient#noSSL()"));
                            return;
                        }
                    }
                    if (_config.sslProvider.getDefaultConfigurationType() == null) {
                        _config.sslProvider = _config.checkProtocol(2) ? SslProvider.updateDefaultConfiguration(_config.sslProvider, SslProvider.DefaultConfigurationType.H2) : SslProvider.updateDefaultConfiguration(_config.sslProvider, SslProvider.DefaultConfigurationType.TCP);
                    }
                } else {
                    if (_config.sslProvider != null) {
                        _config = new HttpClientConfig(this.config);
                        _config.sslProvider = null;
                    }
                    if (_config.checkProtocol(2)) {
                        if (_config.protocols.length > 1) {
                            this.removeIncompatibleProtocol(_config, HttpProtocol.H2);
                        } else {
                            sink.error(new IllegalArgumentException("Configured H2 protocol without TLS. Use H2 Clear-Text protocol via HttpClient#protocol or configure TLS via HttpClient#secure"));
                            return;
                        }
                    }
                }
                ConnectionObserver observer = new HttpObserver((MonoSink<Connection>)sink, handler).then(_config.defaultConnectionObserver()).then(_config.connectionObserver()).then(new HttpIOHandlerObserver((MonoSink<Connection>)sink, handler));
                AddressResolverGroup<?> resolver = _config.resolverInternal();
                _config.httpConnectionProvider().acquire(_config, observer, handler, resolver).subscribe(new ClientTransportSubscriber((MonoSink<Connection>)sink));
            }).retryWhen(Retry.indefinitely().filter(handler)).subscribe(actual);
        }

        private void removeIncompatibleProtocol(HttpClientConfig config, HttpProtocol protocol) {
            ArrayList<HttpProtocol> newProtocols = new ArrayList<HttpProtocol>();
            for (int i = 0; i < config.protocols.length; ++i) {
                if (config.protocols[i] == protocol) continue;
                newProtocols.add(config.protocols[i]);
            }
            config.protocols(newProtocols.toArray(new HttpProtocol[0]));
        }

        static final class ClientTransportSubscriber
        implements CoreSubscriber<Connection> {
            final MonoSink<Connection> sink;
            final Context currentContext;

            ClientTransportSubscriber(MonoSink<Connection> sink) {
                this.sink = sink;
                this.currentContext = Context.of(sink.contextView());
            }

            @Override
            public void onSubscribe(Subscription s) {
                s.request(Long.MAX_VALUE);
            }

            @Override
            public void onNext(Connection connection) {
                this.sink.onCancel(connection);
            }

            @Override
            public void onError(Throwable throwable) {
                this.sink.error(throwable);
            }

            @Override
            public void onComplete() {
            }

            @Override
            public Context currentContext() {
                return this.currentContext;
            }
        }
    }
}

