/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.channel;

import java.net.SocketAddress;
import org.apache.iceberg.azure.shaded.io.netty.buffer.ByteBuf;
import org.apache.iceberg.azure.shaded.io.netty.channel.ChannelDuplexHandler;
import org.apache.iceberg.azure.shaded.io.netty.channel.ChannelHandler;
import org.apache.iceberg.azure.shaded.io.netty.channel.ChannelHandlerContext;
import org.apache.iceberg.azure.shaded.io.netty.channel.ChannelPromise;
import org.apache.iceberg.azure.shaded.io.netty.channel.socket.DatagramPacket;
import reactor.netty.ReactorNetty;
import reactor.netty.channel.ChannelMetricsRecorder;
import reactor.util.Logger;
import reactor.util.Loggers;
import reactor.util.annotation.Nullable;

public abstract class AbstractChannelMetricsHandler
extends ChannelDuplexHandler {
    private static final Logger log = Loggers.getLogger(AbstractChannelMetricsHandler.class);
    final SocketAddress remoteAddress;
    final boolean onServer;
    boolean channelOpened;

    protected AbstractChannelMetricsHandler(@Nullable SocketAddress remoteAddress, boolean onServer) {
        this.remoteAddress = remoteAddress;
        this.onServer = onServer;
    }

    @Override
    public void channelActive(ChannelHandlerContext ctx) {
        block3: {
            if (this.onServer) {
                try {
                    this.channelOpened = true;
                    this.recorder().recordServerConnectionOpened(ctx.channel().localAddress());
                }
                catch (RuntimeException e) {
                    if (!log.isWarnEnabled()) break block3;
                    log.warn(ReactorNetty.format(ctx.channel(), "Exception caught while recording metrics."), e);
                }
            }
        }
        ctx.fireChannelActive();
    }

    @Override
    public void channelInactive(ChannelHandlerContext ctx) {
        block4: {
            if (this.onServer) {
                try {
                    if (this.channelOpened) {
                        this.channelOpened = false;
                        this.recorder().recordServerConnectionClosed(ctx.channel().localAddress());
                    }
                }
                catch (RuntimeException e) {
                    if (!log.isWarnEnabled()) break block4;
                    log.warn(ReactorNetty.format(ctx.channel(), "Exception caught while recording metrics."), e);
                }
            }
        }
        ctx.fireChannelInactive();
    }

    @Override
    public void channelRegistered(ChannelHandlerContext ctx) {
        if (!this.onServer) {
            ctx.pipeline().addAfter("reactor.left.channelMetricsHandler", "reactor.left.connectMetricsHandler", this.connectMetricsHandler());
        }
        if (ctx.pipeline().get("reactor.left.sslHandler") != null) {
            ctx.pipeline().addBefore("reactor.left.sslHandler", "reactor.left.tlsMetricsHandler", this.tlsMetricsHandler());
        }
        ctx.fireChannelRegistered();
    }

    @Override
    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        block6: {
            try {
                DatagramPacket p;
                ByteBuf buffer;
                if (msg instanceof ByteBuf) {
                    ByteBuf buffer2 = (ByteBuf)msg;
                    if (buffer2.readableBytes() > 0) {
                        this.recordRead(ctx, this.remoteAddress, buffer2.readableBytes());
                    }
                } else if (msg instanceof DatagramPacket && (buffer = (ByteBuf)(p = (DatagramPacket)msg).content()).readableBytes() > 0) {
                    this.recordRead(ctx, this.remoteAddress != null ? this.remoteAddress : p.sender(), buffer.readableBytes());
                }
            }
            catch (RuntimeException e) {
                if (!log.isWarnEnabled()) break block6;
                log.warn(ReactorNetty.format(ctx.channel(), "Exception caught while recording metrics."), e);
            }
        }
        ctx.fireChannelRead(msg);
    }

    @Override
    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) {
        block6: {
            try {
                DatagramPacket p;
                ByteBuf buffer;
                if (msg instanceof ByteBuf) {
                    ByteBuf buffer2 = (ByteBuf)msg;
                    if (buffer2.readableBytes() > 0) {
                        this.recordWrite(ctx, this.remoteAddress, buffer2.readableBytes());
                    }
                } else if (msg instanceof DatagramPacket && (buffer = (ByteBuf)(p = (DatagramPacket)msg).content()).readableBytes() > 0) {
                    this.recordWrite(ctx, this.remoteAddress != null ? this.remoteAddress : p.recipient(), buffer.readableBytes());
                }
            }
            catch (RuntimeException e) {
                if (!log.isWarnEnabled()) break block6;
                log.warn(ReactorNetty.format(ctx.channel(), "Exception caught while recording metrics."), e);
            }
        }
        ctx.write(msg, promise);
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        block2: {
            try {
                this.recordException(ctx, this.remoteAddress != null ? this.remoteAddress : ctx.channel().remoteAddress());
            }
            catch (RuntimeException e) {
                if (!log.isWarnEnabled()) break block2;
                log.warn(ReactorNetty.format(ctx.channel(), "Exception caught while recording metrics."), e);
            }
        }
        ctx.fireExceptionCaught(cause);
    }

    public abstract ChannelHandler connectMetricsHandler();

    public abstract ChannelHandler tlsMetricsHandler();

    public abstract ChannelMetricsRecorder recorder();

    protected void recordException(ChannelHandlerContext ctx, SocketAddress address) {
        this.recorder().incrementErrorsCount(address);
    }

    protected void recordRead(ChannelHandlerContext ctx, SocketAddress address, long bytes) {
        this.recorder().recordDataReceived(address, bytes);
    }

    protected void recordWrite(ChannelHandlerContext ctx, SocketAddress address, long bytes) {
        this.recorder().recordDataSent(address, bytes);
    }
}

