/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.azure.shaded.io.netty.handler.codec.string;

import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.List;
import org.apache.iceberg.azure.shaded.io.netty.buffer.ByteBufUtil;
import org.apache.iceberg.azure.shaded.io.netty.channel.ChannelHandler;
import org.apache.iceberg.azure.shaded.io.netty.channel.ChannelHandlerContext;
import org.apache.iceberg.azure.shaded.io.netty.handler.codec.MessageToMessageEncoder;
import org.apache.iceberg.azure.shaded.io.netty.util.internal.ObjectUtil;

@ChannelHandler.Sharable
public class StringEncoder
extends MessageToMessageEncoder<CharSequence> {
    private final Charset charset;

    public StringEncoder() {
        this(Charset.defaultCharset());
    }

    public StringEncoder(Charset charset) {
        this.charset = ObjectUtil.checkNotNull(charset, "charset");
    }

    @Override
    protected void encode(ChannelHandlerContext ctx, CharSequence msg, List<Object> out) throws Exception {
        if (msg.length() == 0) {
            return;
        }
        out.add(ByteBufUtil.encodeString(ctx.alloc(), CharBuffer.wrap(msg), this.charset));
    }
}

