/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.azure.shaded.com.fasterxml.jackson.dataformat.xml;

import java.io.Serializable;
import java.util.Collection;
import org.apache.iceberg.azure.shaded.com.fasterxml.jackson.annotation.JsonTypeInfo;
import org.apache.iceberg.azure.shaded.com.fasterxml.jackson.databind.JavaType;
import org.apache.iceberg.azure.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.iceberg.azure.shaded.com.fasterxml.jackson.databind.cfg.MapperConfig;
import org.apache.iceberg.azure.shaded.com.fasterxml.jackson.databind.jsontype.NamedType;
import org.apache.iceberg.azure.shaded.com.fasterxml.jackson.databind.jsontype.PolymorphicTypeValidator;
import org.apache.iceberg.azure.shaded.com.fasterxml.jackson.databind.jsontype.TypeIdResolver;
import org.apache.iceberg.azure.shaded.com.fasterxml.jackson.databind.jsontype.impl.StdTypeResolverBuilder;
import org.apache.iceberg.azure.shaded.com.fasterxml.jackson.dataformat.xml.XmlTypeResolverBuilder;
import org.apache.iceberg.azure.shaded.com.fasterxml.jackson.dataformat.xml.util.StaxUtil;

public class DefaultingXmlTypeResolverBuilder
extends ObjectMapper.DefaultTypeResolverBuilder
implements Serializable {
    private static final long serialVersionUID = 1L;

    public DefaultingXmlTypeResolverBuilder(ObjectMapper.DefaultTyping t, PolymorphicTypeValidator ptv) {
        super(t, ptv);
    }

    @Override
    public StdTypeResolverBuilder init(JsonTypeInfo.Id idType, TypeIdResolver idRes) {
        super.init(idType, idRes);
        if (this._typeProperty != null) {
            this._typeProperty = StaxUtil.sanitizeXmlTypeName(this._typeProperty);
        }
        return this;
    }

    @Override
    public StdTypeResolverBuilder typeProperty(String typeIdPropName) {
        if (typeIdPropName == null || typeIdPropName.length() == 0) {
            typeIdPropName = this._idType.getDefaultPropertyName();
        }
        this._typeProperty = StaxUtil.sanitizeXmlTypeName(typeIdPropName);
        return this;
    }

    @Override
    protected TypeIdResolver idResolver(MapperConfig<?> config, JavaType baseType, PolymorphicTypeValidator subtypeValidator, Collection<NamedType> subtypes, boolean forSer, boolean forDeser) {
        if (this._customIdResolver != null) {
            return this._customIdResolver;
        }
        switch (this._idType) {
            case CLASS: {
                return new XmlTypeResolverBuilder.XmlClassNameIdResolver(baseType, config.getTypeFactory(), this.subTypeValidator(config));
            }
            case MINIMAL_CLASS: {
                return new XmlTypeResolverBuilder.XmlMinimalClassNameIdResolver(baseType, config.getTypeFactory(), this.subTypeValidator(config));
            }
        }
        return super.idResolver(config, baseType, subtypeValidator, subtypes, forSer, forDeser);
    }
}

