/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.internal.avro.implementation;

import com.azure.storage.internal.avro.implementation.AvroParser;
import com.azure.storage.internal.avro.implementation.AvroReader;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class AvroReaderFactory {
    public AvroReader getAvroReader(Flux<ByteBuffer> avroHeader, Flux<ByteBuffer> avroBody, long offset, long thresholdIndex) {
        return () -> {
            AvroParser parser = new AvroParser(true);
            return avroHeader.concatMap(parser::parse).then(Mono.defer(() -> parser.prepareParserToReadBody(offset, thresholdIndex))).thenMany(avroBody.concatMap(parser::parse));
        };
    }

    public AvroReader getAvroReader(Flux<ByteBuffer> avro) {
        return () -> {
            AvroParser parser = new AvroParser(false);
            return avro.concatMap(parser::parse);
        };
    }
}

