/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.file.datalake;

import com.azure.core.annotation.ServiceClientBuilder;
import com.azure.core.client.traits.AzureNamedKeyCredentialTrait;
import com.azure.core.client.traits.AzureSasCredentialTrait;
import com.azure.core.client.traits.ConfigurationTrait;
import com.azure.core.client.traits.EndpointTrait;
import com.azure.core.client.traits.HttpTrait;
import com.azure.core.client.traits.TokenCredentialTrait;
import com.azure.core.credential.AzureNamedKeyCredential;
import com.azure.core.credential.AzureSasCredential;
import com.azure.core.credential.TokenCredential;
import com.azure.core.http.HttpClient;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelinePosition;
import com.azure.core.http.policy.HttpLogOptions;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.RetryOptions;
import com.azure.core.util.ClientOptions;
import com.azure.core.util.Configuration;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.storage.blob.BlobServiceClientBuilder;
import com.azure.storage.blob.BlobUrlParts;
import com.azure.storage.blob.models.BlobAudience;
import com.azure.storage.common.StorageSharedKeyCredential;
import com.azure.storage.common.implementation.connectionstring.StorageAuthenticationSettings;
import com.azure.storage.common.implementation.connectionstring.StorageConnectionString;
import com.azure.storage.common.implementation.connectionstring.StorageEndpoint;
import com.azure.storage.common.policy.RequestRetryOptions;
import com.azure.storage.file.datalake.DataLakeServiceAsyncClient;
import com.azure.storage.file.datalake.DataLakeServiceClient;
import com.azure.storage.file.datalake.DataLakeServiceVersion;
import com.azure.storage.file.datalake.Transforms;
import com.azure.storage.file.datalake.implementation.util.BuilderHelper;
import com.azure.storage.file.datalake.implementation.util.DataLakeImplUtils;
import com.azure.storage.file.datalake.implementation.util.TransformUtils;
import com.azure.storage.file.datalake.models.CustomerProvidedKey;
import com.azure.storage.file.datalake.models.DataLakeAudience;
import com.azure.storage.file.datalake.options.FileSystemEncryptionScopeOptions;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ServiceClientBuilder(serviceClients={DataLakeServiceClient.class, DataLakeServiceAsyncClient.class})
public class DataLakeServiceClientBuilder
implements TokenCredentialTrait<DataLakeServiceClientBuilder>,
AzureNamedKeyCredentialTrait<DataLakeServiceClientBuilder>,
AzureSasCredentialTrait<DataLakeServiceClientBuilder>,
HttpTrait<DataLakeServiceClientBuilder>,
ConfigurationTrait<DataLakeServiceClientBuilder>,
EndpointTrait<DataLakeServiceClientBuilder> {
    private static final ClientLogger LOGGER = new ClientLogger(DataLakeServiceClientBuilder.class);
    private final BlobServiceClientBuilder blobServiceClientBuilder;
    private String endpoint;
    private String accountName;
    private StorageSharedKeyCredential storageSharedKeyCredential;
    private TokenCredential tokenCredential;
    private AzureSasCredential azureSasCredential;
    private HttpClient httpClient;
    private final List<HttpPipelinePolicy> perCallPolicies = new ArrayList<HttpPipelinePolicy>();
    private final List<HttpPipelinePolicy> perRetryPolicies = new ArrayList<HttpPipelinePolicy>();
    private HttpLogOptions logOptions;
    private RequestRetryOptions retryOptions;
    private RetryOptions coreRetryOptions;
    private HttpPipeline httpPipeline;
    private ClientOptions clientOptions = new ClientOptions();
    private Configuration configuration;
    private DataLakeServiceVersion version;
    private FileSystemEncryptionScopeOptions fileSystemEncryptionScopeOptions;
    private DataLakeAudience audience;

    public DataLakeServiceClientBuilder() {
        this.logOptions = DataLakeServiceClientBuilder.getDefaultHttpLogOptions();
        this.blobServiceClientBuilder = new BlobServiceClientBuilder();
        this.blobServiceClientBuilder.addPolicy(BuilderHelper.getBlobUserAgentModificationPolicy());
    }

    public DataLakeServiceClient buildClient() {
        return new DataLakeServiceClient(this.buildAsyncClient(), this.blobServiceClientBuilder.buildClient());
    }

    public DataLakeServiceAsyncClient buildAsyncClient() {
        if (Objects.isNull(this.storageSharedKeyCredential) && Objects.isNull(this.tokenCredential) && Objects.isNull(this.azureSasCredential)) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException("Data Lake Service Client cannot be accessed anonymously. Please provide a form of authentication"));
        }
        DataLakeServiceVersion serviceVersion = this.version != null ? this.version : DataLakeServiceVersion.getLatest();
        HttpPipeline pipeline = this.httpPipeline != null ? this.httpPipeline : BuilderHelper.buildPipeline(this.storageSharedKeyCredential, this.tokenCredential, this.azureSasCredential, this.endpoint, this.retryOptions, this.coreRetryOptions, this.logOptions, this.clientOptions, this.httpClient, this.perCallPolicies, this.perRetryPolicies, this.configuration, this.audience, LOGGER);
        return new DataLakeServiceAsyncClient(pipeline, this.endpoint, serviceVersion, this.accountName, this.blobServiceClientBuilder.buildAsyncClient(), this.azureSasCredential, this.tokenCredential != null);
    }

    @Override
    public DataLakeServiceClientBuilder endpoint(String endpoint) {
        endpoint = DataLakeImplUtils.endpointToDesiredEndpoint(endpoint, "dfs", "blob");
        this.blobServiceClientBuilder.endpoint(DataLakeImplUtils.endpointToDesiredEndpoint(endpoint, "blob", "dfs"));
        try {
            BlobUrlParts parts = BlobUrlParts.parse(new URL(endpoint));
            this.accountName = parts.getAccountName();
            this.endpoint = BuilderHelper.getEndpoint(parts);
            String sasToken = parts.getCommonSasQueryParameters().encode();
            if (!CoreUtils.isNullOrEmpty(sasToken)) {
                this.sasToken(sasToken);
            }
        }
        catch (MalformedURLException ex) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException("The Azure Storage endpoint url is malformed.", ex));
        }
        return this;
    }

    public DataLakeServiceClientBuilder credential(StorageSharedKeyCredential credential) {
        this.blobServiceClientBuilder.credential(credential);
        this.storageSharedKeyCredential = Objects.requireNonNull(credential, "'credential' cannot be null.");
        this.tokenCredential = null;
        this.azureSasCredential = null;
        return this;
    }

    @Override
    public DataLakeServiceClientBuilder credential(AzureNamedKeyCredential credential) {
        Objects.requireNonNull(credential, "'credential' cannot be null.");
        return this.credential(StorageSharedKeyCredential.fromAzureNamedKeyCredential(credential));
    }

    @Override
    public DataLakeServiceClientBuilder credential(TokenCredential credential) {
        this.blobServiceClientBuilder.credential(credential);
        this.tokenCredential = Objects.requireNonNull(credential, "'credential' cannot be null.");
        this.storageSharedKeyCredential = null;
        this.azureSasCredential = null;
        return this;
    }

    public DataLakeServiceClientBuilder sasToken(String sasToken) {
        this.blobServiceClientBuilder.sasToken(sasToken);
        this.azureSasCredential = new AzureSasCredential(Objects.requireNonNull(sasToken, "'sasToken' cannot be null."));
        this.storageSharedKeyCredential = null;
        this.tokenCredential = null;
        return this;
    }

    @Override
    public DataLakeServiceClientBuilder credential(AzureSasCredential credential) {
        this.blobServiceClientBuilder.credential(credential);
        this.azureSasCredential = Objects.requireNonNull(credential, "'credential' cannot be null.");
        this.storageSharedKeyCredential = null;
        this.tokenCredential = null;
        return this;
    }

    public DataLakeServiceClientBuilder connectionString(String connectionString) {
        StorageAuthenticationSettings authSettings;
        StorageConnectionString storageConnectionString = StorageConnectionString.create(connectionString, LOGGER);
        StorageEndpoint endpoint = storageConnectionString.getBlobEndpoint();
        if (endpoint == null || endpoint.getPrimaryUri() == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException("connectionString missing required settings to derive service endpoint."));
        }
        this.endpoint(endpoint.getPrimaryUri());
        if (storageConnectionString.getAccountName() != null) {
            this.accountName = storageConnectionString.getAccountName();
        }
        if ((authSettings = storageConnectionString.getStorageAuthSettings()).getType() == StorageAuthenticationSettings.Type.ACCOUNT_NAME_KEY) {
            this.credential(new StorageSharedKeyCredential(authSettings.getAccount().getName(), authSettings.getAccount().getAccessKey()));
        } else if (authSettings.getType() == StorageAuthenticationSettings.Type.SAS_TOKEN) {
            this.sasToken(authSettings.getSasToken());
        }
        return this;
    }

    @Override
    public DataLakeServiceClientBuilder httpClient(HttpClient httpClient) {
        this.blobServiceClientBuilder.httpClient(httpClient);
        if (this.httpClient != null && httpClient == null) {
            LOGGER.info("'httpClient' is being set to 'null' when it was previously configured.");
        }
        this.httpClient = httpClient;
        return this;
    }

    @Override
    public DataLakeServiceClientBuilder addPolicy(HttpPipelinePolicy pipelinePolicy) {
        this.blobServiceClientBuilder.addPolicy(pipelinePolicy);
        Objects.requireNonNull(pipelinePolicy, "'pipelinePolicy' cannot be null");
        if (pipelinePolicy.getPipelinePosition() == HttpPipelinePosition.PER_CALL) {
            this.perCallPolicies.add(pipelinePolicy);
        } else {
            this.perRetryPolicies.add(pipelinePolicy);
        }
        return this;
    }

    @Override
    public DataLakeServiceClientBuilder httpLogOptions(HttpLogOptions logOptions) {
        this.blobServiceClientBuilder.httpLogOptions(logOptions);
        this.logOptions = Objects.requireNonNull(logOptions, "'logOptions' cannot be null.");
        return this;
    }

    public static HttpLogOptions getDefaultHttpLogOptions() {
        return BuilderHelper.getDefaultHttpLogOptions();
    }

    @Override
    public DataLakeServiceClientBuilder configuration(Configuration configuration) {
        this.blobServiceClientBuilder.configuration(configuration);
        this.configuration = configuration;
        return this;
    }

    public DataLakeServiceClientBuilder retryOptions(RequestRetryOptions retryOptions) {
        this.blobServiceClientBuilder.retryOptions(retryOptions);
        this.retryOptions = retryOptions;
        return this;
    }

    @Override
    public DataLakeServiceClientBuilder retryOptions(RetryOptions retryOptions) {
        this.coreRetryOptions = retryOptions;
        return this;
    }

    @Override
    public DataLakeServiceClientBuilder pipeline(HttpPipeline httpPipeline) {
        this.blobServiceClientBuilder.pipeline(httpPipeline);
        if (this.httpPipeline != null && httpPipeline == null) {
            LOGGER.info("HttpPipeline is being set to 'null' when it was previously configured.");
        }
        this.httpPipeline = httpPipeline;
        return this;
    }

    @Override
    public DataLakeServiceClientBuilder clientOptions(ClientOptions clientOptions) {
        this.blobServiceClientBuilder.clientOptions(clientOptions);
        this.clientOptions = Objects.requireNonNull(clientOptions, "'clientOptions' cannot be null.");
        return this;
    }

    public DataLakeServiceClientBuilder serviceVersion(DataLakeServiceVersion version) {
        this.blobServiceClientBuilder.serviceVersion(TransformUtils.toBlobServiceVersion(version));
        this.version = version;
        return this;
    }

    public DataLakeServiceClientBuilder customerProvidedKey(CustomerProvidedKey customerProvidedKey) {
        if (customerProvidedKey == null) {
            this.blobServiceClientBuilder.customerProvidedKey(null);
        } else {
            this.blobServiceClientBuilder.customerProvidedKey(Transforms.toBlobCustomerProvidedKey(customerProvidedKey));
        }
        return this;
    }

    public DataLakeServiceClientBuilder fileSystemEncryptionScopeOptions(FileSystemEncryptionScopeOptions fileSystemEncryptionScopeOptions) {
        this.fileSystemEncryptionScopeOptions = fileSystemEncryptionScopeOptions;
        this.blobServiceClientBuilder.blobContainerEncryptionScope(Transforms.toBlobContainerEncryptionScope(fileSystemEncryptionScopeOptions));
        return this;
    }

    public DataLakeServiceClientBuilder encryptionScope(String encryptionScope) {
        this.blobServiceClientBuilder.encryptionScope(encryptionScope);
        return this;
    }

    public DataLakeServiceClientBuilder audience(DataLakeAudience audience) {
        this.audience = audience;
        if (audience != null) {
            this.blobServiceClientBuilder.audience(BlobAudience.fromString(audience.toString()));
        }
        return this;
    }
}

