/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.common.implementation.connectionstring;

import com.azure.core.util.logging.ClientLogger;
import java.util.HashMap;
import java.util.Map;

final class ConnectionSettings
implements Cloneable {
    private final Map<String, String> settings;

    public boolean hasSetting(String name) {
        return this.settings.containsKey(name);
    }

    public void removeSetting(String name) {
        this.settings.remove(name);
    }

    public String getSettingValue(String name) {
        return this.settings.get(name);
    }

    public boolean isEmpty() {
        return this.settings.isEmpty();
    }

    public void setSetting(String name, String value) {
        this.settings.put(name, value);
    }

    public static ConnectionSettings fromConnectionString(String connString, ClientLogger logger) {
        HashMap<String, String> map = new HashMap<String, String>();
        String[] settings = connString.split(";");
        for (int i = 0; i < settings.length; ++i) {
            String setting = settings[i].trim();
            if (setting.length() <= 0) continue;
            int idx = setting.indexOf("=");
            if (idx == -1 || idx == 0 || idx == settings[i].length() - 1) {
                throw logger.logExceptionAsError(new IllegalArgumentException("Invalid connection string."));
            }
            map.put(setting.substring(0, idx), setting.substring(idx + 1));
        }
        return new ConnectionSettings(map);
    }

    public ConnectionSettings clone() {
        return new ConnectionSettings(new HashMap<String, String>(this.settings));
    }

    private ConnectionSettings(Map<String, String> settings) {
        this.settings = settings;
    }
}

