/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob.specialized;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.RequestConditions;
import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.storage.blob.implementation.util.ModelHelper;
import com.azure.storage.blob.options.BlobAcquireLeaseOptions;
import com.azure.storage.blob.options.BlobBreakLeaseOptions;
import com.azure.storage.blob.options.BlobChangeLeaseOptions;
import com.azure.storage.blob.options.BlobReleaseLeaseOptions;
import com.azure.storage.blob.options.BlobRenewLeaseOptions;
import com.azure.storage.blob.specialized.BlobLeaseAsyncClient;
import com.azure.storage.blob.specialized.BlobLeaseClientBuilder;
import com.azure.storage.common.implementation.StorageImplUtils;
import java.time.Duration;

@ServiceClient(builder=BlobLeaseClientBuilder.class)
public final class BlobLeaseClient {
    private final BlobLeaseAsyncClient client;

    BlobLeaseClient(BlobLeaseAsyncClient client) {
        this.client = client;
    }

    public String getResourceUrl() {
        return this.client.getResourceUrl();
    }

    public String getLeaseId() {
        return this.client.getLeaseId();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public String acquireLease(int durationInSeconds) {
        return this.acquireLeaseWithResponse(durationInSeconds, null, null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<String> acquireLeaseWithResponse(int durationInSeconds, RequestConditions modifiedRequestConditions, Duration timeout, Context context) {
        return this.acquireLeaseWithResponse(new BlobAcquireLeaseOptions(durationInSeconds).setRequestConditions(ModelHelper.populateBlobLeaseRequestConditions(modifiedRequestConditions)), timeout, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<String> acquireLeaseWithResponse(BlobAcquireLeaseOptions options, Duration timeout, Context context) {
        return StorageImplUtils.blockWithOptionalTimeout(this.client.acquireLeaseWithResponse(options, context), timeout);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public String renewLease() {
        return this.renewLeaseWithResponse((RequestConditions)null, null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<String> renewLeaseWithResponse(RequestConditions modifiedRequestConditions, Duration timeout, Context context) {
        return this.renewLeaseWithResponse(new BlobRenewLeaseOptions().setRequestConditions(ModelHelper.populateBlobLeaseRequestConditions(modifiedRequestConditions)), timeout, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<String> renewLeaseWithResponse(BlobRenewLeaseOptions options, Duration timeout, Context context) {
        return StorageImplUtils.blockWithOptionalTimeout(this.client.renewLeaseWithResponse(options, context), timeout);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void releaseLease() {
        this.releaseLeaseWithResponse((RequestConditions)null, null, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> releaseLeaseWithResponse(RequestConditions modifiedRequestConditions, Duration timeout, Context context) {
        return this.releaseLeaseWithResponse(new BlobReleaseLeaseOptions().setRequestConditions(ModelHelper.populateBlobLeaseRequestConditions(modifiedRequestConditions)), timeout, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> releaseLeaseWithResponse(BlobReleaseLeaseOptions options, Duration timeout, Context context) {
        return StorageImplUtils.blockWithOptionalTimeout(this.client.releaseLeaseWithResponse(options, context), timeout);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Integer breakLease() {
        return this.breakLeaseWithResponse(null, null, null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Integer> breakLeaseWithResponse(Integer breakPeriodInSeconds, RequestConditions modifiedRequestConditions, Duration timeout, Context context) {
        return this.breakLeaseWithResponse(new BlobBreakLeaseOptions().setBreakPeriod(breakPeriodInSeconds == null ? null : Duration.ofSeconds(breakPeriodInSeconds.intValue())).setRequestConditions(ModelHelper.populateBlobLeaseRequestConditions(modifiedRequestConditions)), timeout, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Integer> breakLeaseWithResponse(BlobBreakLeaseOptions options, Duration timeout, Context context) {
        return StorageImplUtils.blockWithOptionalTimeout(this.client.breakLeaseWithResponse(options, context), timeout);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public String changeLease(String proposedId) {
        return this.changeLeaseWithResponse(proposedId, null, null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<String> changeLeaseWithResponse(String proposedId, RequestConditions modifiedRequestConditions, Duration timeout, Context context) {
        return this.changeLeaseWithResponse(new BlobChangeLeaseOptions(proposedId).setRequestConditions(ModelHelper.populateBlobLeaseRequestConditions(modifiedRequestConditions)), timeout, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<String> changeLeaseWithResponse(BlobChangeLeaseOptions options, Duration timeout, Context context) {
        return StorageImplUtils.blockWithOptionalTimeout(this.client.changeLeaseWithResponse(options, context), timeout);
    }

    public String getAccountName() {
        return this.client.getAccountName();
    }
}

