/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob.implementation.models;

import com.azure.core.http.HttpHeaderName;
import com.azure.core.http.HttpHeaders;
import com.azure.core.util.DateTimeRfc1123;
import com.azure.storage.blob.models.AccountKind;
import com.azure.storage.blob.models.SkuName;
import java.time.OffsetDateTime;
import org.apache.iceberg.azure.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.iceberg.azure.shaded.com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;

@JacksonXmlRootElement(localName="null")
public final class ServicesGetAccountInfoHeaders {
    @JsonProperty(value="x-ms-version")
    private String xMsVersion;
    @JsonProperty(value="x-ms-account-kind")
    private AccountKind xMsAccountKind;
    @JsonProperty(value="x-ms-is-hns-enabled")
    private Boolean xMsIsHnsEnabled;
    @JsonProperty(value="x-ms-sku-name")
    private SkuName xMsSkuName;
    @JsonProperty(value="x-ms-request-id")
    private String xMsRequestId;
    @JsonProperty(value="x-ms-client-request-id")
    private String xMsClientRequestId;
    @JsonProperty(value="Date")
    private DateTimeRfc1123 date;
    private static final HttpHeaderName X_MS_VERSION = HttpHeaderName.fromString("x-ms-version");
    private static final HttpHeaderName X_MS_ACCOUNT_KIND = HttpHeaderName.fromString("x-ms-account-kind");
    private static final HttpHeaderName X_MS_IS_HNS_ENABLED = HttpHeaderName.fromString("x-ms-is-hns-enabled");
    private static final HttpHeaderName X_MS_SKU_NAME = HttpHeaderName.fromString("x-ms-sku-name");
    private static final HttpHeaderName X_MS_REQUEST_ID = HttpHeaderName.fromString("x-ms-request-id");

    public ServicesGetAccountInfoHeaders(HttpHeaders rawHeaders) {
        String xMsSkuName;
        String xMsIsHnsEnabled;
        this.xMsVersion = rawHeaders.getValue(X_MS_VERSION);
        String xMsAccountKind = rawHeaders.getValue(X_MS_ACCOUNT_KIND);
        if (xMsAccountKind != null) {
            this.xMsAccountKind = AccountKind.fromString(xMsAccountKind);
        }
        if ((xMsIsHnsEnabled = rawHeaders.getValue(X_MS_IS_HNS_ENABLED)) != null) {
            this.xMsIsHnsEnabled = Boolean.parseBoolean(xMsIsHnsEnabled);
        }
        if ((xMsSkuName = rawHeaders.getValue(X_MS_SKU_NAME)) != null) {
            this.xMsSkuName = SkuName.fromString(xMsSkuName);
        }
        this.xMsRequestId = rawHeaders.getValue(X_MS_REQUEST_ID);
        this.xMsClientRequestId = rawHeaders.getValue(HttpHeaderName.X_MS_CLIENT_REQUEST_ID);
        String date = rawHeaders.getValue(HttpHeaderName.DATE);
        if (date != null) {
            this.date = new DateTimeRfc1123(date);
        }
    }

    public String getXMsVersion() {
        return this.xMsVersion;
    }

    public ServicesGetAccountInfoHeaders setXMsVersion(String xMsVersion) {
        this.xMsVersion = xMsVersion;
        return this;
    }

    public AccountKind getXMsAccountKind() {
        return this.xMsAccountKind;
    }

    public ServicesGetAccountInfoHeaders setXMsAccountKind(AccountKind xMsAccountKind) {
        this.xMsAccountKind = xMsAccountKind;
        return this;
    }

    public Boolean isXMsIsHnsEnabled() {
        return this.xMsIsHnsEnabled;
    }

    public ServicesGetAccountInfoHeaders setXMsIsHnsEnabled(Boolean xMsIsHnsEnabled) {
        this.xMsIsHnsEnabled = xMsIsHnsEnabled;
        return this;
    }

    public SkuName getXMsSkuName() {
        return this.xMsSkuName;
    }

    public ServicesGetAccountInfoHeaders setXMsSkuName(SkuName xMsSkuName) {
        this.xMsSkuName = xMsSkuName;
        return this;
    }

    public String getXMsRequestId() {
        return this.xMsRequestId;
    }

    public ServicesGetAccountInfoHeaders setXMsRequestId(String xMsRequestId) {
        this.xMsRequestId = xMsRequestId;
        return this;
    }

    public String getXMsClientRequestId() {
        return this.xMsClientRequestId;
    }

    public ServicesGetAccountInfoHeaders setXMsClientRequestId(String xMsClientRequestId) {
        this.xMsClientRequestId = xMsClientRequestId;
        return this;
    }

    public OffsetDateTime getDate() {
        if (this.date == null) {
            return null;
        }
        return this.date.getDateTime();
    }

    public ServicesGetAccountInfoHeaders setDate(OffsetDateTime date) {
        this.date = date == null ? null : new DateTimeRfc1123(date);
        return this;
    }
}

