/*
 * Decompiled with CFR 0.152.
 */
package com.azure.identity;

import com.azure.core.credential.AccessToken;
import com.azure.core.credential.TokenCredential;
import com.azure.core.credential.TokenRequestContext;
import com.azure.core.util.logging.ClientLogger;
import com.azure.identity.implementation.IdentityClient;
import com.azure.identity.implementation.IdentityClientBuilder;
import com.azure.identity.implementation.IdentityClientOptions;
import com.azure.identity.implementation.IdentitySyncClient;
import com.azure.identity.implementation.util.LoggingUtil;
import java.util.Objects;
import reactor.core.publisher.Mono;

public class ClientCertificateCredential
implements TokenCredential {
    private static final ClientLogger LOGGER = new ClientLogger(ClientCertificateCredential.class);
    private final IdentityClient identityClient;
    private final IdentitySyncClient identitySyncClient;

    ClientCertificateCredential(String tenantId, String clientId, String certificatePath, byte[] certificate, String certificatePassword, IdentityClientOptions identityClientOptions) {
        Objects.requireNonNull(certificatePath == null ? certificate : (byte[])certificatePath, "'certificate' and 'certificatePath' cannot both be null.");
        IdentityClientBuilder builder = new IdentityClientBuilder().tenantId(tenantId).clientId(clientId).certificatePath(certificatePath).certificate(certificate).certificatePassword(certificatePassword).identityClientOptions(identityClientOptions);
        this.identityClient = builder.build();
        this.identitySyncClient = builder.buildSyncClient();
    }

    @Override
    public Mono<AccessToken> getToken(TokenRequestContext request) {
        return this.identityClient.authenticateWithConfidentialClientCache(request).onErrorResume(t -> Mono.empty()).switchIfEmpty(Mono.defer(() -> this.identityClient.authenticateWithConfidentialClient(request))).doOnNext(token -> LoggingUtil.logTokenSuccess(LOGGER, request)).doOnError(error -> LoggingUtil.logTokenError(LOGGER, this.identityClient.getIdentityClientOptions(), request, error));
    }

    @Override
    public AccessToken getTokenSync(TokenRequestContext request) {
        try {
            AccessToken token = this.identitySyncClient.authenticateWithConfidentialClientCache(request);
            LoggingUtil.logTokenSuccess(LOGGER, request);
            return token;
        }
        catch (Exception token) {
            try {
                AccessToken token2 = this.identitySyncClient.authenticateWithConfidentialClient(request);
                LoggingUtil.logTokenSuccess(LOGGER, request);
                return token2;
            }
            catch (Exception e) {
                LoggingUtil.logTokenError(LOGGER, this.identityClient.getIdentityClientOptions(), request, e);
                throw e;
            }
        }
    }
}

