/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.util;

import com.azure.core.implementation.ReflectionUtils;
import com.azure.core.implementation.ReflectiveInvoker;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.logging.LogLevel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.iceberg.azure.shaded.com.fasterxml.jackson.annotation.JsonValue;

public abstract class ExpandableStringEnum<T extends ExpandableStringEnum<T>> {
    private static final Map<Class<?>, ReflectiveInvoker> CONSTRUCTORS = new ConcurrentHashMap();
    private static final Map<Class<?>, ConcurrentHashMap<String, ? extends ExpandableStringEnum<?>>> VALUES = new ConcurrentHashMap();
    private static final ClientLogger LOGGER = new ClientLogger(ExpandableStringEnum.class);
    private String name;
    private Class<T> clazz;

    @Deprecated
    public ExpandableStringEnum() {
    }

    protected static <T extends ExpandableStringEnum<T>> T fromString(String name, Class<T> clazz) {
        ReflectiveInvoker ctor;
        if (name == null) {
            return null;
        }
        ConcurrentHashMap clazzValues = VALUES.computeIfAbsent(clazz, key -> new ConcurrentHashMap());
        ExpandableStringEnum value = (ExpandableStringEnum)clazzValues.get(name);
        if (value != null) {
            return (T)value;
        }
        if (CONSTRUCTORS.size() > 10000) {
            CONSTRUCTORS.clear();
        }
        if ((ctor = CONSTRUCTORS.computeIfAbsent(clazz, ExpandableStringEnum::getDefaultConstructor)) == null) {
            return null;
        }
        try {
            value = (ExpandableStringEnum)ctor.invokeWithArguments(null, new Object[0]);
        }
        catch (Exception e) {
            LOGGER.log(LogLevel.WARNING, () -> "Failed to create " + clazz.getName() + ", default constructor threw exception", e);
            return null;
        }
        return (T)value.nameAndAddValue(name, value, clazz);
    }

    private static <T> ReflectiveInvoker getDefaultConstructor(Class<T> clazz) {
        try {
            return ReflectionUtils.getConstructorInvoker(clazz, clazz.getDeclaredConstructor(new Class[0]));
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            LOGGER.log(LogLevel.VERBOSE, () -> "Can't find or access default constructor for " + clazz.getName() + ", make sure corresponding package is open to azure-core", e);
        }
        catch (Exception e) {
            LOGGER.log(LogLevel.VERBOSE, () -> "Failed to get default constructor for " + clazz.getName(), e);
        }
        return null;
    }

    T nameAndAddValue(String name, T value, Class<T> clazz) {
        this.name = name;
        this.clazz = clazz;
        VALUES.get(clazz).put(name, (ExpandableStringEnum<?>)value);
        return (T)this;
    }

    protected static <T extends ExpandableStringEnum<T>> Collection<T> values(Class<T> clazz) {
        return new ArrayList(VALUES.getOrDefault(clazz, new ConcurrentHashMap()).values());
    }

    @JsonValue
    public String toString() {
        return this.name;
    }

    public int hashCode() {
        return Objects.hash(this.clazz, this.name);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.clazz == null || !this.clazz.isAssignableFrom(obj.getClass())) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (this.name == null) {
            return ((ExpandableStringEnum)obj).name == null;
        }
        return this.name.equals(((ExpandableStringEnum)obj).name);
    }
}

