/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.models;

import com.azure.core.implementation.Option;
import com.azure.core.models.JsonPatchOperationKind;
import com.azure.core.models.JsonPatchOperationSerializer;
import java.util.Objects;
import org.apache.iceberg.azure.shaded.com.fasterxml.jackson.databind.annotation.JsonSerialize;

@JsonSerialize(using=JsonPatchOperationSerializer.class)
final class JsonPatchOperation {
    private final JsonPatchOperationKind op;
    private final String from;
    private final String path;
    private final Option<String> value;

    JsonPatchOperation(JsonPatchOperationKind op, String from, String path, Option<String> value) {
        this.op = op;
        this.from = from;
        this.path = path;
        this.value = value;
    }

    JsonPatchOperationKind getOp() {
        return this.op;
    }

    String getFrom() {
        return this.from;
    }

    String getPath() {
        return this.path;
    }

    Option<String> getValue() {
        return this.value;
    }

    public int hashCode() {
        return Objects.hash(this.op.toString(), this.from, this.path, this.value == null ? null : this.value.getValue());
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof JsonPatchOperation)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        JsonPatchOperation other = (JsonPatchOperation)obj;
        return Objects.equals((Object)this.op, (Object)other.op) && Objects.equals(this.from, other.from) && Objects.equals(this.path, other.path) && Objects.equals(this.value, other.value);
    }

    public String toString() {
        return this.buildString(new StringBuilder()).toString();
    }

    StringBuilder buildString(StringBuilder builder) {
        builder.append("{\"op\":\"").append(this.op.toString()).append("\"");
        if (this.from != null) {
            builder.append(",\"from\":\"").append(this.from).append("\"");
        }
        builder.append(",\"path\":\"").append(this.path).append("\"");
        if (this.value.isInitialized()) {
            builder.append(",\"value\":").append(this.value.getValue());
        }
        return builder.append("}");
    }
}

