/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.implementation.jackson;

import com.azure.core.implementation.util.BinaryDataContent;
import com.azure.core.implementation.util.BinaryDataHelper;
import com.azure.core.util.BinaryData;
import com.azure.core.util.logging.ClientLogger;
import java.io.IOException;
import org.apache.iceberg.azure.shaded.com.fasterxml.jackson.core.JsonGenerator;
import org.apache.iceberg.azure.shaded.com.fasterxml.jackson.databind.JsonSerializer;
import org.apache.iceberg.azure.shaded.com.fasterxml.jackson.databind.SerializerProvider;
import org.apache.iceberg.azure.shaded.com.fasterxml.jackson.databind.module.SimpleModule;

final class BinaryDataSerializer
extends JsonSerializer<BinaryData> {
    private static final ClientLogger LOGGER = new ClientLogger(BinaryDataSerializer.class);

    BinaryDataSerializer() {
    }

    public static SimpleModule getModule() {
        SimpleModule module = new SimpleModule();
        module.addSerializer(BinaryData.class, new BinaryDataSerializer());
        return module;
    }

    @Override
    public void serialize(BinaryData value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
        if (value == null) {
            return;
        }
        BinaryDataContent content = BinaryDataHelper.getContent(value);
        switch (content.getContentType()) {
            case BINARY: {
                gen.writeBinary(content.toBytes());
                break;
            }
            case OBJECT: {
                gen.writeRawValue(content.toString());
                break;
            }
            case TEXT: {
                gen.writeString(content.toString());
                break;
            }
            default: {
                throw LOGGER.logExceptionAsError(new IllegalStateException("Unsupported BinaryData content type: " + content.getClass().getName()));
            }
        }
    }
}

