/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.credential;

import com.azure.core.credential.AccessToken;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.logging.LogLevel;
import com.azure.core.util.logging.LoggingEventBuilder;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import java.util.function.Supplier;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Sinks;

public class SimpleTokenCache {
    private static final Duration REFRESH_DELAY = Duration.ofSeconds(30L);
    private static final String REFRESH_DELAY_STRING = String.valueOf(REFRESH_DELAY.getSeconds());
    private static final Duration REFRESH_OFFSET = Duration.ofMinutes(5L);
    private static final ClientLogger LOGGER = new ClientLogger(SimpleTokenCache.class);
    private final AtomicReference<Sinks.One<AccessToken>> wip;
    private volatile AccessToken cache;
    private volatile OffsetDateTime nextTokenRefresh = OffsetDateTime.now();
    private final Supplier<Mono<AccessToken>> tokenSupplier;
    private final Predicate<AccessToken> shouldRefresh;

    public SimpleTokenCache(Supplier<Mono<AccessToken>> tokenSupplier) {
        this.wip = new AtomicReference();
        this.tokenSupplier = tokenSupplier;
        this.shouldRefresh = accessToken -> OffsetDateTime.now().isAfter(accessToken.getExpiresAt().minus(REFRESH_OFFSET));
    }

    public Mono<AccessToken> getToken() {
        return Mono.defer(() -> {
            try {
                if (this.wip.compareAndSet(null, Sinks.one())) {
                    Mono<AccessToken> fallback;
                    Mono<Object> tokenRefresh;
                    Sinks.One<AccessToken> sinksOne = this.wip.get();
                    OffsetDateTime now = OffsetDateTime.now();
                    if (this.cache != null && !this.shouldRefresh.test(this.cache)) {
                        tokenRefresh = Mono.empty();
                        fallback = Mono.just(this.cache);
                    } else if (this.cache == null || this.cache.isExpired()) {
                        tokenRefresh = now.isAfter(this.nextTokenRefresh) ? Mono.defer(this.tokenSupplier) : Mono.defer(this.tokenSupplier).delaySubscription(Duration.between(now, this.nextTokenRefresh));
                        fallback = Mono.empty();
                    } else {
                        tokenRefresh = now.isAfter(this.nextTokenRefresh) ? Mono.defer(this.tokenSupplier) : Mono.empty();
                        fallback = Mono.just(this.cache);
                    }
                    return Mono.using(() -> this.wip, ignored -> tokenRefresh.materialize().flatMap(signal -> {
                        AccessToken accessToken = (AccessToken)signal.get();
                        Throwable error = signal.getThrowable();
                        if (signal.isOnNext() && accessToken != null) {
                            SimpleTokenCache.buildTokenRefreshLog(LogLevel.INFORMATIONAL, this.cache, now).log("Acquired a new access token");
                            this.cache = accessToken;
                            sinksOne.tryEmitValue(accessToken);
                            this.nextTokenRefresh = OffsetDateTime.now().plus(REFRESH_DELAY);
                            return Mono.just(accessToken);
                        }
                        if (signal.isOnError() && error != null) {
                            SimpleTokenCache.buildTokenRefreshLog(LogLevel.ERROR, this.cache, now).log("Failed to acquire a new access token");
                            this.nextTokenRefresh = OffsetDateTime.now().plus(REFRESH_DELAY);
                            return fallback.switchIfEmpty(Mono.error(() -> error));
                        }
                        sinksOne.tryEmitEmpty();
                        return fallback;
                    }).doOnError(sinksOne::tryEmitError), w -> w.set(null));
                }
                if (this.cache != null && !this.cache.isExpired()) {
                    return Mono.just(this.cache);
                }
                Sinks.One<AccessToken> sinksOne = this.wip.get();
                if (sinksOne == null) {
                    return Mono.just(this.cache);
                }
                return sinksOne.asMono().switchIfEmpty(Mono.fromSupplier(() -> this.cache));
            }
            catch (Exception t) {
                return Mono.error(t);
            }
        });
    }

    Sinks.One<AccessToken> getWipValue() {
        return this.wip.get();
    }

    private static LoggingEventBuilder buildTokenRefreshLog(LogLevel level, AccessToken cache, OffsetDateTime now) {
        LoggingEventBuilder logBuilder = LOGGER.atLevel(level);
        if (cache == null || !LOGGER.canLogAtLevel(level)) {
            return logBuilder;
        }
        Duration tte = Duration.between(now, cache.getExpiresAt());
        return logBuilder.addKeyValue("expiresAt", cache.getExpiresAt()).addKeyValue("tteSeconds", String.valueOf(tte.abs().getSeconds())).addKeyValue("retryAfterSeconds", REFRESH_DELAY_STRING).addKeyValue("expired", tte.isNegative());
    }
}

