/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.aws.s3;

import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.base.Strings;
import org.apache.iceberg.rest.ErrorHandlers;
import org.apache.iceberg.rest.HTTPClient;
import org.apache.iceberg.rest.RESTClient;
import org.apache.iceberg.rest.auth.OAuth2Util;
import org.apache.iceberg.rest.credentials.Credential;
import org.apache.iceberg.rest.responses.LoadCredentialsResponse;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.AwsSessionCredentials;
import software.amazon.awssdk.utils.IoUtils;
import software.amazon.awssdk.utils.SdkAutoCloseable;
import software.amazon.awssdk.utils.cache.CachedSupplier;
import software.amazon.awssdk.utils.cache.RefreshResult;

public class VendedCredentialsProvider
implements AwsCredentialsProvider,
SdkAutoCloseable {
    public static final String URI = "credentials.uri";
    private volatile HTTPClient client;
    private final Map<String, String> properties;
    private final CachedSupplier<AwsCredentials> credentialCache;

    private VendedCredentialsProvider(Map<String, String> properties) {
        Preconditions.checkArgument((null != properties ? 1 : 0) != 0, (Object)"Invalid properties: null");
        Preconditions.checkArgument((null != properties.get(URI) ? 1 : 0) != 0, (Object)"Invalid URI: null");
        this.properties = properties;
        this.credentialCache = CachedSupplier.builder(() -> this.credentialFromProperties().orElseGet(this::refreshCredential)).cachedValueName(VendedCredentialsProvider.class.getName()).build();
    }

    public AwsCredentials resolveCredentials() {
        return (AwsCredentials)this.credentialCache.get();
    }

    public void close() {
        IoUtils.closeQuietly((AutoCloseable)this.client, null);
        this.credentialCache.close();
    }

    public static VendedCredentialsProvider create(Map<String, String> properties) {
        return new VendedCredentialsProvider(properties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RESTClient httpClient() {
        if (null == this.client) {
            VendedCredentialsProvider vendedCredentialsProvider = this;
            synchronized (vendedCredentialsProvider) {
                if (null == this.client) {
                    this.client = HTTPClient.builder(this.properties).uri(this.properties.get(URI)).build();
                }
            }
        }
        return this.client;
    }

    private LoadCredentialsResponse fetchCredentials() {
        return (LoadCredentialsResponse)this.httpClient().get(this.properties.get(URI), null, LoadCredentialsResponse.class, OAuth2Util.authHeaders((String)this.properties.get("token")), ErrorHandlers.defaultErrorHandler());
    }

    private Optional<RefreshResult<AwsCredentials>> credentialFromProperties() {
        String accessKeyId = this.properties.get("s3.access-key-id");
        String secretAccessKey = this.properties.get("s3.secret-access-key");
        String sessionToken = this.properties.get("s3.session-token");
        String tokenExpiresAtMillis = this.properties.get("s3.session-token-expires-at-ms");
        if (Strings.isNullOrEmpty((String)accessKeyId) || Strings.isNullOrEmpty((String)secretAccessKey) || Strings.isNullOrEmpty((String)sessionToken) || Strings.isNullOrEmpty((String)tokenExpiresAtMillis)) {
            return Optional.empty();
        }
        Instant expiresAt = Instant.ofEpochMilli(Long.parseLong(tokenExpiresAtMillis));
        Instant prefetchAt = expiresAt.minus(5L, ChronoUnit.MINUTES);
        if (Instant.now().isAfter(prefetchAt)) {
            return Optional.empty();
        }
        return Optional.of(RefreshResult.builder((Object)AwsSessionCredentials.builder().accessKeyId(accessKeyId).secretAccessKey(secretAccessKey).sessionToken(sessionToken).expirationTime(expiresAt).build()).staleTime(expiresAt).prefetchTime(prefetchAt).build());
    }

    private RefreshResult<AwsCredentials> refreshCredential() {
        LoadCredentialsResponse response = this.fetchCredentials();
        List s3Credentials = response.credentials().stream().filter(c -> c.prefix().startsWith("s3")).collect(Collectors.toList());
        Preconditions.checkState((!s3Credentials.isEmpty() ? 1 : 0) != 0, (Object)"Invalid S3 Credentials: empty");
        Preconditions.checkState((s3Credentials.size() == 1 ? 1 : 0) != 0, (Object)"Invalid S3 Credentials: only one S3 credential should exist");
        Credential s3Credential = (Credential)s3Credentials.get(0);
        this.checkCredential(s3Credential, "s3.access-key-id");
        this.checkCredential(s3Credential, "s3.secret-access-key");
        this.checkCredential(s3Credential, "s3.session-token");
        this.checkCredential(s3Credential, "s3.session-token-expires-at-ms");
        String accessKeyId = (String)s3Credential.config().get("s3.access-key-id");
        String secretAccessKey = (String)s3Credential.config().get("s3.secret-access-key");
        String sessionToken = (String)s3Credential.config().get("s3.session-token");
        String tokenExpiresAtMillis = (String)s3Credential.config().get("s3.session-token-expires-at-ms");
        Instant expiresAt = Instant.ofEpochMilli(Long.parseLong(tokenExpiresAtMillis));
        Instant prefetchAt = expiresAt.minus(5L, ChronoUnit.MINUTES);
        return RefreshResult.builder((Object)AwsSessionCredentials.builder().accessKeyId(accessKeyId).secretAccessKey(secretAccessKey).sessionToken(sessionToken).expirationTime(expiresAt).build()).staleTime(expiresAt).prefetchTime(prefetchAt).build();
    }

    private void checkCredential(Credential credential, String property) {
        Preconditions.checkState((boolean)credential.config().containsKey(property), (String)"Invalid S3 Credentials: %s not set", (Object)property);
    }
}

