/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.aws.s3;

import java.io.IOException;
import java.io.UncheckedIOException;
import org.apache.iceberg.aws.AwsProperties;
import org.apache.iceberg.aws.s3.BaseS3File;
import org.apache.iceberg.aws.s3.S3InputFile;
import org.apache.iceberg.aws.s3.S3OutputStream;
import org.apache.iceberg.aws.s3.S3URI;
import org.apache.iceberg.encryption.NativeFileCryptoParameters;
import org.apache.iceberg.encryption.NativelyEncryptedFile;
import org.apache.iceberg.exceptions.AlreadyExistsException;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.io.OutputFile;
import org.apache.iceberg.io.PositionOutputStream;
import org.apache.iceberg.metrics.MetricsContext;
import software.amazon.awssdk.services.s3.S3Client;

public class S3OutputFile
extends BaseS3File
implements OutputFile,
NativelyEncryptedFile {
    private NativeFileCryptoParameters nativeEncryptionParameters;

    public static S3OutputFile fromLocation(String location, S3Client client, AwsProperties awsProperties, MetricsContext metrics) {
        return new S3OutputFile(client, new S3URI(location, awsProperties.s3BucketToAccessPointMapping()), awsProperties, metrics);
    }

    S3OutputFile(S3Client client, S3URI uri, AwsProperties awsProperties, MetricsContext metrics) {
        super(client, uri, awsProperties, metrics);
    }

    public PositionOutputStream create() {
        if (!this.exists()) {
            return this.createOrOverwrite();
        }
        throw new AlreadyExistsException("Location already exists: %s", new Object[]{this.uri()});
    }

    public PositionOutputStream createOrOverwrite() {
        try {
            return new S3OutputStream(this.client(), this.uri(), this.awsProperties(), this.metrics());
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to create output stream for location: " + this.uri(), e);
        }
    }

    public InputFile toInputFile() {
        return new S3InputFile(this.client(), this.uri(), null, this.awsProperties(), this.metrics());
    }

    public NativeFileCryptoParameters nativeCryptoParameters() {
        return this.nativeEncryptionParameters;
    }

    public void setNativeCryptoParameters(NativeFileCryptoParameters nativeCryptoParameters) {
        this.nativeEncryptionParameters = nativeCryptoParameters;
    }
}

