/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.aws.lakeformation;

import java.util.Map;
import org.apache.iceberg.aws.AssumeRoleAwsClientFactory;
import org.apache.iceberg.aws.AwsClientFactories;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.AwsSessionCredentials;
import software.amazon.awssdk.regions.PartitionMetadata;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.glue.model.GetTableRequest;
import software.amazon.awssdk.services.glue.model.GetTableResponse;
import software.amazon.awssdk.services.kms.KmsClient;
import software.amazon.awssdk.services.kms.KmsClientBuilder;
import software.amazon.awssdk.services.lakeformation.LakeFormationClient;
import software.amazon.awssdk.services.lakeformation.LakeFormationClientBuilder;
import software.amazon.awssdk.services.lakeformation.model.GetTemporaryGlueTableCredentialsRequest;
import software.amazon.awssdk.services.lakeformation.model.GetTemporaryGlueTableCredentialsResponse;
import software.amazon.awssdk.services.lakeformation.model.PermissionType;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.S3ClientBuilder;
import software.amazon.awssdk.services.s3.S3Configuration;

public class LakeFormationAwsClientFactory
extends AssumeRoleAwsClientFactory {
    public static final String LF_AUTHORIZED_CALLER = "LakeFormationAuthorizedCaller";
    private String dbName;
    private String tableName;
    private String glueCatalogId;
    private String glueAccountId;

    @Override
    public void initialize(Map<String, String> catalogProperties) {
        super.initialize(catalogProperties);
        Preconditions.checkArgument((boolean)this.tags().stream().anyMatch(t -> t.key().equals(LF_AUTHORIZED_CALLER)), (String)"STS assume role session tag %s must be set using %s to use LakeFormation client factory", (Object)LF_AUTHORIZED_CALLER, (Object)"client.assume-role.tags.");
        this.dbName = catalogProperties.get("lakeformation.db-name");
        this.tableName = catalogProperties.get("lakeformation.table-name");
        this.glueCatalogId = catalogProperties.get("glue.id");
        this.glueAccountId = catalogProperties.get("glue.account-id");
    }

    @Override
    public S3Client s3() {
        if (this.isTableRegisteredWithLakeFormation()) {
            return (S3Client)((S3ClientBuilder)((S3ClientBuilder)((S3ClientBuilder)((S3ClientBuilder)((S3ClientBuilder)S3Client.builder().httpClientBuilder(AwsClientFactories.configureHttpClientBuilder(this.httpClientType()))).applyMutation(builder -> AwsClientFactories.configureEndpoint(builder, this.s3Endpoint()))).credentialsProvider((AwsCredentialsProvider)new LakeFormationCredentialsProvider(this.lakeFormation(), this.buildTableArn()))).serviceConfiguration(s -> {
                S3Configuration cfr_ignored_0 = (S3Configuration)s.useArnRegionEnabled(Boolean.valueOf(this.s3UseArnRegionEnabled())).build();
            })).region(Region.of((String)this.region()))).build();
        }
        return super.s3();
    }

    @Override
    public KmsClient kms() {
        if (this.isTableRegisteredWithLakeFormation()) {
            return (KmsClient)((KmsClientBuilder)((KmsClientBuilder)((KmsClientBuilder)KmsClient.builder().httpClientBuilder(AwsClientFactories.configureHttpClientBuilder(this.httpClientType()))).credentialsProvider((AwsCredentialsProvider)new LakeFormationCredentialsProvider(this.lakeFormation(), this.buildTableArn()))).region(Region.of((String)this.region()))).build();
        }
        return super.kms();
    }

    private boolean isTableRegisteredWithLakeFormation() {
        Preconditions.checkArgument((this.dbName != null && !this.dbName.isEmpty() ? 1 : 0) != 0, (Object)"Database name can not be empty");
        Preconditions.checkArgument((this.tableName != null && !this.tableName.isEmpty() ? 1 : 0) != 0, (Object)"Table name can not be empty");
        GetTableResponse response = this.glue().getTable((GetTableRequest)GetTableRequest.builder().catalogId(this.glueCatalogId).databaseName(this.dbName).name(this.tableName).build());
        return response.table().isRegisteredWithLakeFormation();
    }

    private String buildTableArn() {
        Preconditions.checkArgument((this.glueAccountId != null && !this.glueAccountId.isEmpty() ? 1 : 0) != 0, (String)"%s can not be empty", (Object)"glue.account-id");
        String partitionName = PartitionMetadata.of((Region)Region.of((String)this.region())).id();
        return String.format("arn:%s:glue:%s:%s:table/%s/%s", partitionName, this.region(), this.glueAccountId, this.dbName, this.tableName);
    }

    private LakeFormationClient lakeFormation() {
        return (LakeFormationClient)((LakeFormationClientBuilder)LakeFormationClient.builder().applyMutation(this::configure)).build();
    }

    static class LakeFormationCredentialsProvider
    implements AwsCredentialsProvider {
        private LakeFormationClient client;
        private String tableArn;

        LakeFormationCredentialsProvider(LakeFormationClient lakeFormationClient, String tableArn) {
            this.client = lakeFormationClient;
            this.tableArn = tableArn;
        }

        public AwsCredentials resolveCredentials() {
            GetTemporaryGlueTableCredentialsRequest getTemporaryGlueTableCredentialsRequest = (GetTemporaryGlueTableCredentialsRequest)GetTemporaryGlueTableCredentialsRequest.builder().tableArn(this.tableArn).supportedPermissionTypes(new PermissionType[]{PermissionType.COLUMN_PERMISSION}).build();
            GetTemporaryGlueTableCredentialsResponse response = this.client.getTemporaryGlueTableCredentials(getTemporaryGlueTableCredentialsRequest);
            return AwsSessionCredentials.create((String)response.accessKeyId(), (String)response.secretAccessKey(), (String)response.sessionToken());
        }
    }
}

