/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.aws;

import java.io.Serializable;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.Sets;
import org.apache.iceberg.util.PropertyUtil;
import software.amazon.awssdk.services.s3.model.ObjectCannedACL;
import software.amazon.awssdk.services.s3.model.Tag;

public class AwsProperties
implements Serializable {
    public static final String S3FILEIO_SSE_TYPE = "s3.sse.type";
    public static final String S3FILEIO_SSE_TYPE_NONE = "none";
    public static final String S3FILEIO_SSE_TYPE_KMS = "kms";
    public static final String S3FILEIO_SSE_TYPE_S3 = "s3";
    public static final String S3FILEIO_SSE_TYPE_CUSTOM = "custom";
    public static final String S3FILEIO_SSE_KEY = "s3.sse.key";
    public static final String S3FILEIO_SSE_MD5 = "s3.sse.md5";
    public static final String GLUE_CATALOG_ID = "glue.id";
    public static final String GLUE_ACCOUNT_ID = "glue.account-id";
    public static final String GLUE_CATALOG_SKIP_ARCHIVE = "glue.skip-archive";
    public static final boolean GLUE_CATALOG_SKIP_ARCHIVE_DEFAULT = false;
    public static final String GLUE_CATALOG_SKIP_NAME_VALIDATION = "glue.skip-name-validation";
    public static final boolean GLUE_CATALOG_SKIP_NAME_VALIDATION_DEFAULT = false;
    public static final String GLUE_LAKEFORMATION_ENABLED = "glue.lakeformation-enabled";
    public static final boolean GLUE_LAKEFORMATION_ENABLED_DEFAULT = false;
    public static final String S3FILEIO_MULTIPART_UPLOAD_THREADS = "s3.multipart.num-threads";
    public static final String S3FILEIO_MULTIPART_SIZE = "s3.multipart.part-size-bytes";
    public static final int S3FILEIO_MULTIPART_SIZE_DEFAULT = 0x2000000;
    public static final int S3FILEIO_MULTIPART_SIZE_MIN = 0x500000;
    public static final String S3FILEIO_MULTIPART_THRESHOLD_FACTOR = "s3.multipart.threshold";
    public static final double S3FILEIO_MULTIPART_THRESHOLD_FACTOR_DEFAULT = 1.5;
    public static final String S3FILEIO_STAGING_DIRECTORY = "s3.staging-dir";
    public static final String S3FILEIO_ACL = "s3.acl";
    public static final String S3FILEIO_ENDPOINT = "s3.endpoint";
    public static final String S3FILEIO_PATH_STYLE_ACCESS = "s3.path-style-access";
    public static final boolean S3FILEIO_PATH_STYLE_ACCESS_DEFAULT = false;
    public static final String S3FILEIO_ACCESS_KEY_ID = "s3.access-key-id";
    public static final String S3FILEIO_SECRET_ACCESS_KEY = "s3.secret-access-key";
    public static final String S3FILEIO_SESSION_TOKEN = "s3.session-token";
    public static final String S3_USE_ARN_REGION_ENABLED = "s3.use-arn-region-enabled";
    public static final boolean S3_USE_ARN_REGION_ENABLED_DEFAULT = false;
    public static final String S3_CHECKSUM_ENABLED = "s3.checksum-enabled";
    public static final boolean S3_CHECKSUM_ENABLED_DEFAULT = false;
    public static final String S3FILEIO_DELETE_BATCH_SIZE = "s3.delete.batch-size";
    public static final int S3FILEIO_DELETE_BATCH_SIZE_DEFAULT = 250;
    public static final int S3FILEIO_DELETE_BATCH_SIZE_MAX = 1000;
    public static final String DYNAMODB_ENDPOINT = "dynamodb.endpoint";
    public static final String DYNAMODB_TABLE_NAME = "dynamodb.table-name";
    public static final String DYNAMODB_TABLE_NAME_DEFAULT = "iceberg";
    public static final String CLIENT_FACTORY = "client.factory";
    public static final String CLIENT_ASSUME_ROLE_ARN = "client.assume-role.arn";
    public static final String CLIENT_ASSUME_ROLE_TAGS_PREFIX = "client.assume-role.tags.";
    public static final String CLIENT_ASSUME_ROLE_TIMEOUT_SEC = "client.assume-role.timeout-sec";
    public static final int CLIENT_ASSUME_ROLE_TIMEOUT_SEC_DEFAULT = 3600;
    public static final String CLIENT_ASSUME_ROLE_EXTERNAL_ID = "client.assume-role.external-id";
    public static final String CLIENT_ASSUME_ROLE_REGION = "client.assume-role.region";
    public static final String HTTP_CLIENT_TYPE = "http-client.type";
    public static final String HTTP_CLIENT_TYPE_URLCONNECTION = "urlconnection";
    public static final String HTTP_CLIENT_TYPE_APACHE = "apache";
    public static final String HTTP_CLIENT_TYPE_DEFAULT = "urlconnection";
    public static final String S3_WRITE_TAGS_PREFIX = "s3.write.tags.";
    public static final String S3_DELETE_TAGS_PREFIX = "s3.delete.tags.";
    public static final String S3FILEIO_DELETE_THREADS = "s3.delete.num-threads";
    public static final String S3_DELETE_ENABLED = "s3.delete-enabled";
    public static final boolean S3_DELETE_ENABLED_DEFAULT = true;
    public static final String S3_ACCESS_POINTS_PREFIX = "s3.access-points.";
    @Deprecated
    public static final boolean CLIENT_ENABLE_ETAG_CHECK_DEFAULT = false;
    public static final String LAKE_FORMATION_TABLE_NAME = "lakeformation.table-name";
    public static final String LAKE_FORMATION_DB_NAME = "lakeformation.db-name";
    private String s3FileIoSseType;
    private String s3FileIoSseKey;
    private String s3FileIoSseMd5;
    private int s3FileIoMultipartUploadThreads;
    private int s3FileIoMultiPartSize;
    private int s3FileIoDeleteBatchSize;
    private double s3FileIoMultipartThresholdFactor;
    private String s3fileIoStagingDirectory;
    private ObjectCannedACL s3FileIoAcl;
    private boolean isS3ChecksumEnabled;
    private final Set<Tag> s3WriteTags;
    private final Set<Tag> s3DeleteTags;
    private int s3FileIoDeleteThreads;
    private boolean isS3DeleteEnabled;
    private final Map<String, String> s3BucketToAccessPointMapping;
    private String glueCatalogId;
    private boolean glueCatalogSkipArchive;
    private boolean glueCatalogSkipNameValidation;
    private boolean glueLakeFormationEnabled;
    private String dynamoDbTableName;

    public AwsProperties() {
        this.s3FileIoSseType = S3FILEIO_SSE_TYPE_NONE;
        this.s3FileIoSseKey = null;
        this.s3FileIoSseMd5 = null;
        this.s3FileIoAcl = null;
        this.s3FileIoMultipartUploadThreads = Runtime.getRuntime().availableProcessors();
        this.s3FileIoMultiPartSize = 0x2000000;
        this.s3FileIoMultipartThresholdFactor = 1.5;
        this.s3FileIoDeleteBatchSize = 250;
        this.s3fileIoStagingDirectory = System.getProperty("java.io.tmpdir");
        this.isS3ChecksumEnabled = false;
        this.s3WriteTags = Sets.newHashSet();
        this.s3DeleteTags = Sets.newHashSet();
        this.s3FileIoDeleteThreads = Runtime.getRuntime().availableProcessors();
        this.isS3DeleteEnabled = true;
        this.s3BucketToAccessPointMapping = ImmutableMap.of();
        this.glueCatalogId = null;
        this.glueCatalogSkipArchive = false;
        this.glueCatalogSkipNameValidation = false;
        this.glueLakeFormationEnabled = false;
        this.dynamoDbTableName = DYNAMODB_TABLE_NAME_DEFAULT;
    }

    public AwsProperties(Map<String, String> properties) {
        this.s3FileIoSseType = properties.getOrDefault(S3FILEIO_SSE_TYPE, S3FILEIO_SSE_TYPE_NONE);
        this.s3FileIoSseKey = properties.get(S3FILEIO_SSE_KEY);
        this.s3FileIoSseMd5 = properties.get(S3FILEIO_SSE_MD5);
        if (S3FILEIO_SSE_TYPE_CUSTOM.equals(this.s3FileIoSseType)) {
            Preconditions.checkNotNull((Object)this.s3FileIoSseKey, (Object)"Cannot initialize SSE-C S3FileIO with null encryption key");
            Preconditions.checkNotNull((Object)this.s3FileIoSseMd5, (Object)"Cannot initialize SSE-C S3FileIO with null encryption key MD5");
        }
        this.glueCatalogId = properties.get(GLUE_CATALOG_ID);
        this.glueCatalogSkipArchive = PropertyUtil.propertyAsBoolean(properties, (String)GLUE_CATALOG_SKIP_ARCHIVE, (boolean)false);
        this.glueCatalogSkipNameValidation = PropertyUtil.propertyAsBoolean(properties, (String)GLUE_CATALOG_SKIP_NAME_VALIDATION, (boolean)false);
        this.glueLakeFormationEnabled = PropertyUtil.propertyAsBoolean(properties, (String)GLUE_LAKEFORMATION_ENABLED, (boolean)false);
        this.s3FileIoMultipartUploadThreads = PropertyUtil.propertyAsInt(properties, (String)S3FILEIO_MULTIPART_UPLOAD_THREADS, (int)Runtime.getRuntime().availableProcessors());
        try {
            this.s3FileIoMultiPartSize = PropertyUtil.propertyAsInt(properties, (String)S3FILEIO_MULTIPART_SIZE, (int)0x2000000);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Input malformed or exceeded maximum multipart upload size 5GB: %s" + properties.get(S3FILEIO_MULTIPART_SIZE));
        }
        this.s3FileIoMultipartThresholdFactor = PropertyUtil.propertyAsDouble(properties, (String)S3FILEIO_MULTIPART_THRESHOLD_FACTOR, (double)1.5);
        Preconditions.checkArgument((this.s3FileIoMultipartThresholdFactor >= 1.0 ? 1 : 0) != 0, (Object)"Multipart threshold factor must be >= to 1.0");
        Preconditions.checkArgument((this.s3FileIoMultiPartSize >= 0x500000 ? 1 : 0) != 0, (Object)"Minimum multipart upload object size must be larger than 5 MB.");
        this.s3fileIoStagingDirectory = PropertyUtil.propertyAsString(properties, (String)S3FILEIO_STAGING_DIRECTORY, (String)System.getProperty("java.io.tmpdir"));
        String aclType = properties.get(S3FILEIO_ACL);
        this.s3FileIoAcl = ObjectCannedACL.fromValue((String)aclType);
        Preconditions.checkArgument((this.s3FileIoAcl == null || !this.s3FileIoAcl.equals((Object)ObjectCannedACL.UNKNOWN_TO_SDK_VERSION) ? 1 : 0) != 0, (Object)("Cannot support S3 CannedACL " + aclType));
        this.isS3ChecksumEnabled = PropertyUtil.propertyAsBoolean(properties, (String)S3_CHECKSUM_ENABLED, (boolean)false);
        this.s3FileIoDeleteBatchSize = PropertyUtil.propertyAsInt(properties, (String)S3FILEIO_DELETE_BATCH_SIZE, (int)250);
        Preconditions.checkArgument((this.s3FileIoDeleteBatchSize > 0 && this.s3FileIoDeleteBatchSize <= 1000 ? 1 : 0) != 0, (Object)String.format("Deletion batch size must be between 1 and %s", 1000));
        this.s3WriteTags = this.toTags(properties, S3_WRITE_TAGS_PREFIX);
        this.s3DeleteTags = this.toTags(properties, S3_DELETE_TAGS_PREFIX);
        this.s3FileIoDeleteThreads = PropertyUtil.propertyAsInt(properties, (String)S3FILEIO_DELETE_THREADS, (int)Runtime.getRuntime().availableProcessors());
        this.isS3DeleteEnabled = PropertyUtil.propertyAsBoolean(properties, (String)S3_DELETE_ENABLED, (boolean)true);
        this.s3BucketToAccessPointMapping = PropertyUtil.propertiesWithPrefix(properties, (String)S3_ACCESS_POINTS_PREFIX);
        this.dynamoDbTableName = PropertyUtil.propertyAsString(properties, (String)DYNAMODB_TABLE_NAME, (String)DYNAMODB_TABLE_NAME_DEFAULT);
    }

    public String s3FileIoSseType() {
        return this.s3FileIoSseType;
    }

    public void setS3FileIoSseType(String sseType) {
        this.s3FileIoSseType = sseType;
    }

    public String s3FileIoSseKey() {
        return this.s3FileIoSseKey;
    }

    public int s3FileIoDeleteBatchSize() {
        return this.s3FileIoDeleteBatchSize;
    }

    public void setS3FileIoDeleteBatchSize(int deleteBatchSize) {
        this.s3FileIoDeleteBatchSize = deleteBatchSize;
    }

    public void setS3FileIoSseKey(String sseKey) {
        this.s3FileIoSseKey = sseKey;
    }

    public String s3FileIoSseMd5() {
        return this.s3FileIoSseMd5;
    }

    public void setS3FileIoSseMd5(String sseMd5) {
        this.s3FileIoSseMd5 = sseMd5;
    }

    public String glueCatalogId() {
        return this.glueCatalogId;
    }

    public void setGlueCatalogId(String id) {
        this.glueCatalogId = id;
    }

    public boolean glueCatalogSkipArchive() {
        return this.glueCatalogSkipArchive;
    }

    public void setGlueCatalogSkipArchive(boolean skipArchive) {
        this.glueCatalogSkipArchive = skipArchive;
    }

    public boolean glueCatalogSkipNameValidation() {
        return this.glueCatalogSkipNameValidation;
    }

    public void setGlueCatalogSkipNameValidation(boolean glueCatalogSkipNameValidation) {
        this.glueCatalogSkipNameValidation = glueCatalogSkipNameValidation;
    }

    public boolean glueLakeFormationEnabled() {
        return this.glueLakeFormationEnabled;
    }

    public void setGlueLakeFormationEnabled(boolean glueLakeFormationEnabled) {
        this.glueLakeFormationEnabled = glueLakeFormationEnabled;
    }

    public int s3FileIoMultipartUploadThreads() {
        return this.s3FileIoMultipartUploadThreads;
    }

    public void setS3FileIoMultipartUploadThreads(int threads) {
        this.s3FileIoMultipartUploadThreads = threads;
    }

    public int s3FileIoMultiPartSize() {
        return this.s3FileIoMultiPartSize;
    }

    public void setS3FileIoMultiPartSize(int size) {
        this.s3FileIoMultiPartSize = size;
    }

    public double s3FileIOMultipartThresholdFactor() {
        return this.s3FileIoMultipartThresholdFactor;
    }

    public void setS3FileIoMultipartThresholdFactor(double factor) {
        this.s3FileIoMultipartThresholdFactor = factor;
    }

    public String s3fileIoStagingDirectory() {
        return this.s3fileIoStagingDirectory;
    }

    public void setS3fileIoStagingDirectory(String directory) {
        this.s3fileIoStagingDirectory = directory;
    }

    public ObjectCannedACL s3FileIoAcl() {
        return this.s3FileIoAcl;
    }

    public void setS3FileIoAcl(ObjectCannedACL acl) {
        this.s3FileIoAcl = acl;
    }

    public String dynamoDbTableName() {
        return this.dynamoDbTableName;
    }

    public void setDynamoDbTableName(String name) {
        this.dynamoDbTableName = name;
    }

    public boolean isS3ChecksumEnabled() {
        return this.isS3ChecksumEnabled;
    }

    public void setS3ChecksumEnabled(boolean eTagCheckEnabled) {
        this.isS3ChecksumEnabled = eTagCheckEnabled;
    }

    public Set<Tag> s3WriteTags() {
        return this.s3WriteTags;
    }

    public Set<Tag> s3DeleteTags() {
        return this.s3DeleteTags;
    }

    public int s3FileIoDeleteThreads() {
        return this.s3FileIoDeleteThreads;
    }

    public void setS3FileIoDeleteThreads(int threads) {
        this.s3FileIoDeleteThreads = threads;
    }

    public boolean isS3DeleteEnabled() {
        return this.isS3DeleteEnabled;
    }

    public void setS3DeleteEnabled(boolean s3DeleteEnabled) {
        this.isS3DeleteEnabled = s3DeleteEnabled;
    }

    private Set<Tag> toTags(Map<String, String> properties, String prefix) {
        return PropertyUtil.propertiesWithPrefix(properties, (String)prefix).entrySet().stream().map(e -> (Tag)Tag.builder().key((String)e.getKey()).value((String)e.getValue()).build()).collect(Collectors.toSet());
    }

    public Map<String, String> s3BucketToAccessPointMapping() {
        return this.s3BucketToAccessPointMapping;
    }
}

