/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.aws;

import java.net.URI;
import java.util.Map;
import org.apache.iceberg.aws.AwsClientFactory;
import org.apache.iceberg.common.DynConstructors;
import org.apache.iceberg.exceptions.ValidationException;
import org.apache.iceberg.util.PropertyUtil;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.AwsSessionCredentials;
import software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.core.client.builder.SdkClientBuilder;
import software.amazon.awssdk.http.SdkHttpClient;
import software.amazon.awssdk.http.urlconnection.UrlConnectionHttpClient;
import software.amazon.awssdk.services.dynamodb.DynamoDbClient;
import software.amazon.awssdk.services.dynamodb.DynamoDbClientBuilder;
import software.amazon.awssdk.services.glue.GlueClient;
import software.amazon.awssdk.services.glue.GlueClientBuilder;
import software.amazon.awssdk.services.kms.KmsClient;
import software.amazon.awssdk.services.kms.KmsClientBuilder;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.S3ClientBuilder;

public class AwsClientFactories {
    private static final SdkHttpClient HTTP_CLIENT_DEFAULT = UrlConnectionHttpClient.create();
    private static final DefaultAwsClientFactory AWS_CLIENT_FACTORY_DEFAULT = new DefaultAwsClientFactory();

    private AwsClientFactories() {
    }

    public static AwsClientFactory defaultFactory() {
        return AWS_CLIENT_FACTORY_DEFAULT;
    }

    public static AwsClientFactory from(Map<String, String> properties) {
        String factoryImpl = PropertyUtil.propertyAsString(properties, (String)"client.factory", (String)DefaultAwsClientFactory.class.getName());
        return AwsClientFactories.loadClientFactory(factoryImpl, properties);
    }

    private static AwsClientFactory loadClientFactory(String impl, Map<String, String> properties) {
        AwsClientFactory factory;
        DynConstructors.Ctor ctor;
        try {
            ctor = DynConstructors.builder(AwsClientFactory.class).hiddenImpl(impl, new Class[0]).buildChecked();
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException(String.format("Cannot initialize AwsClientFactory, missing no-arg constructor: %s", impl), e);
        }
        try {
            factory = (AwsClientFactory)ctor.newInstance(new Object[0]);
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException(String.format("Cannot initialize AwsClientFactory, %s does not implement AwsClientFactory.", impl), e);
        }
        factory.initialize(properties);
        return factory;
    }

    static <T extends SdkClientBuilder> void configureEndpoint(T builder, String endpoint) {
        if (endpoint != null) {
            builder.endpointOverride(URI.create(endpoint));
        }
    }

    static AwsCredentialsProvider credentialsProvider(String accessKeyId, String secretAccessKey, String sessionToken) {
        if (accessKeyId != null) {
            if (sessionToken == null) {
                return StaticCredentialsProvider.create((AwsCredentials)AwsBasicCredentials.create((String)accessKeyId, (String)secretAccessKey));
            }
            return StaticCredentialsProvider.create((AwsCredentials)AwsSessionCredentials.create((String)accessKeyId, (String)secretAccessKey, (String)sessionToken));
        }
        return DefaultCredentialsProvider.create();
    }

    static class DefaultAwsClientFactory
    implements AwsClientFactory {
        private String s3Endpoint;
        private String s3AccessKeyId;
        private String s3SecretAccessKey;
        private String s3SessionToken;

        DefaultAwsClientFactory() {
        }

        @Override
        public S3Client s3() {
            return (S3Client)((S3ClientBuilder)((S3ClientBuilder)((S3ClientBuilder)S3Client.builder().httpClient(HTTP_CLIENT_DEFAULT)).applyMutation(builder -> AwsClientFactories.configureEndpoint(builder, this.s3Endpoint))).credentialsProvider(AwsClientFactories.credentialsProvider(this.s3AccessKeyId, this.s3SecretAccessKey, this.s3SessionToken))).build();
        }

        @Override
        public GlueClient glue() {
            return (GlueClient)((GlueClientBuilder)GlueClient.builder().httpClient(HTTP_CLIENT_DEFAULT)).build();
        }

        @Override
        public KmsClient kms() {
            return (KmsClient)((KmsClientBuilder)KmsClient.builder().httpClient(HTTP_CLIENT_DEFAULT)).build();
        }

        @Override
        public DynamoDbClient dynamo() {
            return (DynamoDbClient)((DynamoDbClientBuilder)DynamoDbClient.builder().httpClient(HTTP_CLIENT_DEFAULT)).build();
        }

        @Override
        public void initialize(Map<String, String> properties) {
            this.s3Endpoint = properties.get("s3.endpoint");
            this.s3AccessKeyId = properties.get("s3.access-key-id");
            this.s3SecretAccessKey = properties.get("s3.secret-access-key");
            this.s3SessionToken = properties.get("s3.session-token");
            ValidationException.check((this.s3AccessKeyId == null && this.s3SecretAccessKey == null || this.s3AccessKeyId != null && this.s3SecretAccessKey != null ? 1 : 0) != 0, (String)"S3 client access key ID and secret access key must be set at the same time", (Object[])new Object[0]);
        }
    }
}

