/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.util.List;
import org.apache.iceberg.ContentFile;
import org.apache.iceberg.ContentScanTask;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.DeleteFile;
import org.apache.iceberg.SplittableScanTask;

public interface FileScanTask
extends ContentScanTask<DataFile>,
SplittableScanTask<FileScanTask> {
    public List<DeleteFile> deletes();

    @Override
    default public long sizeBytes() {
        return this.length() + this.deletes().stream().mapToLong(ContentFile::fileSizeInBytes).sum();
    }

    @Override
    default public int filesCount() {
        return 1 + this.deletes().size();
    }

    @Override
    default public boolean isFileScanTask() {
        return true;
    }

    @Override
    default public FileScanTask asFileScanTask() {
        return this;
    }
}

