/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.io;

import java.io.Closeable;
import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;

public interface CloseableIterator<T>
extends Iterator<T>,
Closeable {
    public static <E> CloseableIterator<E> empty() {
        return CloseableIterator.withClose(Collections.emptyIterator());
    }

    public static <E> CloseableIterator<E> withClose(final Iterator<E> iterator) {
        if (iterator instanceof CloseableIterator) {
            return (CloseableIterator)iterator;
        }
        return new CloseableIterator<E>(){

            @Override
            public void close() throws IOException {
                if (iterator instanceof Closeable) {
                    ((Closeable)((Object)iterator)).close();
                }
            }

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public E next() {
                return iterator.next();
            }
        };
    }
}

