/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.io;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.io.Closeable;
import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.iceberg.exceptions.RuntimeIOException;
import org.apache.iceberg.io.CloseableGroup;

public interface CloseableIterable<T>
extends Iterable<T>,
Closeable {
    public static <E> CloseableIterable<E> withNoopClose(E entry) {
        return CloseableIterable.withNoopClose(ImmutableList.of(entry));
    }

    public static <E> CloseableIterable<E> withNoopClose(final Iterable<E> iterable) {
        return new CloseableIterable<E>(){

            @Override
            public void close() {
            }

            @Override
            public Iterator<E> iterator() {
                return iterable.iterator();
            }
        };
    }

    public static <E> CloseableIterable<E> empty() {
        return CloseableIterable.withNoopClose(Collections.emptyList());
    }

    public static <E> CloseableIterable<E> combine(final Iterable<E> iterable, final Closeable closeable) {
        return new CloseableIterable<E>(){

            @Override
            public void close() throws IOException {
                closeable.close();
            }

            @Override
            public Iterator<E> iterator() {
                return iterable.iterator();
            }
        };
    }

    public static <E> CloseableIterable<E> filter(CloseableIterable<E> iterable, Predicate<E> pred) {
        return CloseableIterable.combine(Iterables.filter(iterable, pred::test), iterable);
    }

    public static <I, O> CloseableIterable<O> transform(final CloseableIterable<I> iterable, final Function<I, O> transform) {
        Preconditions.checkNotNull(transform, (Object)"Cannot apply a null transform");
        return new CloseableIterable<O>(){

            @Override
            public void close() throws IOException {
                iterable.close();
            }

            @Override
            public Iterator<O> iterator() {
                return new Iterator<O>(){
                    private final Iterator<I> inner;
                    {
                        this.inner = iterable.iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.inner.hasNext();
                    }

                    @Override
                    public O next() {
                        return transform.apply(this.inner.next());
                    }
                };
            }
        };
    }

    public static <E> CloseableIterable<E> concat(Iterable<CloseableIterable<E>> iterable) {
        Iterator<CloseableIterable<E>> iterables = iterable.iterator();
        if (!iterables.hasNext()) {
            return CloseableIterable.empty();
        }
        return new ConcatCloseableIterable<E>(iterable);
    }

    public static class ConcatCloseableIterable<E>
    extends CloseableGroup
    implements CloseableIterable<E> {
        private final Iterable<CloseableIterable<E>> inputs;

        ConcatCloseableIterable(Iterable<CloseableIterable<E>> inputs) {
            this.inputs = inputs;
        }

        @Override
        public Iterator<E> iterator() {
            ConcatCloseableIterator iter = new ConcatCloseableIterator(this.inputs);
            this.addCloseable(iter);
            return iter;
        }

        private static class ConcatCloseableIterator<E>
        implements Iterator<E>,
        Closeable {
            private final Iterator<CloseableIterable<E>> iterables;
            private CloseableIterable<E> currentIterable = null;
            private Iterator<E> currentIterator = null;
            private boolean closed = false;

            private ConcatCloseableIterator(Iterable<CloseableIterable<E>> inputs) {
                this.iterables = inputs.iterator();
                this.currentIterable = this.iterables.next();
                this.currentIterator = this.currentIterable.iterator();
            }

            @Override
            public boolean hasNext() {
                if (this.closed) {
                    return false;
                }
                if (this.currentIterator.hasNext()) {
                    return true;
                }
                while (this.iterables.hasNext()) {
                    try {
                        this.currentIterable.close();
                    }
                    catch (IOException e) {
                        throw new RuntimeIOException(e, "Failed to close iterable", new Object[0]);
                    }
                    this.currentIterable = this.iterables.next();
                    this.currentIterator = this.currentIterable.iterator();
                    if (!this.currentIterator.hasNext()) continue;
                    return true;
                }
                try {
                    this.currentIterable.close();
                }
                catch (IOException e) {
                    throw new RuntimeIOException(e, "Failed to close iterable", new Object[0]);
                }
                this.closed = true;
                this.currentIterator = null;
                this.currentIterable = null;
                return false;
            }

            @Override
            public void close() throws IOException {
                if (!this.closed) {
                    this.currentIterable.close();
                    this.closed = true;
                    this.currentIterator = null;
                    this.currentIterable = null;
                }
            }

            @Override
            public E next() {
                if (this.hasNext()) {
                    return this.currentIterator.next();
                }
                throw new NoSuchElementException();
            }
        }
    }
}

