/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.expressions;

import java.io.Serializable;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import org.apache.iceberg.PartitionField;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.expressions.BoundPredicate;
import org.apache.iceberg.expressions.BoundReference;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.ExpressionVisitors;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.expressions.Literal;
import org.apache.iceberg.expressions.Predicate;
import org.apache.iceberg.expressions.UnboundPredicate;

public class ResidualEvaluator
implements Serializable {
    private final PartitionSpec spec;
    private final Expression expr;
    private final boolean caseSensitive;
    private transient ThreadLocal<ResidualVisitor> visitors = null;

    public static ResidualEvaluator unpartitioned(Expression expr) {
        return new UnpartitionedResidualEvaluator(expr);
    }

    public static ResidualEvaluator of(PartitionSpec spec, Expression expr, boolean caseSensitive) {
        if (spec.fields().size() > 0) {
            return new ResidualEvaluator(spec, expr, caseSensitive);
        }
        return ResidualEvaluator.unpartitioned(expr);
    }

    private ResidualVisitor visitor() {
        if (this.visitors == null) {
            this.visitors = ThreadLocal.withInitial(() -> new ResidualVisitor());
        }
        return this.visitors.get();
    }

    private ResidualEvaluator(PartitionSpec spec, Expression expr, boolean caseSensitive) {
        this.spec = spec;
        this.expr = expr;
        this.caseSensitive = caseSensitive;
    }

    public Expression residualFor(StructLike partitionData) {
        return this.visitor().eval(partitionData);
    }

    private class ResidualVisitor
    extends ExpressionVisitors.BoundExpressionVisitor<Expression> {
        private StructLike struct;

        private ResidualVisitor() {
        }

        private Expression eval(StructLike dataStruct) {
            this.struct = dataStruct;
            return ExpressionVisitors.visit(ResidualEvaluator.this.expr, this);
        }

        @Override
        public Expression alwaysTrue() {
            return Expressions.alwaysTrue();
        }

        @Override
        public Expression alwaysFalse() {
            return Expressions.alwaysFalse();
        }

        @Override
        public Expression not(Expression result) {
            return Expressions.not(result);
        }

        @Override
        public Expression and(Expression leftResult, Expression rightResult) {
            return Expressions.and(leftResult, rightResult);
        }

        @Override
        public Expression or(Expression leftResult, Expression rightResult) {
            return Expressions.or(leftResult, rightResult);
        }

        @Override
        public <T> Expression isNull(BoundReference<T> ref) {
            return ref.eval(this.struct) == null ? this.alwaysTrue() : this.alwaysFalse();
        }

        @Override
        public <T> Expression notNull(BoundReference<T> ref) {
            return ref.eval(this.struct) != null ? this.alwaysTrue() : this.alwaysFalse();
        }

        @Override
        public <T> Expression lt(BoundReference<T> ref, Literal<T> lit) {
            Comparator<T> cmp = lit.comparator();
            return cmp.compare(ref.eval(this.struct), lit.value()) < 0 ? this.alwaysTrue() : this.alwaysFalse();
        }

        @Override
        public <T> Expression ltEq(BoundReference<T> ref, Literal<T> lit) {
            Comparator<T> cmp = lit.comparator();
            return cmp.compare(ref.eval(this.struct), lit.value()) <= 0 ? this.alwaysTrue() : this.alwaysFalse();
        }

        @Override
        public <T> Expression gt(BoundReference<T> ref, Literal<T> lit) {
            Comparator<T> cmp = lit.comparator();
            return cmp.compare(ref.eval(this.struct), lit.value()) > 0 ? this.alwaysTrue() : this.alwaysFalse();
        }

        @Override
        public <T> Expression gtEq(BoundReference<T> ref, Literal<T> lit) {
            Comparator<T> cmp = lit.comparator();
            return cmp.compare(ref.eval(this.struct), lit.value()) >= 0 ? this.alwaysTrue() : this.alwaysFalse();
        }

        @Override
        public <T> Expression eq(BoundReference<T> ref, Literal<T> lit) {
            Comparator<T> cmp = lit.comparator();
            return cmp.compare(ref.eval(this.struct), lit.value()) == 0 ? this.alwaysTrue() : this.alwaysFalse();
        }

        @Override
        public <T> Expression notEq(BoundReference<T> ref, Literal<T> lit) {
            Comparator<T> cmp = lit.comparator();
            return cmp.compare(ref.eval(this.struct), lit.value()) != 0 ? this.alwaysTrue() : this.alwaysFalse();
        }

        @Override
        public <T> Expression in(BoundReference<T> ref, Set<T> literalSet) {
            return literalSet.contains(ref.eval(this.struct)) ? this.alwaysTrue() : this.alwaysFalse();
        }

        @Override
        public <T> Expression notIn(BoundReference<T> ref, Set<T> literalSet) {
            return literalSet.contains(ref.eval(this.struct)) ? this.alwaysFalse() : this.alwaysTrue();
        }

        @Override
        public <T> Expression startsWith(BoundReference<T> ref, Literal<T> lit) {
            return ((String)ref.eval(this.struct)).startsWith((String)lit.value()) ? this.alwaysTrue() : this.alwaysFalse();
        }

        @Override
        public <T> Expression predicate(BoundPredicate<T> pred) {
            List<PartitionField> parts = ResidualEvaluator.this.spec.getFieldsBySourceId(pred.ref().fieldId());
            if (parts == null) {
                return pred;
            }
            for (PartitionField part : parts) {
                UnboundPredicate<?> strictProjection = part.transform().projectStrict(part.name(), pred);
                Expression strictResult = null;
                if (strictProjection != null) {
                    Expression bound = strictProjection.bind(ResidualEvaluator.this.spec.partitionType(), ResidualEvaluator.this.caseSensitive);
                    strictResult = bound instanceof BoundPredicate ? (Expression)super.predicate((BoundPredicate)bound) : bound;
                }
                if (strictResult != null && strictResult.op() == Expression.Operation.TRUE) {
                    return Expressions.alwaysTrue();
                }
                UnboundPredicate<?> inclusiveProjection = part.transform().project(part.name(), pred);
                Expression inclusiveResult = null;
                if (inclusiveProjection != null) {
                    Expression boundInclusive = inclusiveProjection.bind(ResidualEvaluator.this.spec.partitionType(), ResidualEvaluator.this.caseSensitive);
                    inclusiveResult = boundInclusive instanceof BoundPredicate ? (Expression)super.predicate((BoundPredicate)boundInclusive) : boundInclusive;
                }
                if (inclusiveResult == null || inclusiveResult.op() != Expression.Operation.FALSE) continue;
                return Expressions.alwaysFalse();
            }
            return pred;
        }

        @Override
        public <T> Expression predicate(UnboundPredicate<T> pred) {
            Expression bound = pred.bind(ResidualEvaluator.this.spec.schema().asStruct(), ResidualEvaluator.this.caseSensitive);
            if (bound instanceof BoundPredicate) {
                Object boundResidual = this.predicate((BoundPredicate)bound);
                if (boundResidual instanceof Predicate) {
                    return pred;
                }
                return boundResidual;
            }
            return bound;
        }
    }

    private static class UnpartitionedResidualEvaluator
    extends ResidualEvaluator {
        private final Expression expr;

        UnpartitionedResidualEvaluator(Expression expr) {
            super(PartitionSpec.unpartitioned(), expr, false);
            this.expr = expr;
        }

        @Override
        public Expression residualFor(StructLike ignored) {
            return this.expr;
        }
    }
}

