/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.expressions;

import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.Schema;
import org.apache.iceberg.expressions.Binder;
import org.apache.iceberg.expressions.BoundReference;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.ExpressionVisitors;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.expressions.Literal;
import org.apache.iceberg.types.Comparators;
import org.apache.iceberg.types.Conversions;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.BinaryUtil;

public class InclusiveMetricsEvaluator {
    private final Expression expr;
    private transient ThreadLocal<MetricsEvalVisitor> visitors = null;
    private static final boolean ROWS_MIGHT_MATCH = true;
    private static final boolean ROWS_CANNOT_MATCH = false;

    private MetricsEvalVisitor visitor() {
        if (this.visitors == null) {
            this.visitors = ThreadLocal.withInitial(() -> new MetricsEvalVisitor());
        }
        return this.visitors.get();
    }

    public InclusiveMetricsEvaluator(Schema schema, Expression unbound) {
        this(schema, unbound, true);
    }

    public InclusiveMetricsEvaluator(Schema schema, Expression unbound, boolean caseSensitive) {
        Types.StructType struct = schema.asStruct();
        this.expr = Binder.bind(struct, Expressions.rewriteNot(unbound), caseSensitive);
    }

    public boolean eval(DataFile file) {
        return this.visitor().eval(file);
    }

    private class MetricsEvalVisitor
    extends ExpressionVisitors.BoundExpressionVisitor<Boolean> {
        private Map<Integer, Long> valueCounts = null;
        private Map<Integer, Long> nullCounts = null;
        private Map<Integer, ByteBuffer> lowerBounds = null;
        private Map<Integer, ByteBuffer> upperBounds = null;

        private MetricsEvalVisitor() {
        }

        private boolean eval(DataFile file) {
            if (file.recordCount() == 0L) {
                return false;
            }
            if (file.recordCount() < 0L) {
                return true;
            }
            this.valueCounts = file.valueCounts();
            this.nullCounts = file.nullValueCounts();
            this.lowerBounds = file.lowerBounds();
            this.upperBounds = file.upperBounds();
            return ExpressionVisitors.visitEvaluator(InclusiveMetricsEvaluator.this.expr, this);
        }

        @Override
        public Boolean alwaysTrue() {
            return true;
        }

        @Override
        public Boolean alwaysFalse() {
            return false;
        }

        @Override
        public Boolean not(Boolean result) {
            return result == false;
        }

        @Override
        public Boolean and(Boolean leftResult, Boolean rightResult) {
            return leftResult != false && rightResult != false;
        }

        @Override
        public Boolean or(Boolean leftResult, Boolean rightResult) {
            return leftResult != false || rightResult != false;
        }

        @Override
        public <T> Boolean isNull(BoundReference<T> ref) {
            Integer id = ref.fieldId();
            if (this.nullCounts != null && this.nullCounts.containsKey(id) && this.nullCounts.get(id) == 0L) {
                return false;
            }
            return true;
        }

        @Override
        public <T> Boolean notNull(BoundReference<T> ref) {
            Integer id = ref.fieldId();
            if (this.containsNullsOnly(id)) {
                return false;
            }
            return true;
        }

        @Override
        public <T> Boolean lt(BoundReference<T> ref, Literal<T> lit) {
            Integer id = ref.fieldId();
            if (this.containsNullsOnly(id)) {
                return false;
            }
            if (this.lowerBounds != null && this.lowerBounds.containsKey(id)) {
                Object lower = Conversions.fromByteBuffer(ref.type(), this.lowerBounds.get(id));
                int cmp = lit.comparator().compare(lower, lit.value());
                if (cmp >= 0) {
                    return false;
                }
            }
            return true;
        }

        @Override
        public <T> Boolean ltEq(BoundReference<T> ref, Literal<T> lit) {
            Integer id = ref.fieldId();
            if (this.containsNullsOnly(id)) {
                return false;
            }
            if (this.lowerBounds != null && this.lowerBounds.containsKey(id)) {
                Object lower = Conversions.fromByteBuffer(ref.type(), this.lowerBounds.get(id));
                int cmp = lit.comparator().compare(lower, lit.value());
                if (cmp > 0) {
                    return false;
                }
            }
            return true;
        }

        @Override
        public <T> Boolean gt(BoundReference<T> ref, Literal<T> lit) {
            Integer id = ref.fieldId();
            if (this.containsNullsOnly(id)) {
                return false;
            }
            if (this.upperBounds != null && this.upperBounds.containsKey(id)) {
                Object upper = Conversions.fromByteBuffer(ref.type(), this.upperBounds.get(id));
                int cmp = lit.comparator().compare(upper, lit.value());
                if (cmp <= 0) {
                    return false;
                }
            }
            return true;
        }

        @Override
        public <T> Boolean gtEq(BoundReference<T> ref, Literal<T> lit) {
            Integer id = ref.fieldId();
            if (this.containsNullsOnly(id)) {
                return false;
            }
            if (this.upperBounds != null && this.upperBounds.containsKey(id)) {
                Object upper = Conversions.fromByteBuffer(ref.type(), this.upperBounds.get(id));
                int cmp = lit.comparator().compare(upper, lit.value());
                if (cmp < 0) {
                    return false;
                }
            }
            return true;
        }

        @Override
        public <T> Boolean eq(BoundReference<T> ref, Literal<T> lit) {
            int cmp;
            Integer id = ref.fieldId();
            if (this.containsNullsOnly(id)) {
                return false;
            }
            if (this.lowerBounds != null && this.lowerBounds.containsKey(id)) {
                Object lower = Conversions.fromByteBuffer(ref.type(), this.lowerBounds.get(id));
                cmp = lit.comparator().compare(lower, lit.value());
                if (cmp > 0) {
                    return false;
                }
            }
            if (this.upperBounds != null && this.upperBounds.containsKey(id)) {
                Object upper = Conversions.fromByteBuffer(ref.type(), this.upperBounds.get(id));
                cmp = lit.comparator().compare(upper, lit.value());
                if (cmp < 0) {
                    return false;
                }
            }
            return true;
        }

        @Override
        public <T> Boolean notEq(BoundReference<T> ref, Literal<T> lit) {
            return true;
        }

        @Override
        public <T> Boolean in(BoundReference<T> ref, Set<T> literalSet) {
            Integer id = ref.fieldId();
            if (this.containsNullsOnly(id)) {
                return false;
            }
            Collection<Object> literals = literalSet;
            if (this.lowerBounds != null && this.lowerBounds.containsKey(id)) {
                Object lower = Conversions.fromByteBuffer(ref.type(), this.lowerBounds.get(id));
                if ((literals = (Collection)literals.stream().filter(v -> ref.comparator().compare(lower, v) <= 0).collect(Collectors.toList())).isEmpty()) {
                    return false;
                }
            }
            if (this.upperBounds != null && this.upperBounds.containsKey(id)) {
                Object upper = Conversions.fromByteBuffer(ref.type(), this.upperBounds.get(id));
                if ((literals = (Collection)literals.stream().filter(v -> ref.comparator().compare(upper, v) >= 0).collect(Collectors.toList())).isEmpty()) {
                    return false;
                }
            }
            return true;
        }

        @Override
        public <T> Boolean notIn(BoundReference<T> ref, Set<T> literalSet) {
            return true;
        }

        @Override
        public <T> Boolean startsWith(BoundReference<T> ref, Literal<T> lit) {
            ByteBuffer upper;
            int length;
            ByteBuffer lower;
            int cmp;
            Integer id = ref.fieldId();
            if (this.containsNullsOnly(id)) {
                return false;
            }
            ByteBuffer prefixAsBytes = lit.toByteBuffer();
            Comparator<ByteBuffer> comparator = Comparators.unsignedBytes();
            if (this.lowerBounds != null && this.lowerBounds.containsKey(id) && (cmp = comparator.compare(BinaryUtil.truncateBinary(lower = this.lowerBounds.get(id), length = Math.min(prefixAsBytes.remaining(), lower.remaining())), prefixAsBytes)) > 0) {
                return false;
            }
            if (this.upperBounds != null && this.upperBounds.containsKey(id) && (cmp = comparator.compare(BinaryUtil.truncateBinary(upper = this.upperBounds.get(id), length = Math.min(prefixAsBytes.remaining(), upper.remaining())), prefixAsBytes)) < 0) {
                return false;
            }
            return true;
        }

        private boolean containsNullsOnly(Integer id) {
            return this.valueCounts != null && this.valueCounts.containsKey(id) && this.nullCounts != null && this.nullCounts.containsKey(id) && this.valueCounts.get(id) - this.nullCounts.get(id) == 0L;
        }
    }
}

