/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.transforms;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.apache.iceberg.expressions.BoundPredicate;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.expressions.UnboundPredicate;
import org.apache.iceberg.transforms.Transform;

class ProjectionUtil {
    private ProjectionUtil() {
    }

    static <T> UnboundPredicate<T> truncateInteger(String name, BoundPredicate<Integer> pred, Transform<Integer, T> transform) {
        int boundary = (Integer)pred.literal().value();
        switch (pred.op()) {
            case LT: {
                return Expressions.predicate(Expression.Operation.LT_EQ, name, transform.apply(boundary - 1));
            }
            case LT_EQ: {
                return Expressions.predicate(Expression.Operation.LT_EQ, name, transform.apply(boundary));
            }
            case GT: {
                return Expressions.predicate(Expression.Operation.GT_EQ, name, transform.apply(boundary + 1));
            }
            case GT_EQ: {
                return Expressions.predicate(Expression.Operation.GT_EQ, name, transform.apply(boundary));
            }
            case EQ: {
                return Expressions.predicate(pred.op(), name, transform.apply(boundary));
            }
        }
        return null;
    }

    static <T> UnboundPredicate<T> truncateIntegerStrict(String name, BoundPredicate<Integer> pred, Transform<Integer, T> transform) {
        int boundary = (Integer)pred.literal().value();
        switch (pred.op()) {
            case LT: {
                return Expressions.predicate(Expression.Operation.LT, name, transform.apply(boundary));
            }
            case LT_EQ: {
                return Expressions.predicate(Expression.Operation.LT, name, transform.apply(boundary + 1));
            }
            case GT: {
                return Expressions.predicate(Expression.Operation.GT, name, transform.apply(boundary));
            }
            case GT_EQ: {
                return Expressions.predicate(Expression.Operation.GT, name, transform.apply(boundary - 1));
            }
            case NOT_EQ: {
                return Expressions.predicate(Expression.Operation.NOT_EQ, name, transform.apply(boundary));
            }
            case EQ: {
                return null;
            }
        }
        return null;
    }

    static <T> UnboundPredicate<T> truncateLongStrict(String name, BoundPredicate<Long> pred, Transform<Long, T> transform) {
        long boundary = (Long)pred.literal().value();
        switch (pred.op()) {
            case LT: {
                return Expressions.predicate(Expression.Operation.LT, name, transform.apply(boundary));
            }
            case LT_EQ: {
                return Expressions.predicate(Expression.Operation.LT, name, transform.apply(boundary + 1L));
            }
            case GT: {
                return Expressions.predicate(Expression.Operation.GT, name, transform.apply(boundary));
            }
            case GT_EQ: {
                return Expressions.predicate(Expression.Operation.GT, name, transform.apply(boundary - 1L));
            }
            case NOT_EQ: {
                return Expressions.predicate(Expression.Operation.NOT_EQ, name, transform.apply(boundary));
            }
            case EQ: {
                return null;
            }
        }
        return null;
    }

    static <T> UnboundPredicate<T> truncateLong(String name, BoundPredicate<Long> pred, Transform<Long, T> transform) {
        long boundary = (Long)pred.literal().value();
        switch (pred.op()) {
            case LT: {
                return Expressions.predicate(Expression.Operation.LT_EQ, name, transform.apply(boundary - 1L));
            }
            case LT_EQ: {
                return Expressions.predicate(Expression.Operation.LT_EQ, name, transform.apply(boundary));
            }
            case GT: {
                return Expressions.predicate(Expression.Operation.GT_EQ, name, transform.apply(boundary + 1L));
            }
            case GT_EQ: {
                return Expressions.predicate(Expression.Operation.GT_EQ, name, transform.apply(boundary));
            }
            case EQ: {
                return Expressions.predicate(pred.op(), name, transform.apply(boundary));
            }
        }
        return null;
    }

    static <T> UnboundPredicate<T> truncateDecimal(String name, BoundPredicate<BigDecimal> pred, Transform<BigDecimal, T> transform) {
        BigDecimal boundary = (BigDecimal)pred.literal().value();
        switch (pred.op()) {
            case LT: {
                BigDecimal minusOne = new BigDecimal(boundary.unscaledValue().subtract(BigInteger.ONE), boundary.scale());
                return Expressions.predicate(Expression.Operation.LT_EQ, name, transform.apply(minusOne));
            }
            case LT_EQ: {
                return Expressions.predicate(Expression.Operation.LT_EQ, name, transform.apply(boundary));
            }
            case GT: {
                BigDecimal plusOne = new BigDecimal(boundary.unscaledValue().add(BigInteger.ONE), boundary.scale());
                return Expressions.predicate(Expression.Operation.GT_EQ, name, transform.apply(plusOne));
            }
            case GT_EQ: {
                return Expressions.predicate(Expression.Operation.GT_EQ, name, transform.apply(boundary));
            }
            case EQ: {
                return Expressions.predicate(pred.op(), name, transform.apply(boundary));
            }
        }
        return null;
    }

    static <T> UnboundPredicate<T> truncateDecimalStrict(String name, BoundPredicate<BigDecimal> pred, Transform<BigDecimal, T> transform) {
        BigDecimal boundary = (BigDecimal)pred.literal().value();
        BigDecimal minusOne = new BigDecimal(boundary.unscaledValue().subtract(BigInteger.ONE), boundary.scale());
        BigDecimal plusOne = new BigDecimal(boundary.unscaledValue().add(BigInteger.ONE), boundary.scale());
        switch (pred.op()) {
            case LT: {
                return Expressions.predicate(Expression.Operation.LT, name, transform.apply(boundary));
            }
            case LT_EQ: {
                return Expressions.predicate(Expression.Operation.LT, name, transform.apply(plusOne));
            }
            case GT: {
                return Expressions.predicate(Expression.Operation.GT, name, transform.apply(boundary));
            }
            case GT_EQ: {
                return Expressions.predicate(Expression.Operation.GT, name, transform.apply(minusOne));
            }
            case NOT_EQ: {
                return Expressions.predicate(Expression.Operation.NOT_EQ, name, transform.apply(boundary));
            }
            case EQ: {
                return null;
            }
        }
        return null;
    }

    static <S, T> UnboundPredicate<T> truncateArray(String name, BoundPredicate<S> pred, Transform<S, T> transform) {
        Object boundary = pred.literal().value();
        switch (pred.op()) {
            case LT: 
            case LT_EQ: {
                return Expressions.predicate(Expression.Operation.LT_EQ, name, transform.apply(boundary));
            }
            case GT: 
            case GT_EQ: {
                return Expressions.predicate(Expression.Operation.GT_EQ, name, transform.apply(boundary));
            }
            case EQ: {
                return Expressions.predicate(Expression.Operation.EQ, name, transform.apply(boundary));
            }
            case STARTS_WITH: {
                return Expressions.predicate(Expression.Operation.STARTS_WITH, name, transform.apply(boundary));
            }
        }
        return null;
    }

    static <S, T> UnboundPredicate<T> truncateArrayStrict(String name, BoundPredicate<S> pred, Transform<S, T> transform) {
        Object boundary = pred.literal().value();
        switch (pred.op()) {
            case LT: 
            case LT_EQ: {
                return Expressions.predicate(Expression.Operation.LT, name, transform.apply(boundary));
            }
            case GT: 
            case GT_EQ: {
                return Expressions.predicate(Expression.Operation.GT, name, transform.apply(boundary));
            }
            case NOT_EQ: {
                return Expressions.predicate(Expression.Operation.NOT_EQ, name, transform.apply(boundary));
            }
            case EQ: {
                return null;
            }
        }
        return null;
    }
}

