/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.transforms;

import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.temporal.ChronoUnit;
import org.apache.iceberg.expressions.BoundPredicate;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.expressions.UnboundPredicate;
import org.apache.iceberg.transforms.ProjectionUtil;
import org.apache.iceberg.transforms.Transform;
import org.apache.iceberg.transforms.TransformUtil;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;

enum Dates implements Transform<Integer, Integer>
{
    YEAR(ChronoUnit.YEARS, "year"),
    MONTH(ChronoUnit.MONTHS, "month"),
    DAY(ChronoUnit.DAYS, "day");

    private static final OffsetDateTime EPOCH;
    private final ChronoUnit granularity;
    private final String name;

    private Dates(ChronoUnit granularity, String name) {
        this.granularity = granularity;
        this.name = name;
    }

    @Override
    public Integer apply(Integer days) {
        if (days == null) {
            return null;
        }
        if (this.granularity == ChronoUnit.DAYS) {
            return days;
        }
        return (int)this.granularity.between(EPOCH, EPOCH.plusDays(days.intValue()));
    }

    @Override
    public boolean canTransform(Type type) {
        return type.typeId() == Type.TypeID.DATE;
    }

    @Override
    public Type getResultType(Type sourceType) {
        if (this.granularity == ChronoUnit.DAYS) {
            return Types.DateType.get();
        }
        return Types.IntegerType.get();
    }

    @Override
    public UnboundPredicate<Integer> project(String fieldName, BoundPredicate<Integer> pred) {
        if (pred.op() == Expression.Operation.NOT_NULL || pred.op() == Expression.Operation.IS_NULL) {
            return Expressions.predicate(pred.op(), fieldName);
        }
        return ProjectionUtil.truncateInteger(fieldName, pred, this);
    }

    @Override
    public UnboundPredicate<Integer> projectStrict(String fieldName, BoundPredicate<Integer> pred) {
        if (pred.op() == Expression.Operation.NOT_NULL || pred.op() == Expression.Operation.IS_NULL) {
            return Expressions.predicate(pred.op(), fieldName);
        }
        return ProjectionUtil.truncateIntegerStrict(fieldName, pred, this);
    }

    @Override
    public String toHumanString(Integer value) {
        if (value == null) {
            return "null";
        }
        switch (this.granularity) {
            case YEARS: {
                return TransformUtil.humanYear(value);
            }
            case MONTHS: {
                return TransformUtil.humanMonth(value);
            }
            case DAYS: {
                return TransformUtil.humanDay(value);
            }
        }
        throw new UnsupportedOperationException("Unsupported time unit: " + this.granularity);
    }

    public String toString() {
        return this.name;
    }

    static {
        EPOCH = Instant.ofEpochSecond(0L).atOffset(ZoneOffset.UTC);
    }
}

