/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.types;

import java.util.Deque;
import java.util.List;
import java.util.Map;
import org.apache.iceberg.Schema;
import org.apache.iceberg.exceptions.ValidationException;
import org.apache.iceberg.relocated.com.google.common.base.Joiner;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.TypeUtil;
import org.apache.iceberg.types.Types;

public class IndexByName
extends TypeUtil.SchemaVisitor<Map<String, Integer>> {
    private static final Joiner DOT = Joiner.on((String)".");
    private final Deque<String> fieldNames = Lists.newLinkedList();
    private final Deque<String> shortFieldNames = Lists.newLinkedList();
    private final Map<String, Integer> nameToId = Maps.newHashMap();
    private final Map<String, Integer> shortNameToId = Maps.newHashMap();

    public Map<String, Integer> byName() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.putAll(this.nameToId);
        this.shortNameToId.entrySet().stream().filter(entry -> !this.nameToId.containsKey(entry.getKey())).forEach(arg_0 -> ((ImmutableMap.Builder)builder).put(arg_0));
        return builder.build();
    }

    public Map<Integer, String> byId() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        this.nameToId.forEach((key, value) -> builder.put(value, key));
        return builder.build();
    }

    @Override
    public void beforeField(Types.NestedField field) {
        this.fieldNames.push(field.name());
        this.shortFieldNames.push(field.name());
    }

    @Override
    public void afterField(Types.NestedField field) {
        this.fieldNames.pop();
        this.shortFieldNames.pop();
    }

    @Override
    public void beforeListElement(Types.NestedField elementField) {
        this.fieldNames.push(elementField.name());
        if (!elementField.type().isStructType()) {
            this.shortFieldNames.push(elementField.name());
        }
    }

    @Override
    public void afterListElement(Types.NestedField elementField) {
        this.fieldNames.pop();
        if (!elementField.type().isStructType()) {
            this.shortFieldNames.pop();
        }
    }

    @Override
    public void beforeMapKey(Types.NestedField keyField) {
        this.beforeField(keyField);
    }

    @Override
    public void afterMapKey(Types.NestedField keyField) {
        this.afterField(keyField);
    }

    @Override
    public void beforeMapValue(Types.NestedField valueField) {
        this.fieldNames.push(valueField.name());
        if (!valueField.type().isStructType()) {
            this.shortFieldNames.push(valueField.name());
        }
    }

    @Override
    public void afterMapValue(Types.NestedField valueField) {
        this.fieldNames.pop();
        if (!valueField.type().isStructType()) {
            this.shortFieldNames.pop();
        }
    }

    @Override
    public Map<String, Integer> schema(Schema schema, Map<String, Integer> structResult) {
        return this.nameToId;
    }

    @Override
    public Map<String, Integer> struct(Types.StructType struct, List<Map<String, Integer>> fieldResults) {
        return this.nameToId;
    }

    @Override
    public Map<String, Integer> field(Types.NestedField field, Map<String, Integer> fieldResult) {
        this.addField(field.name(), field.fieldId());
        return this.nameToId;
    }

    @Override
    public Map<String, Integer> list(Types.ListType list, Map<String, Integer> elementResult) {
        this.addField("element", list.elementId());
        return this.nameToId;
    }

    @Override
    public Map<String, Integer> map(Types.MapType map, Map<String, Integer> keyResult, Map<String, Integer> valueResult) {
        this.addField("key", map.keyId());
        this.addField("value", map.valueId());
        return this.nameToId;
    }

    @Override
    public Map<String, Integer> primitive(Type.PrimitiveType primitive) {
        return this.nameToId;
    }

    private void addField(String name, int fieldId) {
        String shortName;
        Integer existingFieldId;
        String fullName = name;
        if (!this.fieldNames.isEmpty()) {
            fullName = DOT.join((Object)DOT.join(this.fieldNames.descendingIterator()), (Object)name, new Object[0]);
        }
        ValidationException.check((existingFieldId = this.nameToId.put(fullName, fieldId)) == null, "Invalid schema: multiple fields for name %s: %s and %s", fullName, existingFieldId, fieldId);
        if (!this.shortFieldNames.isEmpty() && !this.shortNameToId.containsKey(shortName = DOT.join((Object)DOT.join(this.shortFieldNames.descendingIterator()), (Object)name, new Object[0]))) {
            this.shortNameToId.put(shortName, fieldId);
        }
    }
}

