/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.expressions;

import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.iceberg.Accessors;
import org.apache.iceberg.ManifestFile;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.expressions.Binder;
import org.apache.iceberg.expressions.BoundReference;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.ExpressionVisitors;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.expressions.Literal;
import org.apache.iceberg.expressions.Projections;
import org.apache.iceberg.types.Comparators;
import org.apache.iceberg.types.Conversions;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.BinaryUtil;

public class ManifestEvaluator {
    private static final int IN_PREDICATE_LIMIT = 200;
    private final Types.StructType struct;
    private final Expression expr;
    private static final boolean ROWS_MIGHT_MATCH = true;
    private static final boolean ROWS_CANNOT_MATCH = false;

    public static ManifestEvaluator forRowFilter(Expression rowFilter, PartitionSpec spec, boolean caseSensitive) {
        return new ManifestEvaluator(spec, Projections.inclusive(spec, caseSensitive).project(rowFilter), caseSensitive);
    }

    public static ManifestEvaluator forPartitionFilter(Expression partitionFilter, PartitionSpec spec, boolean caseSensitive) {
        return new ManifestEvaluator(spec, partitionFilter, caseSensitive);
    }

    private ManifestEvaluator(PartitionSpec spec, Expression partitionFilter, boolean caseSensitive) {
        this.struct = spec.partitionType();
        this.expr = Binder.bind(this.struct, Expressions.rewriteNot(partitionFilter), caseSensitive);
    }

    public boolean eval(ManifestFile manifest) {
        return new ManifestEvalVisitor().eval(manifest);
    }

    private class ManifestEvalVisitor
    extends ExpressionVisitors.BoundExpressionVisitor<Boolean> {
        private List<ManifestFile.PartitionFieldSummary> stats = null;

        private ManifestEvalVisitor() {
        }

        private boolean eval(ManifestFile manifest) {
            this.stats = manifest.partitions();
            if (this.stats == null) {
                return true;
            }
            return ExpressionVisitors.visitEvaluator(ManifestEvaluator.this.expr, this);
        }

        @Override
        public Boolean alwaysTrue() {
            return true;
        }

        @Override
        public Boolean alwaysFalse() {
            return false;
        }

        @Override
        public Boolean not(Boolean result) {
            return result == false;
        }

        @Override
        public Boolean and(Boolean leftResult, Boolean rightResult) {
            return leftResult != false && rightResult != false;
        }

        @Override
        public Boolean or(Boolean leftResult, Boolean rightResult) {
            return leftResult != false || rightResult != false;
        }

        @Override
        public <T> Boolean isNull(BoundReference<T> ref) {
            int pos = Accessors.toPosition(ref.accessor());
            if (!this.stats.get(pos).containsNull()) {
                return false;
            }
            return true;
        }

        @Override
        public <T> Boolean notNull(BoundReference<T> ref) {
            int pos = Accessors.toPosition(ref.accessor());
            if (this.stats.get(pos).containsNull() && this.stats.get(pos).lowerBound() == null) {
                return false;
            }
            return true;
        }

        @Override
        public <T> Boolean isNaN(BoundReference<T> ref) {
            int pos = Accessors.toPosition(ref.accessor());
            if (this.stats.get(pos).containsNull() && this.stats.get(pos).lowerBound() == null) {
                return false;
            }
            return true;
        }

        @Override
        public <T> Boolean notNaN(BoundReference<T> ref) {
            return true;
        }

        @Override
        public <T> Boolean lt(BoundReference<T> ref, Literal<T> lit) {
            int pos = Accessors.toPosition(ref.accessor());
            ByteBuffer lowerBound = this.stats.get(pos).lowerBound();
            if (lowerBound == null) {
                return false;
            }
            Object lower = Conversions.fromByteBuffer(ref.type(), lowerBound);
            int cmp = lit.comparator().compare(lower, lit.value());
            if (cmp >= 0) {
                return false;
            }
            return true;
        }

        @Override
        public <T> Boolean ltEq(BoundReference<T> ref, Literal<T> lit) {
            int pos = Accessors.toPosition(ref.accessor());
            ByteBuffer lowerBound = this.stats.get(pos).lowerBound();
            if (lowerBound == null) {
                return false;
            }
            Object lower = Conversions.fromByteBuffer(ref.type(), lowerBound);
            int cmp = lit.comparator().compare(lower, lit.value());
            if (cmp > 0) {
                return false;
            }
            return true;
        }

        @Override
        public <T> Boolean gt(BoundReference<T> ref, Literal<T> lit) {
            int pos = Accessors.toPosition(ref.accessor());
            ByteBuffer upperBound = this.stats.get(pos).upperBound();
            if (upperBound == null) {
                return false;
            }
            Object upper = Conversions.fromByteBuffer(ref.type(), upperBound);
            int cmp = lit.comparator().compare(upper, lit.value());
            if (cmp <= 0) {
                return false;
            }
            return true;
        }

        @Override
        public <T> Boolean gtEq(BoundReference<T> ref, Literal<T> lit) {
            int pos = Accessors.toPosition(ref.accessor());
            ByteBuffer upperBound = this.stats.get(pos).upperBound();
            if (upperBound == null) {
                return false;
            }
            Object upper = Conversions.fromByteBuffer(ref.type(), upperBound);
            int cmp = lit.comparator().compare(upper, lit.value());
            if (cmp < 0) {
                return false;
            }
            return true;
        }

        @Override
        public <T> Boolean eq(BoundReference<T> ref, Literal<T> lit) {
            int pos = Accessors.toPosition(ref.accessor());
            ManifestFile.PartitionFieldSummary fieldStats = this.stats.get(pos);
            if (fieldStats.lowerBound() == null) {
                return false;
            }
            Object lower = Conversions.fromByteBuffer(ref.type(), fieldStats.lowerBound());
            int cmp = lit.comparator().compare(lower, lit.value());
            if (cmp > 0) {
                return false;
            }
            Object upper = Conversions.fromByteBuffer(ref.type(), fieldStats.upperBound());
            cmp = lit.comparator().compare(upper, lit.value());
            if (cmp < 0) {
                return false;
            }
            return true;
        }

        @Override
        public <T> Boolean notEq(BoundReference<T> ref, Literal<T> lit) {
            return true;
        }

        @Override
        public <T> Boolean in(BoundReference<T> ref, Set<T> literalSet) {
            int pos = Accessors.toPosition(ref.accessor());
            ManifestFile.PartitionFieldSummary fieldStats = this.stats.get(pos);
            if (fieldStats.lowerBound() == null) {
                return false;
            }
            Collection<Object> literals = literalSet;
            if (literals.size() > 200) {
                return true;
            }
            Object lower = Conversions.fromByteBuffer(ref.type(), fieldStats.lowerBound());
            if ((literals = (Collection)literals.stream().filter(v -> ref.comparator().compare(lower, v) <= 0).collect(Collectors.toList())).isEmpty()) {
                return false;
            }
            Object upper = Conversions.fromByteBuffer(ref.type(), fieldStats.upperBound());
            if ((literals = (Collection)literals.stream().filter(v -> ref.comparator().compare(upper, v) >= 0).collect(Collectors.toList())).isEmpty()) {
                return false;
            }
            return true;
        }

        @Override
        public <T> Boolean notIn(BoundReference<T> ref, Set<T> literalSet) {
            return true;
        }

        @Override
        public <T> Boolean startsWith(BoundReference<T> ref, Literal<T> lit) {
            int upperLength;
            int lowerLength;
            ByteBuffer lower;
            int pos = Accessors.toPosition(ref.accessor());
            ManifestFile.PartitionFieldSummary fieldStats = this.stats.get(pos);
            if (fieldStats.lowerBound() == null) {
                return false;
            }
            ByteBuffer prefixAsBytes = lit.toByteBuffer();
            Comparator<ByteBuffer> comparator = Comparators.unsignedBytes();
            int lowerCmp = comparator.compare(BinaryUtil.truncateBinary(lower = fieldStats.lowerBound(), lowerLength = Math.min(prefixAsBytes.remaining(), lower.remaining())), prefixAsBytes);
            if (lowerCmp > 0) {
                return false;
            }
            ByteBuffer upper = fieldStats.upperBound();
            int upperCmp = comparator.compare(BinaryUtil.truncateBinary(upper, upperLength = Math.min(prefixAsBytes.remaining(), upper.remaining())), prefixAsBytes);
            if (upperCmp < 0) {
                return false;
            }
            return true;
        }
    }
}

