/* Generated By:JJTree&JavaCC: Do not edit this line. OgnlParserTokenManager.java */
package org.apache.ibatis.ognl;

import java.math.BigDecimal;
import java.math.BigInteger;

public class OgnlParserTokenManager implements OgnlParserConstants {
  /**
   * Holds the last value computed by a constant token.
   */
  Object literalValue;
  /**
   * Holds the last character escaped or in a character literal.
   */
  private char charValue;
  /**
   * Holds char literal start token.
   */
  private char charLiteralStartQuote;
  /**
   * Holds the last string literal parsed.
   */
  private StringBuffer stringBuffer;

  /**
   * Converts an escape sequence into a character value.
   */
  private char escapeChar() {
    int ofs = image.length() - 1;
    switch (image.charAt(ofs)) {
      case 'n':
        return '\n';
      case 'r':
        return '\r';
      case 't':
        return '\t';
      case 'b':
        return '\b';
      case 'f':
        return '\f';
      case '\\':
        return '\\';
      case '\'':
        return '\'';
      case '\"':
        return '\"';
    }

    // Otherwise, it's an octal number.  Find the backslash and convert.
    while (image.charAt(--ofs) != '\\') {
    }
    int value = 0;
    while (++ofs < image.length())
      value = (value << 3) | (image.charAt(ofs) - '0');
    return (char) value;
  }

  private Object makeInt() {
    Object result;
    String s = image.toString();
    int base = 10;

    if (s.charAt(0) == '0')
      base = (s.length() > 1 && (s.charAt(1) == 'x' || s.charAt(1) == 'X')) ? 16 : 8;
    if (base == 16)
      s = s.substring(2); // Trim the 0x off the front
    switch (s.charAt(s.length() - 1)) {
      case 'l':
      case 'L':
        result = Long.valueOf(s.substring(0, s.length() - 1), base);
        break;

      case 'h':
      case 'H':
        result = new BigInteger(s.substring(0, s.length() - 1), base);
        break;

      default:
        result = Integer.valueOf(s, base);
        break;
    }
    return result;
  }

  private Object makeFloat() {
    String s = image.toString();
    switch (s.charAt(s.length() - 1)) {
      case 'f':
      case 'F':
        return Float.valueOf(s);

      case 'b':
      case 'B':
        return new BigDecimal(s.substring(0, s.length() - 1));

      case 'd':
      case 'D':
      default:
        return Double.valueOf(s);
    }
  }

  public java.io.PrintStream debugStream = System.out;

  public void setDebugStream(java.io.PrintStream ds) {
    debugStream = ds;
  }

  private final int jjStopStringLiteralDfa_0(int pos, long active0, long active1) {
    switch (pos) {
      case 0:
        if ((active0 & 0x201c4055d555540L) != 0L) {
          jjmatchedKind = 64;
          return 1;
        }
        if ((active0 & 0x400000000000000L) != 0L)
          return 1;
        if ((active0 & 0x10000000000000L) != 0L)
          return 3;
        if ((active0 & 0x80000000000L) != 0L)
          return 9;
        return -1;
      case 1:
        if ((active0 & 0x201c00550045500L) != 0L) {
          if (jjmatchedPos != 1) {
            jjmatchedKind = 64;
            jjmatchedPos = 1;
          }
          return 1;
        }
        if ((active0 & 0x4000d510040L) != 0L)
          return 1;
        return -1;
      case 2:
        if ((active0 & 0x1c40400004000L) != 0L) {
          jjmatchedKind = 64;
          jjmatchedPos = 2;
          return 1;
        }
        if ((active0 & 0x200000155041500L) != 0L)
          return 1;
        return -1;
      case 3:
        if ((active0 & 0x1400400004000L) != 0L)
          return 1;
        if ((active0 & 0x840000000000L) != 0L) {
          jjmatchedKind = 64;
          jjmatchedPos = 3;
          return 1;
        }
        return -1;
      case 4:
        if ((active0 & 0x800000000000L) != 0L)
          return 1;
        if ((active0 & 0x40000000000L) != 0L) {
          jjmatchedKind = 64;
          jjmatchedPos = 4;
          return 1;
        }
        return -1;
      case 5:
        if ((active0 & 0x40000000000L) != 0L) {
          jjmatchedKind = 64;
          jjmatchedPos = 5;
          return 1;
        }
        return -1;
      case 6:
        if ((active0 & 0x40000000000L) != 0L) {
          jjmatchedKind = 64;
          jjmatchedPos = 6;
          return 1;
        }
        return -1;
      case 7:
        if ((active0 & 0x40000000000L) != 0L) {
          jjmatchedKind = 64;
          jjmatchedPos = 7;
          return 1;
        }
        return -1;
      case 8:
        if ((active0 & 0x40000000000L) != 0L) {
          jjmatchedKind = 64;
          jjmatchedPos = 8;
          return 1;
        }
        return -1;
      default:
        return -1;
    }
  }

  private final int jjStartNfa_0(int pos, long active0, long active1) {
    return jjMoveNfa_0(jjStopStringLiteralDfa_0(pos, active0, active1), pos + 1);
  }

  private final int jjStopAtPos(int pos, int kind) {
    jjmatchedKind = kind;
    jjmatchedPos = pos;
    return pos + 1;
  }

  private final int jjStartNfaWithStates_0(int pos, int kind, int state) {
    jjmatchedKind = kind;
    jjmatchedPos = pos;
    try {
      curChar = input_stream.readChar();
    }
    catch (java.io.IOException e) {
      return pos + 1;
    }
    return jjMoveNfa_0(state, pos + 1);
  }

  private final int jjMoveStringLiteralDfa0_0() {
    switch (curChar) {
      case 33:
        jjmatchedKind = 41;
        return jjMoveStringLiteralDfa1_0(0x20000L);
      case 34:
        return jjStopAtPos(0, 70);
      case 35:
        jjmatchedKind = 51;
        return jjMoveStringLiteralDfa1_0(0x6000000000000L);
      case 36:
        return jjStartNfaWithStates_0(0, 58, 1);
      case 37:
        return jjStopAtPos(0, 39);
      case 38:
        jjmatchedKind = 13;
        return jjMoveStringLiteralDfa1_0(0x80L);
      case 39:
        return jjStopAtPos(0, 69);
      case 40:
        return jjStopAtPos(0, 44);
      case 41:
        return jjStopAtPos(0, 45);
      case 42:
        return jjStopAtPos(0, 37);
      case 43:
        return jjStopAtPos(0, 35);
      case 44:
        return jjStopAtPos(0, 1);
      case 45:
        return jjStopAtPos(0, 36);
      case 46:
        return jjStartNfaWithStates_0(0, 43, 9);
      case 47:
        return jjStopAtPos(0, 38);
      case 58:
        return jjStopAtPos(0, 4);
      case 60:
        jjmatchedKind = 19;
        return jjMoveStringLiteralDfa1_0(0x20800000L);
      case 61:
        jjmatchedKind = 2;
        return jjMoveStringLiteralDfa1_0(0x8000L);
      case 62:
        jjmatchedKind = 21;
        return jjMoveStringLiteralDfa1_0(0x282000000L);
      case 63:
        return jjStopAtPos(0, 3);
      case 64:
        return jjStopAtPos(0, 56);
      case 91:
        return jjStartNfaWithStates_0(0, 52, 3);
      case 93:
        return jjStopAtPos(0, 53);
      case 94:
        return jjStopAtPos(0, 11);
      case 96:
        return jjStopAtPos(0, 68);
      case 97:
        return jjMoveStringLiteralDfa1_0(0x100L);
      case 98:
        return jjMoveStringLiteralDfa1_0(0x4400L);
      case 101:
        return jjMoveStringLiteralDfa1_0(0x10000L);
      case 102:
        return jjMoveStringLiteralDfa1_0(0x800000000000L);
      case 103:
        return jjMoveStringLiteralDfa1_0(0x4400000L);
      case 105:
        return jjMoveStringLiteralDfa1_0(0x40008000000L);
      case 108:
        return jjMoveStringLiteralDfa1_0(0x1100000L);
      case 110:
        return jjMoveStringLiteralDfa1_0(0x201000010040000L);
      case 111:
        return jjMoveStringLiteralDfa1_0(0x40L);
      case 115:
        return jjMoveStringLiteralDfa1_0(0x140000000L);
      case 116:
        return jjMoveStringLiteralDfa1_0(0x400000000000L);
      case 117:
        return jjMoveStringLiteralDfa1_0(0x400000000L);
      case 120:
        return jjMoveStringLiteralDfa1_0(0x1000L);
      case 123:
        return jjStopAtPos(0, 54);
      case 124:
        jjmatchedKind = 9;
        return jjMoveStringLiteralDfa1_0(0x20L);
      case 125:
        return jjStopAtPos(0, 55);
      case 126:
        return jjStopAtPos(0, 40);
      default:
        return jjMoveNfa_0(0, 0);
    }
  }

  private final int jjMoveStringLiteralDfa1_0(long active0) {
    try {
      curChar = input_stream.readChar();
    }
    catch (java.io.IOException e) {
      jjStopStringLiteralDfa_0(0, active0, 0L);
      return 1;
    }
    switch (curChar) {
      case 38:
        if ((active0 & 0x80L) != 0L)
          return jjStopAtPos(1, 7);
        break;
      case 60:
        if ((active0 & 0x20000000L) != 0L)
          return jjStopAtPos(1, 29);
        break;
      case 61:
        if ((active0 & 0x8000L) != 0L)
          return jjStopAtPos(1, 15);
        else if ((active0 & 0x20000L) != 0L)
          return jjStopAtPos(1, 17);
        else if ((active0 & 0x800000L) != 0L)
          return jjStopAtPos(1, 23);
        else if ((active0 & 0x2000000L) != 0L)
          return jjStopAtPos(1, 25);
        break;
      case 62:
        if ((active0 & 0x80000000L) != 0L) {
          jjmatchedKind = 31;
          jjmatchedPos = 1;
        }
        return jjMoveStringLiteralDfa2_0(active0, 0x200000000L);
      case 97:
        return jjMoveStringLiteralDfa2_0(active0, 0x800000004000L);
      case 101:
        return jjMoveStringLiteralDfa2_0(active0, 0x200000000040000L);
      case 104:
        return jjMoveStringLiteralDfa2_0(active0, 0x140000000L);
      case 110:
        if ((active0 & 0x8000000L) != 0L) {
          jjmatchedKind = 27;
          jjmatchedPos = 1;
        }
        return jjMoveStringLiteralDfa2_0(active0, 0x40000000100L);
      case 111:
        return jjMoveStringLiteralDfa2_0(active0, 0x10001400L);
      case 113:
        if ((active0 & 0x10000L) != 0L)
          return jjStartNfaWithStates_0(1, 16, 1);
        break;
      case 114:
        if ((active0 & 0x40L) != 0L)
          return jjStartNfaWithStates_0(1, 6, 1);
        return jjMoveStringLiteralDfa2_0(active0, 0x4400000000000L);
      case 115:
        return jjMoveStringLiteralDfa2_0(active0, 0x400000000L);
      case 116:
        if ((active0 & 0x100000L) != 0L) {
          jjmatchedKind = 20;
          jjmatchedPos = 1;
        } else if ((active0 & 0x400000L) != 0L) {
          jjmatchedKind = 22;
          jjmatchedPos = 1;
        }
        return jjMoveStringLiteralDfa2_0(active0, 0x2000005000000L);
      case 117:
        return jjMoveStringLiteralDfa2_0(active0, 0x1000000000000L);
      case 124:
        if ((active0 & 0x20L) != 0L)
          return jjStopAtPos(1, 5);
        break;
      default:
        break;
    }
    return jjStartNfa_0(0, active0, 0L);
  }

  private final int jjMoveStringLiteralDfa2_0(long old0, long active0) {
    if (((active0 &= old0)) == 0L)
      return jjStartNfa_0(0, old0, 0L);
    try {
      curChar = input_stream.readChar();
    }
    catch (java.io.IOException e) {
      jjStopStringLiteralDfa_0(1, active0, 0L);
      return 2;
    }
    switch (curChar) {
      case 62:
        if ((active0 & 0x200000000L) != 0L)
          return jjStopAtPos(2, 33);
        break;
      case 100:
        if ((active0 & 0x100L) != 0L)
          return jjStartNfaWithStates_0(2, 8, 1);
        break;
      case 101:
        if ((active0 & 0x1000000L) != 0L)
          return jjStartNfaWithStates_0(2, 24, 1);
        else if ((active0 & 0x4000000L) != 0L)
          return jjStartNfaWithStates_0(2, 26, 1);
        break;
      case 104:
        return jjMoveStringLiteralDfa3_0(active0, 0x2000400000000L);
      case 108:
        if ((active0 & 0x40000000L) != 0L)
          return jjStartNfaWithStates_0(2, 30, 1);
        return jjMoveStringLiteralDfa3_0(active0, 0x1800000000000L);
      case 110:
        return jjMoveStringLiteralDfa3_0(active0, 0x4000L);
      case 111:
        return jjMoveStringLiteralDfa3_0(active0, 0x4000000000000L);
      case 113:
        if ((active0 & 0x40000L) != 0L)
          return jjStartNfaWithStates_0(2, 18, 1);
        break;
      case 114:
        if ((active0 & 0x400L) != 0L)
          return jjStartNfaWithStates_0(2, 10, 1);
        else if ((active0 & 0x1000L) != 0L)
          return jjStartNfaWithStates_0(2, 12, 1);
        else if ((active0 & 0x100000000L) != 0L)
          return jjStartNfaWithStates_0(2, 32, 1);
        break;
      case 115:
        return jjMoveStringLiteralDfa3_0(active0, 0x40000000000L);
      case 116:
        if ((active0 & 0x10000000L) != 0L)
          return jjStartNfaWithStates_0(2, 28, 1);
        break;
      case 117:
        return jjMoveStringLiteralDfa3_0(active0, 0x400000000000L);
      case 119:
        if ((active0 & 0x200000000000000L) != 0L)
          return jjStartNfaWithStates_0(2, 57, 1);
        break;
      default:
        break;
    }
    return jjStartNfa_0(1, active0, 0L);
  }

  private final int jjMoveStringLiteralDfa3_0(long old0, long active0) {
    if (((active0 &= old0)) == 0L)
      return jjStartNfa_0(1, old0, 0L);
    try {
      curChar = input_stream.readChar();
    }
    catch (java.io.IOException e) {
      jjStopStringLiteralDfa_0(2, active0, 0L);
      return 3;
    }
    switch (curChar) {
      case 100:
        if ((active0 & 0x4000L) != 0L)
          return jjStartNfaWithStates_0(3, 14, 1);
        break;
      case 101:
        if ((active0 & 0x400000000000L) != 0L)
          return jjStartNfaWithStates_0(3, 46, 1);
        break;
      case 105:
        return jjMoveStringLiteralDfa4_0(active0, 0x2000000000000L);
      case 108:
        if ((active0 & 0x1000000000000L) != 0L)
          return jjStartNfaWithStates_0(3, 48, 1);
        break;
      case 111:
        return jjMoveStringLiteralDfa4_0(active0, 0x4000000000000L);
      case 114:
        if ((active0 & 0x400000000L) != 0L)
          return jjStartNfaWithStates_0(3, 34, 1);
        break;
      case 115:
        return jjMoveStringLiteralDfa4_0(active0, 0x800000000000L);
      case 116:
        return jjMoveStringLiteralDfa4_0(active0, 0x40000000000L);
      default:
        break;
    }
    return jjStartNfa_0(2, active0, 0L);
  }

  private final int jjMoveStringLiteralDfa4_0(long old0, long active0) {
    if (((active0 &= old0)) == 0L)
      return jjStartNfa_0(2, old0, 0L);
    try {
      curChar = input_stream.readChar();
    }
    catch (java.io.IOException e) {
      jjStopStringLiteralDfa_0(3, active0, 0L);
      return 4;
    }
    switch (curChar) {
      case 97:
        return jjMoveStringLiteralDfa5_0(active0, 0x40000000000L);
      case 101:
        if ((active0 & 0x800000000000L) != 0L)
          return jjStartNfaWithStates_0(4, 47, 1);
        break;
      case 115:
        if ((active0 & 0x2000000000000L) != 0L)
          return jjStopAtPos(4, 49);
        break;
      case 116:
        if ((active0 & 0x4000000000000L) != 0L)
          return jjStopAtPos(4, 50);
        break;
      default:
        break;
    }
    return jjStartNfa_0(3, active0, 0L);
  }

  private final int jjMoveStringLiteralDfa5_0(long old0, long active0) {
    if (((active0 &= old0)) == 0L)
      return jjStartNfa_0(3, old0, 0L);
    try {
      curChar = input_stream.readChar();
    }
    catch (java.io.IOException e) {
      jjStopStringLiteralDfa_0(4, active0, 0L);
      return 5;
    }
    switch (curChar) {
      case 110:
        return jjMoveStringLiteralDfa6_0(active0, 0x40000000000L);
      default:
        break;
    }
    return jjStartNfa_0(4, active0, 0L);
  }

  private final int jjMoveStringLiteralDfa6_0(long old0, long active0) {
    if (((active0 &= old0)) == 0L)
      return jjStartNfa_0(4, old0, 0L);
    try {
      curChar = input_stream.readChar();
    }
    catch (java.io.IOException e) {
      jjStopStringLiteralDfa_0(5, active0, 0L);
      return 6;
    }
    switch (curChar) {
      case 99:
        return jjMoveStringLiteralDfa7_0(active0, 0x40000000000L);
      default:
        break;
    }
    return jjStartNfa_0(5, active0, 0L);
  }

  private final int jjMoveStringLiteralDfa7_0(long old0, long active0) {
    if (((active0 &= old0)) == 0L)
      return jjStartNfa_0(5, old0, 0L);
    try {
      curChar = input_stream.readChar();
    }
    catch (java.io.IOException e) {
      jjStopStringLiteralDfa_0(6, active0, 0L);
      return 7;
    }
    switch (curChar) {
      case 101:
        return jjMoveStringLiteralDfa8_0(active0, 0x40000000000L);
      default:
        break;
    }
    return jjStartNfa_0(6, active0, 0L);
  }

  private final int jjMoveStringLiteralDfa8_0(long old0, long active0) {
    if (((active0 &= old0)) == 0L)
      return jjStartNfa_0(6, old0, 0L);
    try {
      curChar = input_stream.readChar();
    }
    catch (java.io.IOException e) {
      jjStopStringLiteralDfa_0(7, active0, 0L);
      return 8;
    }
    switch (curChar) {
      case 111:
        return jjMoveStringLiteralDfa9_0(active0, 0x40000000000L);
      default:
        break;
    }
    return jjStartNfa_0(7, active0, 0L);
  }

  private final int jjMoveStringLiteralDfa9_0(long old0, long active0) {
    if (((active0 &= old0)) == 0L)
      return jjStartNfa_0(7, old0, 0L);
    try {
      curChar = input_stream.readChar();
    }
    catch (java.io.IOException e) {
      jjStopStringLiteralDfa_0(8, active0, 0L);
      return 9;
    }
    switch (curChar) {
      case 102:
        if ((active0 & 0x40000000000L) != 0L)
          return jjStartNfaWithStates_0(9, 42, 1);
        break;
      default:
        break;
    }
    return jjStartNfa_0(8, active0, 0L);
  }

  private final void jjCheckNAdd(int state) {
    if (jjrounds[state] != jjround) {
      jjstateSet[jjnewStateCnt++] = state;
      jjrounds[state] = jjround;
    }
  }

  private final void jjAddStates(int start, int end) {
    do {
      jjstateSet[jjnewStateCnt++] = jjnextStates[start];
    } while (start++ != end);
  }

  private final void jjCheckNAddTwoStates(int state1, int state2) {
    jjCheckNAdd(state1);
    jjCheckNAdd(state2);
  }

  private final void jjCheckNAddStates(int start, int end) {
    do {
      jjCheckNAdd(jjnextStates[start]);
    } while (start++ != end);
  }

  private final void jjCheckNAddStates(int start) {
    jjCheckNAdd(jjnextStates[start]);
    jjCheckNAdd(jjnextStates[start + 1]);
  }

  static final long[] jjbitVec0 = {
      0x1ff00000fffffffeL, 0xffffffffffffc000L, 0xffffffffL, 0x600000000000000L
  };
  static final long[] jjbitVec2 = {
      0x0L, 0x0L, 0x0L, 0xff7fffffff7fffffL
  };
  static final long[] jjbitVec3 = {
      0x0L, 0xffffffffffffffffL, 0xffffffffffffffffL, 0xffffffffffffffffL
  };
  static final long[] jjbitVec4 = {
      0xffffffffffffffffL, 0xffffffffffffffffL, 0xffffL, 0x0L
  };
  static final long[] jjbitVec5 = {
      0xffffffffffffffffL, 0xffffffffffffffffL, 0x0L, 0x0L
  };
  static final long[] jjbitVec6 = {
      0x3fffffffffffL, 0x0L, 0x0L, 0x0L
  };

  private final int jjMoveNfa_0(int startState, int curPos) {
    int[] nextStates;
    int startsAt = 0;
    jjnewStateCnt = 27;
    int i = 1;
    jjstateSet[0] = startState;
    int j, kind = 0x7fffffff;
    for (; ;) {
      if (++jjround == 0x7fffffff)
        ReInitRounds();
      if (curChar < 64) {
        long l = 1L << curChar;
        MatchLoop:
        do {
          switch (jjstateSet[--i]) {
            case 0:
              if ((0x3ff000000000000L & l) != 0L)
                jjCheckNAddStates(0, 5);
              else if (curChar == 46)
                jjCheckNAdd(9);
              else if (curChar == 36) {
                if (kind > 64)
                  kind = 64;
                jjCheckNAdd(1);
              }
              if ((0x3fe000000000000L & l) != 0L) {
                if (kind > 80)
                  kind = 80;
                jjCheckNAddTwoStates(6, 7);
              } else if (curChar == 48) {
                if (kind > 80)
                  kind = 80;
                jjCheckNAddStates(6, 8);
              }
              break;
            case 1:
              if ((0x3ff001000000000L & l) == 0L)
                break;
              if (kind > 64)
                kind = 64;
              jjCheckNAdd(1);
              break;
            case 3:
              if ((0x41000000000L & l) != 0L)
                jjstateSet[jjnewStateCnt++] = 4;
              break;
            case 5:
              if ((0x3fe000000000000L & l) == 0L)
                break;
              if (kind > 80)
                kind = 80;
              jjCheckNAddTwoStates(6, 7);
              break;
            case 6:
              if ((0x3ff000000000000L & l) == 0L)
                break;
              if (kind > 80)
                kind = 80;
              jjCheckNAddTwoStates(6, 7);
              break;
            case 8:
              if (curChar == 46)
                jjCheckNAdd(9);
              break;
            case 9:
              if ((0x3ff000000000000L & l) == 0L)
                break;
              if (kind > 81)
                kind = 81;
              jjCheckNAddStates(9, 11);
              break;
            case 11:
              if ((0x280000000000L & l) != 0L)
                jjCheckNAdd(12);
              break;
            case 12:
              if ((0x3ff000000000000L & l) == 0L)
                break;
              if (kind > 81)
                kind = 81;
              jjCheckNAddTwoStates(12, 13);
              break;
            case 14:
              if ((0x3ff000000000000L & l) != 0L)
                jjCheckNAddStates(0, 5);
              break;
            case 15:
              if ((0x3ff000000000000L & l) != 0L)
                jjCheckNAddTwoStates(15, 16);
              break;
            case 16:
              if (curChar != 46)
                break;
              if (kind > 81)
                kind = 81;
              jjCheckNAddStates(12, 14);
              break;
            case 17:
              if ((0x3ff000000000000L & l) == 0L)
                break;
              if (kind > 81)
                kind = 81;
              jjCheckNAddStates(12, 14);
              break;
            case 18:
              if ((0x3ff000000000000L & l) != 0L)
                jjCheckNAddTwoStates(18, 19);
              break;
            case 20:
              if ((0x280000000000L & l) != 0L)
                jjCheckNAdd(21);
              break;
            case 21:
              if ((0x3ff000000000000L & l) == 0L)
                break;
              if (kind > 81)
                kind = 81;
              jjCheckNAddTwoStates(21, 13);
              break;
            case 22:
              if ((0x3ff000000000000L & l) != 0L)
                jjCheckNAddTwoStates(22, 13);
              break;
            case 23:
              if (curChar != 48)
                break;
              if (kind > 80)
                kind = 80;
              jjCheckNAddStates(6, 8);
              break;
            case 24:
              if ((0xff000000000000L & l) == 0L)
                break;
              if (kind > 80)
                kind = 80;
              jjCheckNAddTwoStates(24, 7);
              break;
            case 26:
              if ((0x3ff000000000000L & l) == 0L)
                break;
              if (kind > 80)
                kind = 80;
              jjCheckNAddTwoStates(26, 7);
              break;
            default:
              break;
          }
        } while (i != startsAt);
      } else if (curChar < 128) {
        long l = 1L << (curChar & 077);
        MatchLoop:
        do {
          switch (jjstateSet[--i]) {
            case 0:
              if ((0x7fffffe87fffffeL & l) != 0L) {
                if (kind > 64)
                  kind = 64;
                jjCheckNAdd(1);
              } else if (curChar == 91)
                jjstateSet[jjnewStateCnt++] = 3;
              break;
            case 1:
              if ((0x7fffffe87fffffeL & l) == 0L)
                break;
              if (kind > 64)
                kind = 64;
              jjCheckNAdd(1);
              break;
            case 2:
              if (curChar == 91)
                jjstateSet[jjnewStateCnt++] = 3;
              break;
            case 3:
              if ((0x1000000040000000L & l) != 0L)
                jjstateSet[jjnewStateCnt++] = 4;
              break;
            case 4:
              if (curChar == 93)
                kind = 67;
              break;
            case 7:
              if ((0x110000001100L & l) != 0L && kind > 80)
                kind = 80;
              break;
            case 10:
              if ((0x2000000020L & l) != 0L)
                jjAddStates(15, 16);
              break;
            case 13:
              if ((0x5400000054L & l) != 0L && kind > 81)
                kind = 81;
              break;
            case 19:
              if ((0x2000000020L & l) != 0L)
                jjAddStates(17, 18);
              break;
            case 25:
              if ((0x100000001000000L & l) != 0L)
                jjCheckNAdd(26);
              break;
            case 26:
              if ((0x7e0000007eL & l) == 0L)
                break;
              if (kind > 80)
                kind = 80;
              jjCheckNAddTwoStates(26, 7);
              break;
            default:
              break;
          }
        } while (i != startsAt);
      } else {
        int hiByte = (int) (curChar >> 8);
        int i1 = hiByte >> 6;
        long l1 = 1L << (hiByte & 077);
        int i2 = (curChar & 0xff) >> 6;
        long l2 = 1L << (curChar & 077);
        MatchLoop:
        do {
          switch (jjstateSet[--i]) {
            case 0:
            case 1:
              if (!jjCanMove_0(hiByte, i1, i2, l1, l2))
                break;
              if (kind > 64)
                kind = 64;
              jjCheckNAdd(1);
              break;
            default:
              break;
          }
        } while (i != startsAt);
      }
      if (kind != 0x7fffffff) {
        jjmatchedKind = kind;
        jjmatchedPos = curPos;
        kind = 0x7fffffff;
      }
      ++curPos;
      if ((i = jjnewStateCnt) == (startsAt = 27 - (jjnewStateCnt = startsAt)))
        return curPos;
      try {
        curChar = input_stream.readChar();
      }
      catch (java.io.IOException e) {
        return curPos;
      }
    }
  }

  private final int jjStopStringLiteralDfa_2(int pos, long active0, long active1) {
    switch (pos) {
      default:
        return -1;
    }
  }

  private final int jjStartNfa_2(int pos, long active0, long active1) {
    return jjMoveNfa_2(jjStopStringLiteralDfa_2(pos, active0, active1), pos + 1);
  }

  private final int jjStartNfaWithStates_2(int pos, int kind, int state) {
    jjmatchedKind = kind;
    jjmatchedPos = pos;
    try {
      curChar = input_stream.readChar();
    }
    catch (java.io.IOException e) {
      return pos + 1;
    }
    return jjMoveNfa_2(state, pos + 1);
  }

  private final int jjMoveStringLiteralDfa0_2() {
    switch (curChar) {
      case 96:
        return jjStopAtPos(0, 76);
      default:
        return jjMoveNfa_2(0, 0);
    }
  }

  static final long[] jjbitVec7 = {
      0xfffffffffffffffeL, 0xffffffffffffffffL, 0xffffffffffffffffL, 0xffffffffffffffffL
  };
  static final long[] jjbitVec8 = {
      0x0L, 0x0L, 0xffffffffffffffffL, 0xffffffffffffffffL
  };

  private final int jjMoveNfa_2(int startState, int curPos) {
    int[] nextStates;
    int startsAt = 0;
    jjnewStateCnt = 6;
    int i = 1;
    jjstateSet[0] = startState;
    int j, kind = 0x7fffffff;
    for (; ;) {
      if (++jjround == 0x7fffffff)
        ReInitRounds();
      if (curChar < 64) {
        long l = 1L << curChar;
        MatchLoop:
        do {
          switch (jjstateSet[--i]) {
            case 0:
              if (kind > 75)
                kind = 75;
              break;
            case 1:
              if ((0x8400000000L & l) != 0L && kind > 74)
                kind = 74;
              break;
            case 2:
              if ((0xf000000000000L & l) != 0L)
                jjstateSet[jjnewStateCnt++] = 3;
              break;
            case 3:
              if ((0xff000000000000L & l) == 0L)
                break;
              if (kind > 74)
                kind = 74;
              jjstateSet[jjnewStateCnt++] = 4;
              break;
            case 4:
              if ((0xff000000000000L & l) != 0L && kind > 74)
                kind = 74;
              break;
            default:
              break;
          }
        } while (i != startsAt);
      } else if (curChar < 128) {
        long l = 1L << (curChar & 077);
        MatchLoop:
        do {
          switch (jjstateSet[--i]) {
            case 0:
              if ((0xfffffffeefffffffL & l) != 0L) {
                if (kind > 75)
                  kind = 75;
              } else if (curChar == 92)
                jjAddStates(19, 21);
              break;
            case 1:
              if ((0x14404510000000L & l) != 0L && kind > 74)
                kind = 74;
              break;
            case 5:
              if ((0xfffffffeefffffffL & l) != 0L && kind > 75)
                kind = 75;
              break;
            default:
              break;
          }
        } while (i != startsAt);
      } else {
        int hiByte = (int) (curChar >> 8);
        int i1 = hiByte >> 6;
        long l1 = 1L << (hiByte & 077);
        int i2 = (curChar & 0xff) >> 6;
        long l2 = 1L << (curChar & 077);
        MatchLoop:
        do {
          switch (jjstateSet[--i]) {
            case 0:
              if (jjCanMove_1(hiByte, i1, i2, l1, l2) && kind > 75)
                kind = 75;
              break;
            default:
              break;
          }
        } while (i != startsAt);
      }
      if (kind != 0x7fffffff) {
        jjmatchedKind = kind;
        jjmatchedPos = curPos;
        kind = 0x7fffffff;
      }
      ++curPos;
      if ((i = jjnewStateCnt) == (startsAt = 6 - (jjnewStateCnt = startsAt)))
        return curPos;
      try {
        curChar = input_stream.readChar();
      }
      catch (java.io.IOException e) {
        return curPos;
      }
    }
  }

  private final int jjStopStringLiteralDfa_1(int pos, long active0, long active1) {
    switch (pos) {
      default:
        return -1;
    }
  }

  private final int jjStartNfa_1(int pos, long active0, long active1) {
    return jjMoveNfa_1(jjStopStringLiteralDfa_1(pos, active0, active1), pos + 1);
  }

  private final int jjStartNfaWithStates_1(int pos, int kind, int state) {
    jjmatchedKind = kind;
    jjmatchedPos = pos;
    try {
      curChar = input_stream.readChar();
    }
    catch (java.io.IOException e) {
      return pos + 1;
    }
    return jjMoveNfa_1(state, pos + 1);
  }

  private final int jjMoveStringLiteralDfa0_1() {
    switch (curChar) {
      case 39:
        return jjStopAtPos(0, 73);
      default:
        return jjMoveNfa_1(0, 0);
    }
  }

  private final int jjMoveNfa_1(int startState, int curPos) {
    int[] nextStates;
    int startsAt = 0;
    jjnewStateCnt = 6;
    int i = 1;
    jjstateSet[0] = startState;
    int j, kind = 0x7fffffff;
    for (; ;) {
      if (++jjround == 0x7fffffff)
        ReInitRounds();
      if (curChar < 64) {
        long l = 1L << curChar;
        MatchLoop:
        do {
          switch (jjstateSet[--i]) {
            case 0:
              if ((0xffffff7fffffffffL & l) != 0L && kind > 72)
                kind = 72;
              break;
            case 1:
              if ((0x8400000000L & l) != 0L && kind > 71)
                kind = 71;
              break;
            case 2:
              if ((0xf000000000000L & l) != 0L)
                jjstateSet[jjnewStateCnt++] = 3;
              break;
            case 3:
              if ((0xff000000000000L & l) == 0L)
                break;
              if (kind > 71)
                kind = 71;
              jjstateSet[jjnewStateCnt++] = 4;
              break;
            case 4:
              if ((0xff000000000000L & l) != 0L && kind > 71)
                kind = 71;
              break;
            default:
              break;
          }
        } while (i != startsAt);
      } else if (curChar < 128) {
        long l = 1L << (curChar & 077);
        MatchLoop:
        do {
          switch (jjstateSet[--i]) {
            case 0:
              if ((0xffffffffefffffffL & l) != 0L) {
                if (kind > 72)
                  kind = 72;
              } else if (curChar == 92)
                jjAddStates(19, 21);
              break;
            case 1:
              if ((0x14404510000000L & l) != 0L && kind > 71)
                kind = 71;
              break;
            case 5:
              if ((0xffffffffefffffffL & l) != 0L && kind > 72)
                kind = 72;
              break;
            default:
              break;
          }
        } while (i != startsAt);
      } else {
        int hiByte = (int) (curChar >> 8);
        int i1 = hiByte >> 6;
        long l1 = 1L << (hiByte & 077);
        int i2 = (curChar & 0xff) >> 6;
        long l2 = 1L << (curChar & 077);
        MatchLoop:
        do {
          switch (jjstateSet[--i]) {
            case 0:
              if (jjCanMove_1(hiByte, i1, i2, l1, l2) && kind > 72)
                kind = 72;
              break;
            default:
              break;
          }
        } while (i != startsAt);
      }
      if (kind != 0x7fffffff) {
        jjmatchedKind = kind;
        jjmatchedPos = curPos;
        kind = 0x7fffffff;
      }
      ++curPos;
      if ((i = jjnewStateCnt) == (startsAt = 6 - (jjnewStateCnt = startsAt)))
        return curPos;
      try {
        curChar = input_stream.readChar();
      }
      catch (java.io.IOException e) {
        return curPos;
      }
    }
  }

  private final int jjStopStringLiteralDfa_3(int pos, long active0, long active1) {
    switch (pos) {
      default:
        return -1;
    }
  }

  private final int jjStartNfa_3(int pos, long active0, long active1) {
    return jjMoveNfa_3(jjStopStringLiteralDfa_3(pos, active0, active1), pos + 1);
  }

  private final int jjStartNfaWithStates_3(int pos, int kind, int state) {
    jjmatchedKind = kind;
    jjmatchedPos = pos;
    try {
      curChar = input_stream.readChar();
    }
    catch (java.io.IOException e) {
      return pos + 1;
    }
    return jjMoveNfa_3(state, pos + 1);
  }

  private final int jjMoveStringLiteralDfa0_3() {
    switch (curChar) {
      case 34:
        return jjStopAtPos(0, 79);
      default:
        return jjMoveNfa_3(0, 0);
    }
  }

  private final int jjMoveNfa_3(int startState, int curPos) {
    int[] nextStates;
    int startsAt = 0;
    jjnewStateCnt = 6;
    int i = 1;
    jjstateSet[0] = startState;
    int j, kind = 0x7fffffff;
    for (; ;) {
      if (++jjround == 0x7fffffff)
        ReInitRounds();
      if (curChar < 64) {
        long l = 1L << curChar;
        MatchLoop:
        do {
          switch (jjstateSet[--i]) {
            case 0:
              if ((0xfffffffbffffffffL & l) != 0L && kind > 78)
                kind = 78;
              break;
            case 1:
              if ((0x8400000000L & l) != 0L && kind > 77)
                kind = 77;
              break;
            case 2:
              if ((0xf000000000000L & l) != 0L)
                jjstateSet[jjnewStateCnt++] = 3;
              break;
            case 3:
              if ((0xff000000000000L & l) == 0L)
                break;
              if (kind > 77)
                kind = 77;
              jjstateSet[jjnewStateCnt++] = 4;
              break;
            case 4:
              if ((0xff000000000000L & l) != 0L && kind > 77)
                kind = 77;
              break;
            default:
              break;
          }
        } while (i != startsAt);
      } else if (curChar < 128) {
        long l = 1L << (curChar & 077);
        MatchLoop:
        do {
          switch (jjstateSet[--i]) {
            case 0:
              if ((0xffffffffefffffffL & l) != 0L) {
                if (kind > 78)
                  kind = 78;
              } else if (curChar == 92)
                jjAddStates(19, 21);
              break;
            case 1:
              if ((0x14404510000000L & l) != 0L && kind > 77)
                kind = 77;
              break;
            case 5:
              if ((0xffffffffefffffffL & l) != 0L && kind > 78)
                kind = 78;
              break;
            default:
              break;
          }
        } while (i != startsAt);
      } else {
        int hiByte = (int) (curChar >> 8);
        int i1 = hiByte >> 6;
        long l1 = 1L << (hiByte & 077);
        int i2 = (curChar & 0xff) >> 6;
        long l2 = 1L << (curChar & 077);
        MatchLoop:
        do {
          switch (jjstateSet[--i]) {
            case 0:
              if (jjCanMove_1(hiByte, i1, i2, l1, l2) && kind > 78)
                kind = 78;
              break;
            default:
              break;
          }
        } while (i != startsAt);
      }
      if (kind != 0x7fffffff) {
        jjmatchedKind = kind;
        jjmatchedPos = curPos;
        kind = 0x7fffffff;
      }
      ++curPos;
      if ((i = jjnewStateCnt) == (startsAt = 6 - (jjnewStateCnt = startsAt)))
        return curPos;
      try {
        curChar = input_stream.readChar();
      }
      catch (java.io.IOException e) {
        return curPos;
      }
    }
  }

  static final int[] jjnextStates = {
      15, 16, 18, 19, 22, 13, 24, 25, 7, 9, 10, 13, 17, 10, 13, 11,
      12, 20, 21, 1, 2, 3,
  };

  private static final boolean jjCanMove_0(int hiByte, int i1, int i2, long l1, long l2) {
    switch (hiByte) {
      case 0:
        return ((jjbitVec2[i2] & l2) != 0L);
      case 48:
        return ((jjbitVec3[i2] & l2) != 0L);
      case 49:
        return ((jjbitVec4[i2] & l2) != 0L);
      case 51:
        return ((jjbitVec5[i2] & l2) != 0L);
      case 61:
        return ((jjbitVec6[i2] & l2) != 0L);
      default:
        if ((jjbitVec0[i1] & l1) != 0L)
          return true;
        return false;
    }
  }

  private static final boolean jjCanMove_1(int hiByte, int i1, int i2, long l1, long l2) {
    switch (hiByte) {
      case 0:
        return ((jjbitVec8[i2] & l2) != 0L);
      default:
        if ((jjbitVec7[i1] & l1) != 0L)
          return true;
        return false;
    }
  }

  public static final String[] jjstrLiteralImages = {
      "", "\54", "\75", "\77", "\72", "\174\174", "\157\162", "\46\46",
      "\141\156\144", "\174", "\142\157\162", "\136", "\170\157\162", "\46", "\142\141\156\144",
      "\75\75", "\145\161", "\41\75", "\156\145\161", "\74", "\154\164", "\76", "\147\164",
      "\74\75", "\154\164\145", "\76\75", "\147\164\145", "\151\156", "\156\157\164",
      "\74\74", "\163\150\154", "\76\76", "\163\150\162", "\76\76\76", "\165\163\150\162",
      "\53", "\55", "\52", "\57", "\45", "\176", "\41",
      "\151\156\163\164\141\156\143\145\157\146", "\56", "\50", "\51", "\164\162\165\145", "\146\141\154\163\145",
      "\156\165\154\154", "\43\164\150\151\163", "\43\162\157\157\164", "\43", "\133", "\135", "\173",
      "\175", "\100", "\156\145\167", "\44", null, null, null, null, null, null, null, null,
      null, null, null, null, null, null, null, null, null, null, null, null, null, null,
      null, null, null, null, null,};
  public static final String[] lexStateNames = {
      "DEFAULT",
      "WithinCharLiteral",
      "WithinBackCharLiteral",
      "WithinStringLiteral",
  };
  public static final int[] jjnewLexState = {
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 2, 1, 3, -1, -1, 0, -1,
      -1, 0, -1, -1, 0, -1, -1, -1, -1, -1, -1,
  };
  static final long[] jjtoToken = {
      0x7ffffffffffffffL, 0x39209L,
  };
  static final long[] jjtoSkip = {
      0xf800000000000000L, 0x0L,
  };
  static final long[] jjtoMore = {
      0x0L, 0x6df0L,
  };
  protected JavaCharStream input_stream;
  private final int[] jjrounds = new int[27];
  private final int[] jjstateSet = new int[54];
  StringBuffer image;
  int jjimageLen;
  int lengthOfMatch;
  protected char curChar;

  public OgnlParserTokenManager(JavaCharStream stream) {
    if (JavaCharStream.staticFlag)
      throw new Error("ERROR: Cannot use a static CharStream class with a non-static lexical analyzer.");
    input_stream = stream;
  }

  public OgnlParserTokenManager(JavaCharStream stream, int lexState) {
    this(stream);
    SwitchTo(lexState);
  }

  public void ReInit(JavaCharStream stream) {
    jjmatchedPos = jjnewStateCnt = 0;
    curLexState = defaultLexState;
    input_stream = stream;
    ReInitRounds();
  }

  private final void ReInitRounds() {
    int i;
    jjround = 0x80000001;
    for (i = 27; i-- > 0;)
      jjrounds[i] = 0x80000000;
  }

  public void ReInit(JavaCharStream stream, int lexState) {
    ReInit(stream);
    SwitchTo(lexState);
  }

  public void SwitchTo(int lexState) {
    if (lexState >= 4 || lexState < 0)
      throw new TokenMgrError("Error: Ignoring invalid lexical state : " + lexState + ". State unchanged.", TokenMgrError.INVALID_LEXICAL_STATE);
    else
      curLexState = lexState;
  }

  protected Token jjFillToken() {
    Token t = Token.newToken(jjmatchedKind);
    t.kind = jjmatchedKind;
    String im = jjstrLiteralImages[jjmatchedKind];
    t.image = (im == null) ? input_stream.GetImage() : im;
    t.beginLine = input_stream.getBeginLine();
    t.beginColumn = input_stream.getBeginColumn();
    t.endLine = input_stream.getEndLine();
    t.endColumn = input_stream.getEndColumn();
    return t;
  }

  int curLexState = 0;
  int defaultLexState = 0;
  int jjnewStateCnt;
  int jjround;
  int jjmatchedPos;
  int jjmatchedKind;

  public Token getNextToken() {
    int kind;
    Token specialToken = null;
    Token matchedToken;
    int curPos = 0;

    EOFLoop:
    for (; ;) {
      try {
        curChar = input_stream.BeginToken();
      }
      catch (java.io.IOException e) {
        jjmatchedKind = 0;
        matchedToken = jjFillToken();
        return matchedToken;
      }
      image = null;
      jjimageLen = 0;

      for (; ;) {
        switch (curLexState) {
          case 0:
            try {
              input_stream.backup(0);
              while (curChar <= 32 && (0x100003600L & (1L << curChar)) != 0L)
                curChar = input_stream.BeginToken();
            }
            catch (java.io.IOException e1) {
              continue EOFLoop;
            }
            jjmatchedKind = 0x7fffffff;
            jjmatchedPos = 0;
            curPos = jjMoveStringLiteralDfa0_0();
            break;
          case 1:
            jjmatchedKind = 0x7fffffff;
            jjmatchedPos = 0;
            curPos = jjMoveStringLiteralDfa0_1();
            break;
          case 2:
            jjmatchedKind = 0x7fffffff;
            jjmatchedPos = 0;
            curPos = jjMoveStringLiteralDfa0_2();
            break;
          case 3:
            jjmatchedKind = 0x7fffffff;
            jjmatchedPos = 0;
            curPos = jjMoveStringLiteralDfa0_3();
            break;
        }
        if (jjmatchedKind != 0x7fffffff) {
          if (jjmatchedPos + 1 < curPos)
            input_stream.backup(curPos - jjmatchedPos - 1);
          if ((jjtoToken[jjmatchedKind >> 6] & (1L << (jjmatchedKind & 077))) != 0L) {
            matchedToken = jjFillToken();
            TokenLexicalActions(matchedToken);
            if (jjnewLexState[jjmatchedKind] != -1)
              curLexState = jjnewLexState[jjmatchedKind];
            return matchedToken;
          } else if ((jjtoSkip[jjmatchedKind >> 6] & (1L << (jjmatchedKind & 077))) != 0L) {
            if (jjnewLexState[jjmatchedKind] != -1)
              curLexState = jjnewLexState[jjmatchedKind];
            continue EOFLoop;
          }
          MoreLexicalActions();
          if (jjnewLexState[jjmatchedKind] != -1)
            curLexState = jjnewLexState[jjmatchedKind];
          curPos = 0;
          jjmatchedKind = 0x7fffffff;
          try {
            curChar = input_stream.readChar();
            continue;
          }
          catch (java.io.IOException e1) {
          }
        }
        int error_line = input_stream.getEndLine();
        int error_column = input_stream.getEndColumn();
        String error_after = null;
        boolean EOFSeen = false;
        try {
          input_stream.readChar();
          input_stream.backup(1);
        }
        catch (java.io.IOException e1) {
          EOFSeen = true;
          error_after = curPos <= 1 ? "" : input_stream.GetImage();
          if (curChar == '\n' || curChar == '\r') {
            error_line++;
            error_column = 0;
          } else
            error_column++;
        }
        if (!EOFSeen) {
          input_stream.backup(1);
          error_after = curPos <= 1 ? "" : input_stream.GetImage();
        }
        throw new TokenMgrError(EOFSeen, curLexState, error_line, error_column, error_after, curChar, TokenMgrError.LEXICAL_ERROR);
      }
    }
  }

  void MoreLexicalActions() {
    jjimageLen += (lengthOfMatch = jjmatchedPos + 1);
    switch (jjmatchedKind) {
      case 69:
        if (image == null)
          image = new StringBuffer(new String(input_stream.GetSuffix(jjimageLen)));
        else
          image.append(input_stream.GetSuffix(jjimageLen));
        jjimageLen = 0;
        stringBuffer = new StringBuffer();
        break;
      case 70:
        if (image == null)
          image = new StringBuffer(new String(input_stream.GetSuffix(jjimageLen)));
        else
          image.append(input_stream.GetSuffix(jjimageLen));
        jjimageLen = 0;
        stringBuffer = new StringBuffer();
        break;
      case 71:
        if (image == null)
          image = new StringBuffer(new String(input_stream.GetSuffix(jjimageLen)));
        else
          image.append(input_stream.GetSuffix(jjimageLen));
        jjimageLen = 0;
        charValue = escapeChar();
        stringBuffer.append(charValue);
        break;
      case 72:
        if (image == null)
          image = new StringBuffer(new String(input_stream.GetSuffix(jjimageLen)));
        else
          image.append(input_stream.GetSuffix(jjimageLen));
        jjimageLen = 0;
        charValue = image.charAt(image.length() - 1);
        stringBuffer.append(charValue);
        break;
      case 74:
        if (image == null)
          image = new StringBuffer(new String(input_stream.GetSuffix(jjimageLen)));
        else
          image.append(input_stream.GetSuffix(jjimageLen));
        jjimageLen = 0;
        charValue = escapeChar();
        break;
      case 75:
        if (image == null)
          image = new StringBuffer(new String(input_stream.GetSuffix(jjimageLen)));
        else
          image.append(input_stream.GetSuffix(jjimageLen));
        jjimageLen = 0;
        charValue = image.charAt(image.length() - 1);
        break;
      case 77:
        if (image == null)
          image = new StringBuffer(new String(input_stream.GetSuffix(jjimageLen)));
        else
          image.append(input_stream.GetSuffix(jjimageLen));
        jjimageLen = 0;
        stringBuffer.append(escapeChar());
        break;
      case 78:
        if (image == null)
          image = new StringBuffer(new String(input_stream.GetSuffix(jjimageLen)));
        else
          image.append(input_stream.GetSuffix(jjimageLen));
        jjimageLen = 0;
        stringBuffer.append(image.charAt(image.length() - 1));
        break;
      default:
        break;
    }
  }

  void TokenLexicalActions(Token matchedToken) {
    switch (jjmatchedKind) {
      case 67:
        if (image == null)
          image = new StringBuffer(new String(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1))));
        else
          image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
        switch (image.charAt(1)) {
          case '^':
            literalValue = DynamicSubscript.first;
            break;
          case '|':
            literalValue = DynamicSubscript.mid;
            break;
          case '$':
            literalValue = DynamicSubscript.last;
            break;
          case '*':
            literalValue = DynamicSubscript.all;
            break;
        }
        break;
      case 73:
        if (image == null)
          image = new StringBuffer(new String(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1))));
        else
          image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
        if (stringBuffer.length() == 1) {
          literalValue = new Character(charValue);
        } else {
          literalValue = new String(stringBuffer);
        }
        break;
      case 76:
        if (image == null)
          image = new StringBuffer(new String(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1))));
        else
          image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
        literalValue = new Character(charValue);
        break;
      case 79:
        if (image == null)
          image = new StringBuffer(new String(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1))));
        else
          image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
        literalValue = new String(stringBuffer);
        break;
      case 80:
        if (image == null)
          image = new StringBuffer(new String(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1))));
        else
          image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
        literalValue =
            makeInt();
        break;
      case 81:
        if (image == null)
          image = new StringBuffer(new String(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1))));
        else
          image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
        literalValue = makeFloat();
        break;
      default:
        break;
    }
  }
}
