package org.apache.ibatis.reflection;

import java.lang.reflect.*;

public class ExceptionUtil {

  public static Throwable unwrapThrowable(Throwable wrapped) {
    Throwable unwrapped = wrapped;
    while (true) {
      if (unwrapped instanceof InvocationTargetException) {
        unwrapped = ((InvocationTargetException) wrapped).getTargetException();
      } else if (unwrapped instanceof UndeclaredThrowableException) {
        unwrapped = ((UndeclaredThrowableException) wrapped).getUndeclaredThrowable();
      } else {
        return unwrapped;
      }
    }
  }

}
