/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.sqlmap.engine.mapper.matcher;

import com.ibatis.sqlmap.engine.mapper.matcher.Canonicalizer;
import com.ibatis.sqlmap.engine.mapper.matcher.Match;
import com.ibatis.sqlmap.engine.mapper.matcher.MatchCalculator;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class NameMatcher {
    public Map matchNames(String[] properties, String[] fields) {
        Map propertyMap = this.invertMap(this.buildCanonicalMap(properties));
        Map fieldMap = this.invertMap(this.buildCanonicalMap(fields));
        String[] canonicalProperties = this.setToStringArray(propertyMap.keySet());
        String[] canonicalFields = this.setToStringArray(fieldMap.keySet());
        List matchList = this.buildMatchList(canonicalProperties, canonicalFields);
        HashMap<String, String> matchedNames = new HashMap<String, String>();
        Iterator matches = matchList.iterator();
        while (matches.hasNext()) {
            Match match = (Match)matches.next();
            String property = (String)propertyMap.get(match.getProperty());
            String field = (String)fieldMap.get(match.getField());
            matchedNames.put(property, field);
        }
        return matchedNames;
    }

    private Map buildCanonicalMap(String[] properties) {
        return new Canonicalizer().buildCanonicalMap(properties);
    }

    private String[] setToStringArray(Set set) {
        return set.toArray(new String[set.size()]);
    }

    private List buildMatchList(String[] canonicalProperties, String[] canonicalFields) {
        LinkedList<Match> matchList = new LinkedList<Match>();
        MatchCalculator calc = new MatchCalculator();
        for (int i = 0; i < canonicalProperties.length; ++i) {
            for (int j = 0; j < canonicalFields.length; ++j) {
                String prop = canonicalProperties[i];
                String field = canonicalFields[j];
                double score = calc.calculateMatch(prop, field);
                Match match = new Match(prop, field, score);
                matchList.add(match);
            }
        }
        this.sortMatches(matchList);
        this.removeDuplicatesAndLowScores(matchList);
        return matchList;
    }

    private void removeDuplicatesAndLowScores(List matchList) {
        HashSet<String> usedProperties = new HashSet<String>();
        HashSet<String> usedFields = new HashSet<String>();
        Iterator i = matchList.iterator();
        while (i.hasNext()) {
            Match m = (Match)i.next();
            if (usedProperties.contains(m.getProperty()) || usedFields.contains(m.getField()) || m.getMatchScore() < 0.4) {
                i.remove();
                continue;
            }
            usedProperties.add(m.getProperty());
            usedFields.add(m.getField());
        }
    }

    private void sortMatches(List matchList) {
        Collections.sort(matchList, new Comparator(){

            public int compare(Object o1, Object o2) {
                Match m1 = (Match)o1;
                Match m2 = (Match)o2;
                return m1.getMatchScore() < m2.getMatchScore() ? 1 : (m1.getMatchScore() > m2.getMatchScore() ? -1 : 0);
            }
        });
    }

    private Map invertMap(Map original) {
        HashMap inverse = new HashMap();
        Iterator keys = original.keySet().iterator();
        while (keys.hasNext()) {
            Object key = keys.next();
            Object value = original.get(key);
            inverse.put(value, key);
        }
        return inverse;
    }
}

