/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.license;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;

public class MachineInfo {
    private List<String> ipAddressList = null;
    private List<String> macAddressList = null;

    public List<String> getIpAddress() {
        if (this.ipAddressList != null) {
            return this.ipAddressList;
        }
        this.ipAddressList = new ArrayList<String>();
        List<InetAddress> inetAddresses = this.getLocalAllInetAddress();
        if (inetAddresses != null && !inetAddresses.isEmpty()) {
            this.ipAddressList = inetAddresses.stream().map(InetAddress::getHostAddress).distinct().map(String::toLowerCase).collect(Collectors.toList());
        }
        return this.ipAddressList;
    }

    public List<String> getMacAddress() {
        if (this.macAddressList != null) {
            return this.macAddressList;
        }
        this.macAddressList = new ArrayList<String>();
        List<InetAddress> inetAddresses = this.getLocalAllInetAddress();
        if (inetAddresses != null && !inetAddresses.isEmpty()) {
            ArrayList<String> list = new ArrayList<String>();
            HashSet<String> uniqueValues = new HashSet<String>();
            for (InetAddress inetAddress : inetAddresses) {
                String macByInetAddress = this.getMacByInetAddress(inetAddress);
                if (!uniqueValues.add(macByInetAddress)) continue;
                list.add(macByInetAddress);
            }
            this.macAddressList = list;
        }
        return this.macAddressList;
    }

    public List<InetAddress> getLocalAllInetAddress() {
        Enumeration<NetworkInterface> interfaces;
        try {
            interfaces = NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException e) {
            throw new RuntimeException("Failed to get network interfaces");
        }
        ArrayList<InetAddress> result = new ArrayList<InetAddress>();
        while (interfaces.hasMoreElements()) {
            NetworkInterface nw = interfaces.nextElement();
            Enumeration<InetAddress> inetAddresses = nw.getInetAddresses();
            while (inetAddresses.hasMoreElements()) {
                InetAddress inetAddr = inetAddresses.nextElement();
                if (inetAddr.isLoopbackAddress() || inetAddr.isLinkLocalAddress() || inetAddr.isMulticastAddress()) continue;
                result.add(inetAddr);
            }
        }
        return result;
    }

    public String getMacByInetAddress(InetAddress inetAddr) {
        byte[] mac;
        try {
            mac = NetworkInterface.getByInetAddress(inetAddr).getHardwareAddress();
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Failed to get mac address for inet address '%s'", inetAddr));
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < mac.length; ++i) {
            String temp;
            if (i != 0) {
                sb.append("-");
            }
            if ((temp = Integer.toHexString(mac[i] & 0xFF)).length() == 1) {
                sb.append("0").append(temp);
                continue;
            }
            sb.append(temp);
        }
        return sb.toString().toUpperCase();
    }
}

