/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.entity.mime.content;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Map;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.james.mime4j.message.AbstractBody;
import org.apache.james.mime4j.message.BinaryBody;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InputStreamBody
extends AbstractBody
implements BinaryBody,
ContentBody {
    private final InputStream in;
    private final String filename;

    public InputStreamBody(InputStream in, String filename) {
        if (in == null) {
            throw new IllegalArgumentException("Input stream may not be null");
        }
        this.in = in;
        this.filename = filename;
    }

    public InputStream getInputStream() throws IOException {
        return this.in;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTo(OutputStream out, int mode) throws IOException {
        if (out == null) {
            throw new IllegalArgumentException("Output stream may not be null");
        }
        try {
            int l;
            byte[] tmp = new byte[4096];
            while ((l = this.in.read(tmp)) != -1) {
                out.write(tmp, 0, l);
            }
            out.flush();
        }
        finally {
            this.in.close();
        }
    }

    public String getTransferEncoding() {
        return "binary";
    }

    public String getCharset() {
        return null;
    }

    public String getMimeType() {
        return "application/octet-stream";
    }

    public Map<?, ?> getContentTypeParameters() {
        return Collections.EMPTY_MAP;
    }

    public String getMediaType() {
        return "application";
    }

    public String getSubType() {
        return "octet-stream";
    }

    public long getContentLength() {
        return -1L;
    }

    @Override
    public String getFilename() {
        return this.filename;
    }
}

