/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.conn.ssl;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.apache.http.HttpHost;
import org.apache.http.annotation.ThreadSafe;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.conn.HttpInetSocketAddress;
import org.apache.http.conn.scheme.HostNameResolver;
import org.apache.http.conn.scheme.LayeredSchemeSocketFactory;
import org.apache.http.conn.scheme.LayeredSocketFactory;
import org.apache.http.conn.scheme.SchemeLayeredSocketFactory;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.AllowAllHostnameVerifier;
import org.apache.http.conn.ssl.BrowserCompatHostnameVerifier;
import org.apache.http.conn.ssl.SSLInitializationException;
import org.apache.http.conn.ssl.StrictHostnameVerifier;
import org.apache.http.conn.ssl.TrustManagerDecorator;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.Args;
import org.apache.http.util.Asserts;

@ThreadSafe
public class SSLSocketFactory
implements LayeredConnectionSocketFactory,
SchemeLayeredSocketFactory,
LayeredSchemeSocketFactory,
LayeredSocketFactory {
    public static final String TLS = "TLS";
    public static final String SSL = "SSL";
    public static final String SSLV2 = "SSLv2";
    public static final X509HostnameVerifier ALLOW_ALL_HOSTNAME_VERIFIER = new AllowAllHostnameVerifier();
    public static final X509HostnameVerifier BROWSER_COMPATIBLE_HOSTNAME_VERIFIER = new BrowserCompatHostnameVerifier();
    public static final X509HostnameVerifier STRICT_HOSTNAME_VERIFIER = new StrictHostnameVerifier();
    private static final char[] EMPTY_PASSWORD = "".toCharArray();
    private final javax.net.ssl.SSLSocketFactory socketfactory;
    private final HostNameResolver nameResolver;
    private volatile X509HostnameVerifier hostnameVerifier;

    public static SSLSocketFactory getSocketFactory() throws SSLInitializationException {
        return new SSLSocketFactory(SSLSocketFactory.createDefaultSSLContext());
    }

    public static SSLSocketFactory getSystemSocketFactory() throws SSLInitializationException {
        return new SSLSocketFactory(SSLSocketFactory.createSystemSSLContext());
    }

    private static SSLContext createSSLContext(String algorithm, KeyStore keystore, String keystorePassword, KeyStore truststore, SecureRandom random, TrustStrategy trustStrategy) throws NoSuchAlgorithmException, KeyStoreException, UnrecoverableKeyException, KeyManagementException {
        if (algorithm == null) {
            algorithm = TLS;
        }
        KeyManagerFactory kmfactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        kmfactory.init(keystore, keystorePassword != null ? keystorePassword.toCharArray() : null);
        KeyManager[] keymanagers = kmfactory.getKeyManagers();
        TrustManagerFactory tmfactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        tmfactory.init(truststore);
        TrustManager[] trustmanagers = tmfactory.getTrustManagers();
        if (trustmanagers != null && trustStrategy != null) {
            for (int i = 0; i < trustmanagers.length; ++i) {
                TrustManager tm = trustmanagers[i];
                if (!(tm instanceof X509TrustManager)) continue;
                trustmanagers[i] = new TrustManagerDecorator((X509TrustManager)tm, trustStrategy);
            }
        }
        SSLContext sslcontext = SSLContext.getInstance(algorithm);
        sslcontext.init(keymanagers, trustmanagers, random);
        return sslcontext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static SSLContext createSystemSSLContext(String algorithm, SecureRandom random) throws IOException, NoSuchAlgorithmException, NoSuchProviderException, KeyStoreException, CertificateException, UnrecoverableKeyException, KeyManagementException {
        String keyStoreType;
        String trustStoreType;
        if (algorithm == null) {
            algorithm = TLS;
        }
        TrustManagerFactory tmfactory = null;
        String trustAlgorithm = System.getProperty("ssl.TrustManagerFactory.algorithm");
        if (trustAlgorithm == null) {
            trustAlgorithm = TrustManagerFactory.getDefaultAlgorithm();
        }
        if ((trustStoreType = System.getProperty("javax.net.ssl.trustStoreType")) == null) {
            trustStoreType = KeyStore.getDefaultType();
        }
        if ("none".equalsIgnoreCase(trustStoreType)) {
            tmfactory = TrustManagerFactory.getInstance(trustAlgorithm);
        } else {
            File trustStoreFile = null;
            String s = System.getProperty("javax.net.ssl.trustStore");
            if (s != null) {
                trustStoreFile = new File(s);
                tmfactory = TrustManagerFactory.getInstance(trustAlgorithm);
                String trustStoreProvider = System.getProperty("javax.net.ssl.trustStoreProvider");
                KeyStore trustStore = trustStoreProvider != null ? KeyStore.getInstance(trustStoreType, trustStoreProvider) : KeyStore.getInstance(trustStoreType);
                String trustStorePassword = System.getProperty("javax.net.ssl.trustStorePassword");
                FileInputStream instream = new FileInputStream(trustStoreFile);
                try {
                    trustStore.load(instream, trustStorePassword != null ? trustStorePassword.toCharArray() : EMPTY_PASSWORD);
                }
                finally {
                    instream.close();
                }
                tmfactory.init(trustStore);
            } else {
                File javaHome = new File(System.getProperty("java.home"));
                File file = new File(javaHome, "lib/security/jssecacerts");
                trustStoreFile = !file.exists() ? (file = new File(javaHome, "lib/security/cacerts")) : file;
                tmfactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                KeyStore trustStore = KeyStore.getInstance(KeyStore.getDefaultType());
                String trustStorePassword = System.getProperty("javax.net.ssl.trustStorePassword");
                FileInputStream instream = new FileInputStream(trustStoreFile);
                try {
                    trustStore.load(instream, trustStorePassword != null ? trustStorePassword.toCharArray() : null);
                }
                finally {
                    instream.close();
                }
                tmfactory.init(trustStore);
            }
        }
        KeyManagerFactory kmfactory = null;
        String keyAlgorithm = System.getProperty("ssl.KeyManagerFactory.algorithm");
        if (keyAlgorithm == null) {
            keyAlgorithm = KeyManagerFactory.getDefaultAlgorithm();
        }
        if ((keyStoreType = System.getProperty("javax.net.ssl.keyStoreType")) == null) {
            keyStoreType = KeyStore.getDefaultType();
        }
        if ("none".equalsIgnoreCase(keyStoreType)) {
            kmfactory = KeyManagerFactory.getInstance(keyAlgorithm);
        } else {
            File keyStoreFile = null;
            String s = System.getProperty("javax.net.ssl.keyStore");
            if (s != null) {
                keyStoreFile = new File(s);
            }
            if (keyStoreFile != null) {
                kmfactory = KeyManagerFactory.getInstance(keyAlgorithm);
                String keyStoreProvider = System.getProperty("javax.net.ssl.keyStoreProvider");
                KeyStore keyStore = keyStoreProvider != null ? KeyStore.getInstance(keyStoreType, keyStoreProvider) : KeyStore.getInstance(keyStoreType);
                String keyStorePassword = System.getProperty("javax.net.ssl.keyStorePassword");
                FileInputStream instream = new FileInputStream(keyStoreFile);
                try {
                    keyStore.load(instream, keyStorePassword != null ? keyStorePassword.toCharArray() : EMPTY_PASSWORD);
                }
                finally {
                    instream.close();
                }
                kmfactory.init(keyStore, keyStorePassword != null ? keyStorePassword.toCharArray() : EMPTY_PASSWORD);
            }
        }
        SSLContext sslcontext = SSLContext.getInstance(algorithm);
        sslcontext.init(kmfactory != null ? kmfactory.getKeyManagers() : null, tmfactory != null ? tmfactory.getTrustManagers() : null, random);
        return sslcontext;
    }

    public static SSLContext createDefaultSSLContext() throws SSLInitializationException {
        try {
            return SSLSocketFactory.createSSLContext(TLS, null, null, null, null, null);
        }
        catch (Exception ex) {
            throw new SSLInitializationException("Failure initializing default SSL context", ex);
        }
    }

    public static SSLContext createSystemSSLContext() throws SSLInitializationException {
        try {
            return SSLSocketFactory.createSystemSSLContext(TLS, null);
        }
        catch (Exception ex) {
            throw new SSLInitializationException("Failure initializing default system SSL context", ex);
        }
    }

    @Deprecated
    public SSLSocketFactory(String algorithm, KeyStore keystore, String keystorePassword, KeyStore truststore, SecureRandom random, HostNameResolver nameResolver) throws NoSuchAlgorithmException, KeyManagementException, KeyStoreException, UnrecoverableKeyException {
        this(SSLSocketFactory.createSSLContext(algorithm, keystore, keystorePassword, truststore, random, null), nameResolver);
    }

    public SSLSocketFactory(String algorithm, KeyStore keystore, String keystorePassword, KeyStore truststore, SecureRandom random, X509HostnameVerifier hostnameVerifier) throws NoSuchAlgorithmException, KeyManagementException, KeyStoreException, UnrecoverableKeyException {
        this(SSLSocketFactory.createSSLContext(algorithm, keystore, keystorePassword, truststore, random, null), hostnameVerifier);
    }

    public SSLSocketFactory(String algorithm, KeyStore keystore, String keystorePassword, KeyStore truststore, SecureRandom random, TrustStrategy trustStrategy, X509HostnameVerifier hostnameVerifier) throws NoSuchAlgorithmException, KeyManagementException, KeyStoreException, UnrecoverableKeyException {
        this(SSLSocketFactory.createSSLContext(algorithm, keystore, keystorePassword, truststore, random, trustStrategy), hostnameVerifier);
    }

    public SSLSocketFactory(KeyStore keystore, String keystorePassword, KeyStore truststore) throws NoSuchAlgorithmException, KeyManagementException, KeyStoreException, UnrecoverableKeyException {
        this(TLS, keystore, keystorePassword, truststore, null, null, BROWSER_COMPATIBLE_HOSTNAME_VERIFIER);
    }

    public SSLSocketFactory(KeyStore keystore, String keystorePassword) throws NoSuchAlgorithmException, KeyManagementException, KeyStoreException, UnrecoverableKeyException {
        this(TLS, keystore, keystorePassword, null, null, null, BROWSER_COMPATIBLE_HOSTNAME_VERIFIER);
    }

    public SSLSocketFactory(KeyStore truststore) throws NoSuchAlgorithmException, KeyManagementException, KeyStoreException, UnrecoverableKeyException {
        this(TLS, null, null, truststore, null, null, BROWSER_COMPATIBLE_HOSTNAME_VERIFIER);
    }

    public SSLSocketFactory(TrustStrategy trustStrategy, X509HostnameVerifier hostnameVerifier) throws NoSuchAlgorithmException, KeyManagementException, KeyStoreException, UnrecoverableKeyException {
        this(TLS, null, null, null, null, trustStrategy, hostnameVerifier);
    }

    public SSLSocketFactory(TrustStrategy trustStrategy) throws NoSuchAlgorithmException, KeyManagementException, KeyStoreException, UnrecoverableKeyException {
        this(TLS, null, null, null, null, trustStrategy, BROWSER_COMPATIBLE_HOSTNAME_VERIFIER);
    }

    public SSLSocketFactory(SSLContext sslContext) {
        this(sslContext, BROWSER_COMPATIBLE_HOSTNAME_VERIFIER);
    }

    @Deprecated
    public SSLSocketFactory(SSLContext sslContext, HostNameResolver nameResolver) {
        this.socketfactory = sslContext.getSocketFactory();
        this.hostnameVerifier = BROWSER_COMPATIBLE_HOSTNAME_VERIFIER;
        this.nameResolver = nameResolver;
    }

    public SSLSocketFactory(SSLContext sslContext, X509HostnameVerifier hostnameVerifier) {
        Args.notNull((Object)sslContext, (String)"SSL context");
        this.socketfactory = sslContext.getSocketFactory();
        this.hostnameVerifier = hostnameVerifier;
        this.nameResolver = null;
    }

    public SSLSocketFactory(javax.net.ssl.SSLSocketFactory socketfactory, X509HostnameVerifier hostnameVerifier) {
        Args.notNull((Object)socketfactory, (String)"SSL socket factory");
        this.socketfactory = socketfactory;
        this.hostnameVerifier = hostnameVerifier;
        this.nameResolver = null;
    }

    @Deprecated
    public Socket createSocket(HttpParams params) throws IOException {
        return this.createSocket((HttpContext)null);
    }

    @Deprecated
    public Socket createSocket() throws IOException {
        return this.createSocket((HttpContext)null);
    }

    @Deprecated
    public Socket connectSocket(Socket socket, InetSocketAddress remoteAddress, InetSocketAddress localAddress, HttpParams params) throws IOException, UnknownHostException, ConnectTimeoutException {
        Args.notNull((Object)remoteAddress, (String)"Remote address");
        Args.notNull((Object)params, (String)"HTTP parameters");
        HttpHost host = remoteAddress instanceof HttpInetSocketAddress ? ((HttpInetSocketAddress)remoteAddress).getHttpHost() : new HttpHost(remoteAddress.getHostName(), remoteAddress.getPort(), "https");
        int connectTimeout = HttpConnectionParams.getConnectionTimeout((HttpParams)params);
        return this.connectSocket(connectTimeout, socket, host, remoteAddress, localAddress, null);
    }

    @Deprecated
    public boolean isSecure(Socket sock) throws IllegalArgumentException {
        Args.notNull((Object)sock, (String)"Socket");
        Asserts.check((boolean)(sock instanceof SSLSocket), (String)"Socket not created by this factory");
        Asserts.check((!sock.isClosed() ? 1 : 0) != 0, (String)"Socket is closed");
        return true;
    }

    @Deprecated
    public Socket createLayeredSocket(Socket socket, String host, int port, HttpParams params) throws IOException, UnknownHostException {
        return this.createLayeredSocket(socket, host, port, (HttpContext)null);
    }

    @Deprecated
    public Socket createLayeredSocket(Socket socket, String host, int port, boolean autoClose) throws IOException, UnknownHostException {
        return this.createLayeredSocket(socket, host, port, (HttpContext)null);
    }

    @Deprecated
    public void setHostnameVerifier(X509HostnameVerifier hostnameVerifier) {
        Args.notNull((Object)hostnameVerifier, (String)"Hostname verifier");
        this.hostnameVerifier = hostnameVerifier;
    }

    public X509HostnameVerifier getHostnameVerifier() {
        return this.hostnameVerifier;
    }

    @Deprecated
    public Socket connectSocket(Socket socket, String host, int port, InetAddress local, int localPort, HttpParams params) throws IOException, UnknownHostException, ConnectTimeoutException {
        InetAddress remote = this.nameResolver != null ? this.nameResolver.resolve(host) : InetAddress.getByName(host);
        InetSocketAddress localAddress = null;
        if (local != null || localPort > 0) {
            if (localPort < 0) {
                localPort = 0;
            }
            localAddress = new InetSocketAddress(local, localPort);
        }
        HttpInetSocketAddress remoteAddress = new HttpInetSocketAddress(new HttpHost(host, port), remote, port);
        return this.connectSocket(socket, remoteAddress, localAddress, params);
    }

    @Deprecated
    public Socket createSocket(Socket socket, String host, int port, boolean autoClose) throws IOException, UnknownHostException {
        return this.createLayeredSocket(socket, host, port, autoClose);
    }

    protected void prepareSocket(SSLSocket socket) throws IOException {
    }

    public Socket createSocket(HttpContext context) throws IOException {
        SSLSocket sock = (SSLSocket)this.socketfactory.createSocket();
        this.prepareSocket(sock);
        return sock;
    }

    public Socket connectSocket(int connectTimeout, Socket socket, HttpHost host, InetSocketAddress remoteAddress, InetSocketAddress localAddress, HttpContext context) throws IOException, ConnectTimeoutException {
        Socket sock;
        Args.notNull((Object)host, (String)"HTTP host");
        Args.notNull((Object)remoteAddress, (String)"Remote address");
        Socket socket2 = sock = socket != null ? socket : this.createSocket(context);
        if (localAddress != null) {
            sock.bind(localAddress);
        }
        try {
            sock.connect(remoteAddress, connectTimeout);
        }
        catch (SocketTimeoutException ex) {
            throw new ConnectTimeoutException(host, remoteAddress);
        }
        if (sock instanceof SSLSocket) {
            this.verifyHostname((SSLSocket)sock, host.getHostName());
        } else {
            sock = this.createLayeredSocket(sock, host.getHostName(), remoteAddress.getPort(), context);
        }
        return sock;
    }

    public Socket createLayeredSocket(Socket socket, String target, int port, HttpContext context) throws IOException, UnknownHostException {
        SSLSocket sslSocket = (SSLSocket)this.socketfactory.createSocket(socket, target, port, true);
        this.prepareSocket(sslSocket);
        this.verifyHostname(sslSocket, target);
        return sslSocket;
    }

    private void verifyHostname(SSLSocket sslsock, String hostname) throws IOException {
        if (this.hostnameVerifier != null) {
            try {
                this.hostnameVerifier.verify(hostname, sslsock);
            }
            catch (IOException iox) {
                try {
                    sslsock.close();
                }
                catch (Exception x) {
                    // empty catch block
                }
                throw iox;
            }
        }
    }
}

