/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.conn.util;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SocketUtils {
    public static void connect(Socket sock, String hostname, int port, int timeout) throws IOException {
        InetAddress[] adrs = InetAddress.getAllByName(hostname);
        ArrayList<InetAddress> list = new ArrayList<InetAddress>(adrs.length);
        for (InetAddress adr : adrs) {
            list.add(adr);
        }
        Collections.shuffle(list);
        SocketUtils.connect(sock, list, port, timeout);
    }

    public static void connect(Socket sock, List<InetAddress> addresses, int port, int timeout) throws IOException {
        if (sock == null) {
            throw new IllegalArgumentException("Socket may not be null");
        }
        if (addresses == null) {
            throw new IllegalArgumentException("List of addresses may not be null");
        }
        if (addresses.isEmpty()) {
            throw new IllegalArgumentException("List of addresses may not be empty");
        }
        IOException lastEx = null;
        for (InetAddress address : addresses) {
            try {
                sock.connect(new InetSocketAddress(address, port), timeout);
                return;
            }
            catch (SocketTimeoutException ex) {
                throw ex;
            }
            catch (IOException ex) {
                lastEx = ex;
            }
        }
        if (lastEx != null) {
            throw lastEx;
        }
    }
}

