/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.conn.tsccm;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpConnection;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.ClientConnectionOperator;
import org.apache.http.conn.ConnectionPoolTimeoutException;
import org.apache.http.conn.HttpRoute;
import org.apache.http.conn.params.HttpConnectionManagerParams;
import org.apache.http.impl.conn.tsccm.AbstractConnPool;
import org.apache.http.impl.conn.tsccm.BasicPoolEntry;
import org.apache.http.impl.conn.tsccm.RouteSpecificPool;

public class ConnPoolByRoute
extends AbstractConnPool {
    private final Log LOG = LogFactory.getLog((Class)ConnPoolByRoute.class);
    private LinkedList freeConnections = new LinkedList();
    private LinkedList waitingThreads = new LinkedList();
    private final Map routeToPool = new HashMap();

    public ConnPoolByRoute(ClientConnectionManager mgr) {
        super(mgr);
    }

    protected synchronized RouteSpecificPool getRoutePool(HttpRoute route, boolean create) {
        RouteSpecificPool rospl = (RouteSpecificPool)this.routeToPool.get(route);
        if (rospl == null && create) {
            rospl = this.newRouteSpecificPool(route);
            this.routeToPool.put(route, rospl);
        }
        return rospl;
    }

    protected RouteSpecificPool newRouteSpecificPool(HttpRoute route) {
        return new RouteSpecificPool(route);
    }

    public synchronized int getConnectionsInPool(HttpRoute route) {
        RouteSpecificPool rospl = this.getRoutePool(route, false);
        return rospl != null ? rospl.getEntryCount() : 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized BasicPoolEntry getEntry(HttpRoute route, long timeout, ClientConnectionOperator operator) throws ConnectionPoolTimeoutException, InterruptedException {
        BasicPoolEntry entry = null;
        int maxHostConnections = HttpConnectionManagerParams.getMaxConnectionsPerHost(this.params, route);
        int maxTotalConnections = HttpConnectionManagerParams.getMaxTotalConnections(this.params);
        RouteSpecificPool rospl = this.getRoutePool(route, true);
        WaitingThread waitingThread = null;
        boolean useTimeout = timeout > 0L;
        long timeToWait = timeout;
        long startWait = 0L;
        long endWait = 0L;
        while (entry == null) {
            block16: {
                if (this.isShutDown) {
                    throw new IllegalStateException("Connection pool shut down.");
                }
                entry = this.getFreeEntry(rospl);
                if (entry != null) continue;
                if (rospl.getEntryCount() < maxHostConnections && this.numConnections < maxTotalConnections) {
                    entry = this.createEntry(rospl, operator);
                    continue;
                }
                if (rospl.getEntryCount() < maxHostConnections && this.freeConnections.size() > 0) {
                    this.deleteLeastUsedEntry();
                    entry = this.createEntry(rospl, operator);
                    continue;
                }
                try {
                    if (useTimeout && timeToWait <= 0L) {
                        throw new ConnectionPoolTimeoutException("Timeout waiting for connection");
                    }
                    if (this.LOG.isDebugEnabled()) {
                        this.LOG.debug((Object)("Need to wait for connection. " + route));
                    }
                    if (waitingThread == null) {
                        waitingThread = new WaitingThread();
                        waitingThread.pool = rospl;
                        waitingThread.thread = Thread.currentThread();
                    } else {
                        waitingThread.interruptedByConnectionPool = false;
                    }
                    if (useTimeout) {
                        startWait = System.currentTimeMillis();
                    }
                    rospl.waitingThreads.addLast(waitingThread);
                    this.waitingThreads.addLast(waitingThread);
                    this.wait(timeToWait);
                    if (waitingThread.interruptedByConnectionPool) break block16;
                    rospl.waitingThreads.remove(waitingThread);
                }
                catch (InterruptedException e) {
                    block17: {
                        try {
                            if (!waitingThread.interruptedByConnectionPool) {
                                this.LOG.debug((Object)"Interrupted while waiting for connection.", (Throwable)e);
                                throw e;
                            }
                            if (waitingThread.interruptedByConnectionPool) break block17;
                            rospl.waitingThreads.remove(waitingThread);
                        }
                        catch (Throwable throwable) {
                            if (!waitingThread.interruptedByConnectionPool) {
                                rospl.waitingThreads.remove(waitingThread);
                                this.waitingThreads.remove(waitingThread);
                            }
                            if (useTimeout) {
                                endWait = System.currentTimeMillis();
                                timeToWait -= endWait - startWait;
                            }
                            throw throwable;
                        }
                        this.waitingThreads.remove(waitingThread);
                    }
                    if (!useTimeout) continue;
                    endWait = System.currentTimeMillis();
                    timeToWait -= endWait - startWait;
                    continue;
                }
                this.waitingThreads.remove(waitingThread);
            }
            if (!useTimeout) continue;
            endWait = System.currentTimeMillis();
            timeToWait -= endWait - startWait;
        }
        return entry;
    }

    public synchronized void freeEntry(BasicPoolEntry entry) {
        HttpRoute route = entry.getPlannedRoute();
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug((Object)("Freeing connection. " + route));
        }
        if (this.isShutDown) {
            this.closeConnection(entry.getConnection());
            return;
        }
        this.issuedConnections.remove(entry.getWeakRef());
        RouteSpecificPool rospl = this.getRoutePool(route, true);
        rospl.freeEntry(entry);
        this.freeConnections.add(entry);
        if (this.numConnections == 0) {
            this.LOG.error((Object)("Master connection pool not found. " + route));
            this.numConnections = 1;
        }
        this.idleConnHandler.add((HttpConnection)entry.getConnection());
        this.notifyWaitingThread(rospl);
    }

    protected synchronized BasicPoolEntry getFreeEntry(RouteSpecificPool rospl) {
        BasicPoolEntry entry = rospl.allocEntry();
        if (entry != null) {
            if (this.LOG.isDebugEnabled()) {
                this.LOG.debug((Object)("Getting free connection. " + rospl.getRoute()));
            }
            this.freeConnections.remove(entry);
            this.idleConnHandler.remove((HttpConnection)entry.getConnection());
            this.issuedConnections.add(entry.getWeakRef());
        } else if (this.LOG.isDebugEnabled()) {
            this.LOG.debug((Object)("No free connections. " + rospl.getRoute()));
        }
        return entry;
    }

    protected synchronized BasicPoolEntry createEntry(RouteSpecificPool rospl, ClientConnectionOperator op) {
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug((Object)("Creating new connection. " + rospl.getRoute()));
        }
        BasicPoolEntry entry = new BasicPoolEntry(op, rospl.getRoute(), this.refQueue);
        rospl.createdEntry(entry);
        ++this.numConnections;
        this.issuedConnections.add(entry.getWeakRef());
        return entry;
    }

    protected synchronized void deleteEntry(BasicPoolEntry entry) {
        HttpRoute route = entry.getPlannedRoute();
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug((Object)("Deleting connection. " + route));
        }
        this.closeConnection(entry.getConnection());
        RouteSpecificPool rospl = this.getRoutePool(route, true);
        rospl.deleteEntry(entry);
        --this.numConnections;
        if (rospl.isUnused()) {
            this.routeToPool.remove(route);
        }
        this.idleConnHandler.remove((HttpConnection)entry.getConnection());
    }

    protected synchronized void deleteLeastUsedEntry() {
        BasicPoolEntry entry = (BasicPoolEntry)this.freeConnections.removeFirst();
        if (entry != null) {
            this.deleteEntry(entry);
        } else if (this.LOG.isDebugEnabled()) {
            this.LOG.debug((Object)"No free connection to delete.");
        }
    }

    protected synchronized void handleLostEntry(HttpRoute route) {
        RouteSpecificPool rospl = this.getRoutePool(route, true);
        rospl.dropEntry();
        if (rospl.isUnused()) {
            this.routeToPool.remove(route);
        }
        --this.numConnections;
        this.notifyWaitingThread(rospl);
    }

    protected synchronized void notifyWaitingThread(RouteSpecificPool rospl) {
        WaitingThread waitingThread = null;
        if (rospl != null && !rospl.waitingThreads.isEmpty()) {
            if (this.LOG.isDebugEnabled()) {
                this.LOG.debug((Object)("Notifying thread waiting on pool. " + rospl.getRoute()));
            }
            waitingThread = (WaitingThread)rospl.waitingThreads.removeFirst();
            this.waitingThreads.remove(waitingThread);
        } else if (!this.waitingThreads.isEmpty()) {
            if (this.LOG.isDebugEnabled()) {
                this.LOG.debug((Object)"Notifying thread waiting on any pool.");
            }
            waitingThread = (WaitingThread)this.waitingThreads.removeFirst();
            waitingThread.pool.waitingThreads.remove(waitingThread);
        } else if (this.LOG.isDebugEnabled()) {
            this.LOG.debug((Object)"Notifying no-one, there are no waiting threads");
        }
        if (waitingThread != null) {
            waitingThread.interruptedByConnectionPool = true;
            waitingThread.thread.interrupt();
        }
    }

    public synchronized void deleteClosedConnections() {
        Iterator iter = this.freeConnections.iterator();
        while (iter.hasNext()) {
            BasicPoolEntry entry = (BasicPoolEntry)iter.next();
            if (entry.getConnection().isOpen()) continue;
            iter.remove();
            this.deleteEntry(entry);
        }
    }

    public synchronized void shutdown() {
        super.shutdown();
        Iterator iter = this.freeConnections.iterator();
        while (iter.hasNext()) {
            BasicPoolEntry entry = (BasicPoolEntry)iter.next();
            iter.remove();
            this.closeConnection(entry.getConnection());
        }
        iter = this.waitingThreads.iterator();
        while (iter.hasNext()) {
            WaitingThread waiter = (WaitingThread)iter.next();
            iter.remove();
            waiter.interruptedByConnectionPool = true;
            waiter.thread.interrupt();
        }
        this.routeToPool.clear();
    }

    protected static class WaitingThread {
        public Thread thread;
        public RouteSpecificPool pool;
        public boolean interruptedByConnectionPool = false;

        protected WaitingThread() {
        }
    }
}

