/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.cookie;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.http.cookie.CookieSpec;
import org.apache.http.cookie.CookieSpecFactory;
import org.apache.http.params.HttpParams;

public final class CookieSpecRegistry {
    private final Map registeredSpecs = new LinkedHashMap();

    public synchronized void register(String name, CookieSpecFactory factory) {
        if (name == null) {
            throw new IllegalArgumentException("Name may not be null");
        }
        if (factory == null) {
            throw new IllegalArgumentException("Cookie spec factory may not be null");
        }
        this.registeredSpecs.put(name.toLowerCase(), factory);
    }

    public synchronized void unregister(String id) {
        if (id == null) {
            throw new IllegalArgumentException("Id may not be null");
        }
        this.registeredSpecs.remove(id.toLowerCase());
    }

    public synchronized CookieSpec getCookieSpec(String name, HttpParams params) throws IllegalStateException {
        if (name == null) {
            throw new IllegalArgumentException("Name may not be null");
        }
        CookieSpecFactory factory = (CookieSpecFactory)this.registeredSpecs.get(name.toLowerCase());
        if (factory != null) {
            return factory.newInstance(params);
        }
        throw new IllegalStateException("Unsupported cookie spec: " + name);
    }

    public synchronized CookieSpec getCookieSpec(String name) throws IllegalStateException {
        return this.getCookieSpec(name, null);
    }

    public synchronized List getSpecNames() {
        return new ArrayList(this.registeredSpecs.keySet());
    }
}

