/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.auth.win;

import com.sun.jna.platform.win32.Secur32;
import com.sun.jna.platform.win32.Sspi;
import com.sun.jna.platform.win32.Win32Exception;
import com.sun.jna.ptr.IntByReference;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Header;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.annotation.NotThreadSafe;
import org.apache.http.auth.AuthenticationException;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.InvalidCredentialsException;
import org.apache.http.auth.MalformedChallengeException;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.conn.routing.RouteInfo;
import org.apache.http.impl.auth.AuthSchemeBase;
import org.apache.http.impl.auth.win.CurrentWindowsCredentials;
import org.apache.http.message.BufferedHeader;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.CharArrayBuffer;

@NotThreadSafe
public class WindowsNegotiateScheme
extends AuthSchemeBase {
    private final Log log = LogFactory.getLog(((Object)((Object)this)).getClass());
    private final String scheme;
    private final String servicePrincipalName;
    private Sspi.CredHandle clientCred;
    private Sspi.CtxtHandle sspiContext;
    private boolean continueNeeded;
    private String challenge;

    public WindowsNegotiateScheme(String scheme, String servicePrincipalName) {
        this.scheme = scheme == null ? "Negotiate" : scheme;
        this.challenge = null;
        this.continueNeeded = true;
        this.servicePrincipalName = servicePrincipalName;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Created WindowsNegotiateScheme using " + this.scheme));
        }
    }

    public void dispose() {
        int rc;
        if (this.clientCred != null && !this.clientCred.isNull() && 0 != (rc = Secur32.INSTANCE.FreeCredentialsHandle(this.clientCred))) {
            throw new Win32Exception(rc);
        }
        if (this.sspiContext != null && !this.sspiContext.isNull() && 0 != (rc = Secur32.INSTANCE.DeleteSecurityContext(this.sspiContext))) {
            throw new Win32Exception(rc);
        }
        this.continueNeeded = true;
        this.clientCred = null;
        this.sspiContext = null;
    }

    public void finalize() throws Throwable {
        this.dispose();
        super.finalize();
    }

    public String getSchemeName() {
        return this.scheme;
    }

    public String getParameter(String name) {
        return null;
    }

    public String getRealm() {
        return null;
    }

    public boolean isConnectionBased() {
        return true;
    }

    protected void parseChallenge(CharArrayBuffer buffer, int beginIndex, int endIndex) throws MalformedChallengeException {
        this.challenge = buffer.substringTrimmed(beginIndex, endIndex);
        if (this.challenge.isEmpty() && this.clientCred != null) {
            this.dispose();
            if (this.continueNeeded) {
                throw new RuntimeException("Unexpected token");
            }
        }
    }

    public Header authenticate(Credentials credentials, HttpRequest request, HttpContext context) throws AuthenticationException {
        String response;
        if (this.clientCred == null) {
            if (!(credentials instanceof CurrentWindowsCredentials)) {
                throw new InvalidCredentialsException("Credentials cannot be used for " + this.getSchemeName() + " authentication: " + credentials.getClass().getName());
            }
            try {
                String username = CurrentWindowsCredentials.getCurrentUsername();
                Sspi.TimeStamp lifetime = new Sspi.TimeStamp();
                this.clientCred = new Sspi.CredHandle();
                int rc = Secur32.INSTANCE.AcquireCredentialsHandle(username, this.scheme, 2, null, null, null, null, this.clientCred, lifetime);
                if (0 != rc) {
                    throw new Win32Exception(rc);
                }
                String targetName = this.getServicePrincipalName(context);
                response = this.getToken(null, null, targetName);
            }
            catch (RuntimeException ex) {
                this.failAuthCleanup();
                if (ex instanceof Win32Exception) {
                    throw new AuthenticationException("Authentication Failed", (Throwable)ex);
                }
                throw ex;
            }
        }
        if (this.challenge == null || this.challenge.isEmpty()) {
            this.failAuthCleanup();
            throw new AuthenticationException("Authentication Failed");
        }
        try {
            byte[] continueTokenBytes = Base64.decodeBase64((String)this.challenge);
            Sspi.SecBufferDesc continueTokenBuffer = new Sspi.SecBufferDesc(2, continueTokenBytes);
            String targetName = this.getServicePrincipalName(context);
            response = this.getToken(this.sspiContext, continueTokenBuffer, targetName);
        }
        catch (RuntimeException ex) {
            this.failAuthCleanup();
            if (ex instanceof Win32Exception) {
                throw new AuthenticationException("Authentication Failed", (Throwable)ex);
            }
            throw ex;
        }
        CharArrayBuffer buffer = new CharArrayBuffer(this.scheme.length() + 30);
        if (this.isProxy()) {
            buffer.append("Proxy-Authorization");
        } else {
            buffer.append("Authorization");
        }
        buffer.append(": ");
        buffer.append(this.scheme);
        buffer.append(" ");
        buffer.append(response);
        return new BufferedHeader(buffer);
    }

    private void failAuthCleanup() {
        this.dispose();
        this.continueNeeded = false;
    }

    private String getServicePrincipalName(HttpContext context) {
        RouteInfo route;
        HttpClientContext clientContext;
        HttpHost target;
        String spn = this.servicePrincipalName != null ? this.servicePrincipalName : ((target = (clientContext = HttpClientContext.adapt((HttpContext)context)).getTargetHost()) != null ? "HTTP/" + target.getHostName() : ((route = clientContext.getHttpRoute()) != null ? "HTTP/" + route.getTargetHost().getHostName() : null));
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Using SPN: " + spn));
        }
        return spn;
    }

    String getToken(Sspi.CtxtHandle continueCtx, Sspi.SecBufferDesc continueToken, String targetName) {
        IntByReference attr = new IntByReference();
        Sspi.SecBufferDesc token = new Sspi.SecBufferDesc(2, 12288);
        this.sspiContext = new Sspi.CtxtHandle();
        int rc = Secur32.INSTANCE.InitializeSecurityContext(this.clientCred, continueCtx, targetName, 3, 0, 16, continueToken, 0, this.sspiContext, token, attr, null);
        switch (rc) {
            case 590610: {
                this.continueNeeded = true;
                break;
            }
            case 0: {
                this.dispose();
                this.continueNeeded = false;
                break;
            }
            default: {
                this.dispose();
                throw new Win32Exception(rc);
            }
        }
        return Base64.encodeBase64String((byte[])token.getBytes());
    }

    public boolean isComplete() {
        return !this.continueNeeded;
    }

    @Deprecated
    public Header authenticate(Credentials credentials, HttpRequest request) throws AuthenticationException {
        return this.authenticate(credentials, request, null);
    }
}

