/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.nio.client.methods;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.UnsupportedCharsetException;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.nio.ContentDecoder;
import org.apache.http.nio.IOControl;
import org.apache.http.nio.protocol.AbstractAsyncResponseConsumer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AsyncCharConsumer<T>
extends AbstractAsyncResponseConsumer<T> {
    private final int bufSize;
    private ContentType contentType;
    private CharsetDecoder chardecoder;
    private ByteBuffer bbuf;
    private CharBuffer cbuf;

    public AsyncCharConsumer(int bufSize) {
        this.bufSize = bufSize;
    }

    public AsyncCharConsumer() {
        this(8192);
    }

    protected abstract void onCharReceived(CharBuffer var1, IOControl var2) throws IOException;

    protected final void onEntityEnclosed(HttpEntity entity, ContentType contentType) throws IOException {
        this.contentType = contentType != null ? contentType : ContentType.DEFAULT_TEXT;
        try {
            String cs = this.contentType.getCharset();
            if (cs == null) {
                cs = "ISO-8859-1";
            }
            Charset charset = Charset.forName(cs);
            this.chardecoder = charset.newDecoder();
        }
        catch (UnsupportedCharsetException ex) {
            throw new UnsupportedEncodingException(this.contentType.getCharset());
        }
        this.bbuf = ByteBuffer.allocate(this.bufSize);
        this.cbuf = CharBuffer.allocate(this.bufSize);
    }

    protected final void onContentReceived(ContentDecoder decoder, IOControl ioctrl) throws IOException {
        int bytesRead;
        if (this.bbuf == null) {
            throw new IllegalStateException("Byte buffer is null");
        }
        while ((bytesRead = decoder.read(this.bbuf)) > 0) {
            this.bbuf.flip();
            boolean completed = decoder.isCompleted();
            CoderResult result = this.chardecoder.decode(this.bbuf, this.cbuf, completed);
            this.handleDecodingResult(result, ioctrl);
            this.bbuf.compact();
            if (!completed) continue;
            result = this.chardecoder.flush(this.cbuf);
            this.handleDecodingResult(result, ioctrl);
        }
    }

    private void handleDecodingResult(CoderResult result, IOControl ioctrl) throws IOException {
        if (result.isError()) {
            result.throwException();
        }
        this.cbuf.flip();
        if (this.cbuf.hasRemaining()) {
            this.onCharReceived(this.cbuf, ioctrl);
        }
        this.cbuf.clear();
    }

    protected void releaseResources() {
        this.chardecoder = null;
        this.bbuf = null;
        this.cbuf = null;
    }
}

