/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.nio.client.methods;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.UnsupportedCharsetException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpResponse;
import org.apache.http.nio.ContentDecoder;
import org.apache.http.nio.IOControl;
import org.apache.http.nio.client.methods.AbstractHttpAsyncResponseConsumer;
import org.apache.http.util.EntityUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AsyncCharConsumer<T>
extends AbstractHttpAsyncResponseConsumer<T> {
    private final int bufSize;
    private String charsetName;
    private Charset charset;
    private CharsetDecoder chardecoder;
    private ByteBuffer bbuf;
    private CharBuffer cbuf;

    public AsyncCharConsumer(int bufSize) {
        this.bufSize = bufSize;
    }

    public AsyncCharConsumer() {
        this(8192);
    }

    protected abstract void onCharReceived(CharBuffer var1, IOControl var2) throws IOException;

    @Override
    public synchronized void responseReceived(HttpResponse response) throws IOException, HttpException {
        HttpEntity entity = response.getEntity();
        if (entity != null) {
            this.charsetName = EntityUtils.getContentCharSet((HttpEntity)entity);
        }
        if (this.charsetName == null) {
            this.charsetName = "ISO-8859-1";
        }
        super.responseReceived(response);
    }

    @Override
    protected void onContentReceived(ContentDecoder decoder, IOControl ioctrl) throws IOException {
        int bytesRead;
        if (this.charset == null) {
            try {
                this.charset = Charset.forName(this.charsetName);
            }
            catch (UnsupportedCharsetException ex) {
                throw new UnsupportedEncodingException(this.charsetName);
            }
            this.chardecoder = this.charset.newDecoder();
            this.bbuf = ByteBuffer.allocate(this.bufSize);
            this.cbuf = CharBuffer.allocate(this.bufSize);
        }
        while ((bytesRead = decoder.read(this.bbuf)) > 0) {
            this.bbuf.flip();
            boolean completed = decoder.isCompleted();
            CoderResult result = this.chardecoder.decode(this.bbuf, this.cbuf, completed);
            this.handleDecodingResult(result, ioctrl);
            this.bbuf.compact();
            if (!completed) continue;
            result = this.chardecoder.flush(this.cbuf);
            this.handleDecodingResult(result, ioctrl);
        }
    }

    private void handleDecodingResult(CoderResult result, IOControl ioctrl) throws IOException {
        if (result.isError()) {
            result.throwException();
        }
        this.cbuf.flip();
        if (this.cbuf.hasRemaining()) {
            this.onCharReceived(this.cbuf, ioctrl);
        }
        this.cbuf.clear();
    }

    @Override
    void releaseResources() {
        this.charset = null;
        this.chardecoder = null;
        this.bbuf = null;
        this.cbuf = null;
        super.releaseResources();
    }
}

