/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.nio.client.methods;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.http.nio.ContentDecoder;
import org.apache.http.nio.IOControl;
import org.apache.http.nio.client.methods.AbstractHttpAsyncResponseConsumer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AsyncByteConsumer<T>
extends AbstractHttpAsyncResponseConsumer<T> {
    private final int bufSize;
    private ByteBuffer bbuf;

    public AsyncByteConsumer(int bufSize) {
        this.bufSize = bufSize;
    }

    public AsyncByteConsumer() {
        this(8192);
    }

    protected abstract void onByteReceived(ByteBuffer var1, IOControl var2) throws IOException;

    @Override
    protected void onContentReceived(ContentDecoder decoder, IOControl ioctrl) throws IOException {
        int bytesRead;
        if (this.bbuf == null) {
            this.bbuf = ByteBuffer.allocate(this.bufSize);
        }
        while ((bytesRead = decoder.read(this.bbuf)) > 0) {
            this.bbuf.flip();
            this.onByteReceived(this.bbuf, ioctrl);
            this.bbuf.clear();
        }
    }

    @Override
    void releaseResources() {
        this.bbuf = null;
        super.releaseResources();
    }
}

