/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.nio.client;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpException;
import org.apache.http.HttpInetConnection;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.impl.nio.client.HttpExchange;
import org.apache.http.impl.nio.client.MessageState;
import org.apache.http.nio.ContentDecoder;
import org.apache.http.nio.ContentEncoder;
import org.apache.http.nio.IOControl;
import org.apache.http.nio.NHttpClientConnection;
import org.apache.http.nio.NHttpClientHandler;
import org.apache.http.nio.NHttpConnection;
import org.apache.http.nio.client.HttpAsyncExchangeHandler;
import org.apache.http.protocol.HttpContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class NHttpClientProtocolHandler
implements NHttpClientHandler {
    private final Log log = LogFactory.getLog(this.getClass());
    private static final String HTTP_EXCHNAGE = "http.nio.exchange";

    private void closeConnection(NHttpClientConnection conn) {
        try {
            conn.close();
        }
        catch (IOException ex) {
            try {
                conn.shutdown();
            }
            catch (IOException ignore) {
                this.log.debug((Object)("I/O error terminating connection: " + ex.getMessage()), (Throwable)ex);
            }
        }
    }

    protected void shutdownConnection(NHttpClientConnection conn) {
        try {
            conn.shutdown();
        }
        catch (IOException ex) {
            this.log.debug((Object)("I/O error terminating connection: " + ex.getMessage()), (Throwable)ex);
        }
    }

    public void connected(NHttpClientConnection conn, Object attachment) {
        HttpExchange httpexchange = new HttpExchange();
        HttpContext context = conn.getContext();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Connected " + this.formatState((NHttpConnection)conn, httpexchange)));
        }
        context.setAttribute(HTTP_EXCHNAGE, (Object)httpexchange);
        this.requestReady(conn);
    }

    public void closed(NHttpClientConnection conn) {
        HttpContext context = conn.getContext();
        HttpExchange httpexchange = this.getHttpExchange(context);
        HttpAsyncExchangeHandler<?> handler = this.getHandler(context);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Disconnected " + this.formatState((NHttpConnection)conn, httpexchange)));
        }
        if (handler != null) {
            handler.cancel();
        }
    }

    public void exception(NHttpClientConnection conn, HttpException ex) {
        HttpContext context = conn.getContext();
        HttpAsyncExchangeHandler<?> handler = this.getHandler(context);
        this.log.error((Object)("HTTP protocol exception: " + ex.getMessage()), (Throwable)ex);
        if (handler != null) {
            handler.failed((Exception)ex);
        }
        this.closeConnection(conn);
    }

    public void exception(NHttpClientConnection conn, IOException ex) {
        HttpContext context = conn.getContext();
        HttpAsyncExchangeHandler<?> handler = this.getHandler(context);
        this.log.error((Object)("I/O error: " + ex.getMessage()), (Throwable)ex);
        if (handler != null) {
            handler.failed(ex);
        }
        this.shutdownConnection(conn);
    }

    public void requestReady(NHttpClientConnection conn) {
        HttpContext context = conn.getContext();
        HttpExchange httpexchange = this.getHttpExchange(context);
        HttpAsyncExchangeHandler<?> handler = this.getHandler(context);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Request ready " + this.formatState((NHttpConnection)conn, httpexchange)));
        }
        if (httpexchange.getRequestState() != MessageState.READY) {
            return;
        }
        if (handler == null || handler.isDone()) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("No request submitted " + this.formatState((NHttpConnection)conn, httpexchange)));
            }
            return;
        }
        try {
            HttpRequest request = handler.generateRequest();
            httpexchange.setRequest(request);
            HttpEntityEnclosingRequest entityReq = null;
            if (request instanceof HttpEntityEnclosingRequest) {
                entityReq = (HttpEntityEnclosingRequest)request;
            }
            conn.submitRequest(request);
            if (entityReq != null) {
                if (entityReq.expectContinue()) {
                    int timeout = conn.getSocketTimeout();
                    httpexchange.setTimeout(timeout);
                    timeout = request.getParams().getIntParameter("http.protocol.wait-for-continue", 3000);
                    conn.setSocketTimeout(timeout);
                    httpexchange.setRequestState(MessageState.ACK);
                } else {
                    httpexchange.setRequestState(MessageState.BODY_STREAM);
                }
            } else {
                httpexchange.setRequestState(MessageState.COMPLETED);
            }
        }
        catch (IOException ex) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("I/O error: " + ex.getMessage()), (Throwable)ex);
            }
            this.shutdownConnection(conn);
            handler.failed(ex);
        }
        catch (HttpException ex) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("HTTP protocol exception: " + ex.getMessage()), (Throwable)ex);
            }
            this.closeConnection(conn);
            handler.failed((Exception)((Object)ex));
        }
    }

    public void inputReady(NHttpClientConnection conn, ContentDecoder decoder) {
        HttpContext context = conn.getContext();
        HttpExchange httpexchange = this.getHttpExchange(context);
        HttpAsyncExchangeHandler<?> handler = this.getHandler(context);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Input ready " + this.formatState((NHttpConnection)conn, httpexchange)));
        }
        try {
            handler.consumeContent(decoder, (IOControl)conn);
            if (decoder.isCompleted()) {
                this.processResponse(conn, httpexchange, handler);
            }
        }
        catch (IOException ex) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("I/O error: " + ex.getMessage()), (Throwable)ex);
            }
            this.shutdownConnection(conn);
            handler.failed(ex);
        }
    }

    public void outputReady(NHttpClientConnection conn, ContentEncoder encoder) {
        HttpContext context = conn.getContext();
        HttpExchange httpexchange = this.getHttpExchange(context);
        HttpAsyncExchangeHandler<?> handler = this.getHandler(context);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Output ready " + this.formatState((NHttpConnection)conn, httpexchange)));
        }
        try {
            if (httpexchange.getRequestState() == MessageState.ACK) {
                conn.suspendOutput();
                return;
            }
            handler.produceContent(encoder, (IOControl)conn);
            if (encoder.isCompleted()) {
                httpexchange.setRequestState(MessageState.COMPLETED);
            }
        }
        catch (IOException ex) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("I/O error: " + ex.getMessage()), (Throwable)ex);
            }
            this.shutdownConnection(conn);
            handler.failed(ex);
        }
    }

    public void responseReceived(NHttpClientConnection conn) {
        HttpContext context = conn.getContext();
        HttpExchange httpexchange = this.getHttpExchange(context);
        HttpAsyncExchangeHandler<?> handler = this.getHandler(context);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Response received " + this.formatState((NHttpConnection)conn, httpexchange)));
        }
        try {
            HttpResponse response = conn.getHttpResponse();
            HttpRequest request = httpexchange.getRequest();
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode < 200) {
                if (statusCode == 100 && httpexchange.getRequestState() == MessageState.ACK) {
                    int timeout = httpexchange.getTimeout();
                    conn.setSocketTimeout(timeout);
                    conn.requestOutput();
                    httpexchange.setRequestState(MessageState.BODY_STREAM);
                }
                return;
            }
            httpexchange.setResponse(response);
            if (httpexchange.getRequestState() == MessageState.ACK) {
                int timeout = httpexchange.getTimeout();
                conn.setSocketTimeout(timeout);
                conn.resetOutput();
                httpexchange.setRequestState(MessageState.COMPLETED);
            } else if (httpexchange.getRequestState() == MessageState.BODY_STREAM) {
                int timeout = httpexchange.getTimeout();
                conn.setSocketTimeout(timeout);
                conn.suspendOutput();
                conn.resetOutput();
                httpexchange.invalidate();
            }
            handler.responseReceived(response);
            if (!this.canResponseHaveBody(request, response)) {
                conn.resetInput();
                this.processResponse(conn, httpexchange, handler);
            }
        }
        catch (IOException ex) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("I/O error: " + ex.getMessage()), (Throwable)ex);
            }
            this.shutdownConnection(conn);
            handler.failed(ex);
        }
        catch (HttpException ex) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("HTTP protocol exception: " + ex.getMessage()), (Throwable)ex);
            }
            this.closeConnection(conn);
            handler.failed((Exception)((Object)ex));
        }
    }

    public void timeout(NHttpClientConnection conn) {
        HttpContext context = conn.getContext();
        HttpExchange httpexchange = this.getHttpExchange(context);
        HttpAsyncExchangeHandler<?> handler = this.getHandler(context);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Timeout " + this.formatState((NHttpConnection)conn, httpexchange)));
        }
        try {
            if (httpexchange.getRequestState() == MessageState.ACK) {
                int timeout = httpexchange.getTimeout();
                conn.setSocketTimeout(timeout);
                conn.requestOutput();
                httpexchange.setRequestState(MessageState.BODY_STREAM);
            } else if (conn.getStatus() == 0) {
                conn.close();
                if (conn.getStatus() == 1) {
                    conn.setSocketTimeout(250);
                }
            } else {
                conn.shutdown();
            }
        }
        catch (IOException ex) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("I/O error: " + ex.getMessage()), (Throwable)ex);
            }
            this.shutdownConnection(conn);
            handler.failed(ex);
        }
    }

    private HttpExchange getHttpExchange(HttpContext context) {
        return (HttpExchange)context.getAttribute(HTTP_EXCHNAGE);
    }

    private HttpAsyncExchangeHandler<?> getHandler(HttpContext context) {
        return (HttpAsyncExchangeHandler)context.getAttribute("http.nio.async-exchange-handler");
    }

    private void processResponse(NHttpClientConnection conn, HttpExchange httpexchange, HttpAsyncExchangeHandler<?> handler) throws IOException {
        if (!httpexchange.isValid()) {
            conn.close();
        }
        HttpRequest request = httpexchange.getRequest();
        HttpResponse response = httpexchange.getResponse();
        String method = request.getRequestLine().getMethod();
        int status = response.getStatusLine().getStatusCode();
        if (method.equalsIgnoreCase("CONNECT") && status == 200) {
            this.log.debug((Object)"CONNECT method succeeded");
            conn.resetInput();
        } else if (!handler.keepAlive(response)) {
            this.log.debug((Object)"Connection cannot be kept alive");
            conn.close();
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Response processed " + this.formatState((NHttpConnection)conn, httpexchange)));
        }
        handler.responseCompleted();
        httpexchange.reset();
    }

    private boolean canResponseHaveBody(HttpRequest request, HttpResponse response) {
        String method = request.getRequestLine().getMethod();
        int status = response.getStatusLine().getStatusCode();
        if (method.equalsIgnoreCase("HEAD")) {
            return false;
        }
        if (method.equalsIgnoreCase("CONNECT") && status == 200) {
            return false;
        }
        return status >= 200 && status != 204 && status != 304 && status != 205;
    }

    private String formatState(NHttpConnection conn, HttpExchange httpexchange) {
        StringBuilder buf = new StringBuilder();
        buf.append("[");
        if (conn.isOpen() && conn instanceof HttpInetConnection) {
            HttpInetConnection inetconn = (HttpInetConnection)conn;
            buf.append(inetconn.getRemoteAddress());
            buf.append(":");
            buf.append(inetconn.getRemotePort());
        }
        buf.append("(");
        buf.append(conn.isOpen() ? "open" : "closed");
        buf.append("),request=");
        buf.append((Object)httpexchange.getRequestState());
        if (httpexchange.getRequest() != null) {
            buf.append("(");
            buf.append(httpexchange.getRequest().getRequestLine());
            buf.append(")");
        }
        buf.append(",response=");
        buf.append((Object)httpexchange.getResponseState());
        if (httpexchange.getResponse() != null) {
            buf.append("(");
            buf.append(httpexchange.getResponse().getStatusLine());
            buf.append(")");
        }
        buf.append(",valid=");
        buf.append(httpexchange.isValid());
        buf.append("]");
        return buf.toString();
    }
}

