/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.nio.client;

import java.io.IOException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.impl.nio.client.NHttpEntityWrapper;
import org.apache.http.nio.ContentEncoder;
import org.apache.http.nio.IOControl;
import org.apache.http.nio.client.HttpAsyncRequestProducer;
import org.apache.http.nio.entity.ProducingNHttpEntity;

class BasicHttpAsyncRequestProducer
implements HttpAsyncRequestProducer {
    private final HttpHost target;
    private final HttpRequest request;
    private final ProducingNHttpEntity producer;

    public BasicHttpAsyncRequestProducer(HttpHost target, HttpRequest request) {
        if (target == null) {
            throw new IllegalArgumentException("Target host may not be null");
        }
        if (request == null) {
            throw new IllegalArgumentException("HTTP request may not be null");
        }
        this.target = target;
        this.request = request;
        HttpEntity entity = null;
        if (request instanceof HttpEntityEnclosingRequest) {
            entity = ((HttpEntityEnclosingRequest)request).getEntity();
        }
        this.producer = entity != null ? (entity instanceof ProducingNHttpEntity ? (ProducingNHttpEntity)entity : new NHttpEntityWrapper(entity)) : null;
    }

    public HttpRequest generateRequest() {
        return this.request;
    }

    public HttpHost getTarget() {
        return this.target;
    }

    public synchronized void produceContent(ContentEncoder encoder, IOControl ioctrl) throws IOException {
        if (this.producer == null) {
            throw new IllegalStateException("Content producer is null");
        }
        this.producer.produceContent(encoder, ioctrl);
        if (encoder.isCompleted()) {
            this.producer.finish();
        }
    }

    public synchronized boolean isRepeatable() {
        if (this.producer != null) {
            return this.producer.isRepeatable();
        }
        return true;
    }

    public synchronized void resetRequest() {
        try {
            if (this.producer != null) {
                this.producer.finish();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

